package de.keksuccino.fancymenu.mixin.mixins.common.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Invoker;

import javax.annotation.Nullable;
import net.minecraft.class_332;
import net.minecraft.class_8030;

/**
 * Mixin invoker for the private inner class GuiGraphics.ScissorStack.
 * <p>
 * This allows invoking the {@code peek()} method on an instance of the ScissorStack.
 * The mixin targets the class using its fully qualified string name because it is private.
 */
@Mixin(class_332.class_8214.class)
public interface IMixinScissorStack {

    /**
     * Invokes the {@code peek()} method on the ScissorStack instance.
     * <p>
     * This method returns the current scissor rectangle at the top of the stack
     * without removing it.
     *
     * @return The current {@link class_8030} for scissoring, or {@code null} if the stack is empty.
     */
    @Invoker("peek") @Nullable class_8030 invoke_peek_FancyMenu();

}