package de.keksuccino.fancymenu.mixin.mixins.common.client;

import de.keksuccino.fancymenu.util.rendering.ui.FancyMenuUiComponent;
import de.keksuccino.fancymenu.util.rendering.ui.screen.VanillaMouseClickHandlingScreen;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import java.util.List;
import net.minecraft.class_11909;
import net.minecraft.class_364;
import net.minecraft.class_4069;

@Mixin(class_4069.class)
public interface MixinContainerEventHandler {

    /**
     * @reason This restores Minecraft's old UI component click logic to not only click the hovered component, but all of them. The old logic is only used for FancyMenu's components.
     */
    @Inject(method = "mouseClicked", at = @At(value = "HEAD"), cancellable = true)
    private void head_mouseClicked_FancyMenu(class_11909 event, boolean isDoubleClick, CallbackInfoReturnable<Boolean> info) {
        if (this instanceof VanillaMouseClickHandlingScreen) {
            return;
        }
        for (class_364 listener : this.children()) {
            if (listener instanceof FancyMenuUiComponent) {
                if (listener.method_25402(event, isDoubleClick)) {
                    if (listener.method_72784()) {
                        this.setFocused(listener);
                        if (event.method_74245() == 0) {
                            this.setDragging(true);
                        }
                    }
                    info.cancel();
                    return;
                }
            }
        }
    }

    /**
     * @reason This restores Minecraft's old UI component click logic to not only click the hovered component, but all of them. The old logic is only used for FancyMenu's components.
     */
    @Inject(method = "mouseReleased", at = @At("HEAD"), cancellable = true)
    private void head_mouseReleased_FancyMenu(class_11909 event, CallbackInfoReturnable<Boolean> info) {
        if (this instanceof VanillaMouseClickHandlingScreen) {
            return;
        }
        for (class_364 listener : this.children()) {
            if (listener instanceof FancyMenuUiComponent) {
                listener.method_25406(event); // Call mouseReleased for ALL FM listeners
            }
        }
        if (this.getFocused() instanceof FancyMenuUiComponent) {
            if ((event.method_74245() == 0) && this.isDragging()) {
                this.setDragging(false);
            }
            info.cancel();
        }
    }

    @Shadow
    List<? extends class_364> children();

    @Shadow
    @Nullable class_364 getFocused();

    @Shadow
    void setFocused(class_364 focused);

    @Shadow
    boolean isDragging();

    @Shadow
    void setDragging(boolean isDragging);

}
