package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_525;
import net.minecraft.class_5250;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

@Mixin(class_525.class)
public class MixinCreateWorldScreen extends class_437 {

    @Unique private boolean reInitialized_FancyMenu = false;

    protected MixinCreateWorldScreen(class_2561 $$0) {
        super($$0);
    }

    //Make the footer buttons unique for better compatibility with the customization system
    @WrapOperation(method = "init", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/layouts/LinearLayout;addChild(Lnet/minecraft/client/gui/layouts/LayoutElement;)Lnet/minecraft/client/gui/layouts/LayoutElement;"))
    private <T extends class_8021> T wrapAddChildInInit_FancyMenu(class_8667 instance, T layoutElement, Operation<T> original) {

        if (layoutElement instanceof class_4185 b) {
            if (b.method_25369() instanceof class_5250 c) {
                if (c.method_10851() instanceof class_2588 t) {

                    //Create World button
                    if ("selectWorld.create".equals(t.method_11022())) {
                        ((UniqueWidget)b).setWidgetIdentifierFancyMenu("create_world_button");
                    }

                    //Cancel button
                    if ("gui.cancel".equals(t.method_11022())) {
                        ((UniqueWidget)b).setWidgetIdentifierFancyMenu("cancel_button");
                    }

                }
            }
        }

        //Plugin shows param error, but should work (generic T makes plugin go brr)
        return original.call(instance, layoutElement);

    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;blit(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIFFIIII)V"))
    private boolean wrapFooterSeparatorRenderingInRender_FancyMenu(class_332 instance, RenderPipeline $$0, class_2960 $$1, int $$2, int $$3, float $$4, float $$5, int $$6, int $$7, int $$8, int $$9) {
        if (ScreenCustomization.isCustomizationEnabledForScreen(this)) {
            ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getLayerOfScreen(this);
            if (layer != null) {
                return layer.layoutBase.renderScrollListFooterShadow;
            }
        }
        return true;
    }

    /**
     * @reason This fixes FM's menu bar not being clickable until you resize the window in this screen. Yes, it's hacky af, but works.
     */
    @Inject(method = "render", at = @At("HEAD"), cancellable = true)
    private void head_render_FancyMenu(CallbackInfo info) {
        if (!this.reInitialized_FancyMenu) {
            this.reInitialized_FancyMenu = true;
            class_310.method_1551().method_15993();
            info.cancel();
        }
    }

}
