package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.util.rendering.ui.screen.WidgetifiedScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.TextWidget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.net.URI;
import net.minecraft.class_11909;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_418;
import net.minecraft.class_437;

@SuppressWarnings("deprecation")
@WidgetifiedScreen
@Mixin(class_418.class)
public abstract class MixinDeathScreen extends class_437 {

    @Shadow @Final @Nullable private class_2561 causeOfDeath;
    @Shadow private class_2561 deathScore;

    @Unique private TextWidget titleTextFancyMenu;
    @Unique @Nullable private TextWidget causeOfDeathTextFancyMenu;
    @Unique private TextWidget deathScoreTextFancyMenu;

    // dummy constructor
    @SuppressWarnings("all")
    private MixinDeathScreen() {
        super(class_2561.method_43473());
    }

    @Inject(method = "init", at = @At("RETURN"))
    private void after_init_FancyMenu(CallbackInfo info) {
        if (this.isCustomizableFancyMenu()) {
            this.titleTextFancyMenu = this.method_37063(new TextWidget(0, 60, this.field_22789, this.field_22793.field_2000, this.field_22793, this.method_25440()))
                    .setTextAlignment(TextWidget.TextAlignment.CENTER)
                    .setScale(2.0F)
                    .setWidgetIdentifierFancyMenu("death_screen_title");

            if (this.causeOfDeath != null) {
                this.causeOfDeathTextFancyMenu = this.method_37063(new TextWidget(0, 85, this.field_22789, this.field_22793.field_2000, this.field_22793, this.causeOfDeath))
                        .setTextAlignment(TextWidget.TextAlignment.CENTER)
                        .setWidgetIdentifierFancyMenu("death_screen_cause_of_death");
            } else {
                this.causeOfDeathTextFancyMenu = null;
            }

            this.deathScoreTextFancyMenu = this.method_37063(new TextWidget(0, 100, this.field_22789, this.field_22793.field_2000, this.field_22793, this.deathScore))
                    .setTextAlignment(TextWidget.TextAlignment.CENTER)
                    .setWidgetIdentifierFancyMenu("death_screen_score");
        } else {
            this.titleTextFancyMenu = null;
            this.causeOfDeathTextFancyMenu = null;
            this.deathScoreTextFancyMenu = null;
        }
    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;drawCenteredString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;III)V"))
    private boolean cancel_renderCenteredText_FancyMenu(class_332 instance, class_327 font, class_2561 text, int x, int y, int color) {
        if (!this.isCustomizableFancyMenu()) {
            return true;
        }
        if (this.isTitleComponentFancyMenu(text)) {
            return false;
        }
        if (this.isCauseOfDeathComponentFancyMenu(text)) {
            return false;
        }
        if (this.isDeathScoreComponentFancyMenu(text)) {
            return false;
        }
        return true;
    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;renderComponentHoverEffect(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Style;II)V"))
    private boolean cancel_renderHover_FancyMenu(class_332 instance, class_327 font, class_2583 style, int mouseX, int mouseY) {
        return !this.isCustomizableFancyMenu();
    }

    @WrapOperation(method = "mouseClicked", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/DeathScreen;clickUrlAction(Lnet/minecraft/client/Minecraft;Lnet/minecraft/client/gui/screens/Screen;Ljava/net/URI;)Z"))
    private boolean cancel_handleComponentClicked_FancyMenu(class_310 minecraft, class_437 screen, URI uri, Operation<Boolean> original) {
        if (!this.isCustomizableFancyMenu()) return original.call(minecraft, screen, uri);
        return false;
    }

    @Inject(method = "render", at = @At("RETURN"))
    private void after_render_FancyMenu(class_332 graphics, int mouseX, int mouseY, float partialTick, CallbackInfo info) {
        if (!this.isCustomizableFancyMenu()) {
            return;
        }
        if (this.causeOfDeathTextFancyMenu != null) {
            this.renderCauseOfDeathTooltipFancyMenu(graphics, mouseX, mouseY);
        }
    }

    @Inject(method = "mouseClicked", at = @At("HEAD"), cancellable = true)
    private void before_mouseClicked_FancyMenu(class_11909 event, boolean isDoubleClick, CallbackInfoReturnable<Boolean> info) {
        if (!this.isCustomizableFancyMenu() || this.causeOfDeathTextFancyMenu == null || this.causeOfDeath == null) {
            return;
        }
        if (!this.causeOfDeathTextFancyMenu.isTextHovered(event.comp_4798(), event.comp_4799())) {
            return;
        }
        if (((CustomizableWidget)this.causeOfDeathTextFancyMenu).isHiddenFancyMenu()) {
            return;
        }
        class_2583 style = this.causeOfDeathTextFancyMenu.getStyleAtMouseX(event.comp_4798());
        if (style != null && style.method_10970() != null && style.method_10970().method_10845() == class_2558.class_2559.field_11749) {
            this.method_25430(style);
            info.setReturnValue(false);
        }
    }

    @Unique
    private void renderCauseOfDeathTooltipFancyMenu(@NotNull class_332 graphics, int mouseX, int mouseY) {
        if (this.causeOfDeathTextFancyMenu == null || this.causeOfDeath == null) {
            return;
        }
        if (!this.causeOfDeathTextFancyMenu.isTextHovered(mouseX, mouseY)) {
            return;
        }
        if (((CustomizableWidget)this.causeOfDeathTextFancyMenu).isHiddenFancyMenu()) {
            return;
        }
        class_2583 style = this.causeOfDeathTextFancyMenu.getStyleAtMouseX(mouseX);
        if (style != null) {
            graphics.method_51441(this.field_22793, style, mouseX, mouseY);
        }
    }

    @Unique
    private boolean isTitleComponentFancyMenu(@NotNull class_2561 component) {
        class_2561 title = this.method_25440();
        return component == title || component.equals(title);
    }

    @Unique
    private boolean isCauseOfDeathComponentFancyMenu(@NotNull class_2561 component) {
        if (this.causeOfDeath == null) {
            return false;
        }
        return component == this.causeOfDeath || component.equals(this.causeOfDeath);
    }

    @Unique
    private boolean isDeathScoreComponentFancyMenu(@NotNull class_2561 component) {
        return component == this.deathScore || component.equals(this.deathScore);
    }

    @Unique
    private boolean isCustomizableFancyMenu() {
        return ScreenCustomization.isCustomizationEnabledForScreen(this);
    }

}
