package de.keksuccino.fancymenu.mixin.mixins.common.client;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStartLookingAtBlockListener;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStartLookingAtEntityListener;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStopLookingAtBlockListener;
import de.keksuccino.fancymenu.customization.listener.listeners.OnStopLookingAtEntityListener;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import net.minecraft.class_1297;
import net.minecraft.class_1675;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_757.class)
public class MixinGameRenderer {

    @Unique
    private static final double ENTITY_LOOK_DISTANCE_FANCYMENU = 20.0D;
    @Unique
    private static final double BLOCK_LOOK_DISTANCE_FANCYMENU = OnStartLookingAtBlockListener.MAX_LOOK_DISTANCE;

    @Shadow @Final class_310 minecraft;

    @Inject(method = "processBlurEffect", at = @At("HEAD"), cancellable = true)
    private void head_processBlurEffect_FancyMenu(CallbackInfo info) {
        if (RenderingUtils.isMenuBlurringBlocked()) info.cancel();
    }

    @Inject(method = "render", at = @At("HEAD"))
    private void before_render_FancyMenu(class_9779 $$0, boolean $$1, CallbackInfo info) {
        ScreenCustomization.onPreGameRenderTick();
    }

    @Inject(method = "pick(F)V", at = @At("TAIL"))
    private void tail_onPick_FancyMenu(float partialTicks, CallbackInfo info) {

        if (this.minecraft == null) {
            return;
        }

        class_239 hitResult = this.minecraft.field_1765;
        OnStartLookingAtBlockListener startBlockListener = Listeners.ON_START_LOOKING_AT_BLOCK;
        OnStopLookingAtBlockListener stopBlockListener = Listeners.ON_STOP_LOOKING_AT_BLOCK;
        OnStartLookingAtEntityListener startLookingListener = Listeners.ON_START_LOOKING_AT_ENTITY;
        OnStopLookingAtEntityListener stopLookingListener = Listeners.ON_STOP_LOOKING_AT_ENTITY;

        if (hitResult == null) {
            stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            stopLooking_FancyMenu(startLookingListener, stopLookingListener);
            return;
        }

        class_1297 cameraEntity = this.minecraft.method_1560();
        if (cameraEntity == null) {
            stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            stopLooking_FancyMenu(startLookingListener, stopLookingListener);
            return;
        }

        class_243 eyePosition = cameraEntity.method_5836(partialTicks);

        class_3966 extendedEntityHit = findExtendedEntityHit_FancyMenu(cameraEntity, partialTicks);

        if (extendedEntityHit == null && hitResult instanceof class_3966 vanillaEntityHit) {
            extendedEntityHit = vanillaEntityHit;
        }

        if (extendedEntityHit != null) {
            class_1297 targetEntity = extendedEntityHit.method_17782();
            double distance = extendedEntityHit.method_17784().method_1022(eyePosition);
            startLookingListener.onLookAtEntity(targetEntity, distance);
            stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }

        stopLooking_FancyMenu(startLookingListener, stopLookingListener);

        if (!(this.minecraft.field_1687 instanceof class_638 clientLevel)) {
            stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }

        class_239 blockPickResult = cameraEntity.method_5745(BLOCK_LOOK_DISTANCE_FANCYMENU, partialTicks, false);
        if (!(blockPickResult instanceof class_3965 blockHitResult) || blockHitResult.method_17783() != class_239.class_240.field_1332) {
            stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }

        class_2338 blockPos = blockHitResult.method_17777();
        class_2680 blockState = clientLevel.method_8320(blockPos);
        if (blockState.method_26215()) {
            stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }

        double distance = blockHitResult.method_17784().method_1022(eyePosition);
        if (distance > BLOCK_LOOK_DISTANCE_FANCYMENU) {
            stopLookingBlock_FancyMenu(startBlockListener, stopBlockListener);
            return;
        }

        OnStartLookingAtBlockListener.LookedBlockData previousBlock = startBlockListener.getCurrentBlockData();
        if (previousBlock != null) {
            boolean sameBlock = previousBlock.blockPos().equals(blockPos)
                && previousBlock.blockState().equals(blockState)
                && previousBlock.levelKey().equals(clientLevel.method_27983());
            if (!sameBlock) {
                stopBlockListener.onStopLooking(previousBlock);
            }
        }

        startBlockListener.onLookAtBlock(clientLevel, blockHitResult, distance);

    }

    @Unique
    private static void stopLooking_FancyMenu(OnStartLookingAtEntityListener startListener, OnStopLookingAtEntityListener stopListener) {
        OnStartLookingAtEntityListener.LookedEntityData previousEntity = startListener.getCurrentEntityData();
        if (previousEntity != null) {
            stopListener.onStopLooking(previousEntity);
            startListener.clearCurrentEntity();
        }
    }

    @Unique
    private static void stopLookingBlock_FancyMenu(OnStartLookingAtBlockListener startListener, OnStopLookingAtBlockListener stopListener) {
        OnStartLookingAtBlockListener.LookedBlockData previousBlock = startListener.getCurrentBlockData();
        if (previousBlock != null) {
            stopListener.onStopLooking(previousBlock);
        }
        startListener.clearCurrentBlock();
    }

    @Nullable
    @Unique
    private static class_3966 findExtendedEntityHit_FancyMenu(class_1297 cameraEntity, float partialTicks) {
        class_243 eyePosition = cameraEntity.method_5836(partialTicks);
        class_243 viewVector = cameraEntity.method_5828(partialTicks);
        class_243 reachVector = eyePosition.method_1019(viewVector.method_1021(ENTITY_LOOK_DISTANCE_FANCYMENU));
        class_238 searchBox = cameraEntity.method_5829().method_18804(viewVector.method_1021(ENTITY_LOOK_DISTANCE_FANCYMENU)).method_1014(1.0D);
        double maxDistanceSqr = ENTITY_LOOK_DISTANCE_FANCYMENU * ENTITY_LOOK_DISTANCE_FANCYMENU;

        class_3966 entityHitResult = class_1675.method_18075(
            cameraEntity,
            eyePosition,
            reachVector,
            searchBox,
            entity -> !entity.method_7325() && entity.method_5863(),
            maxDistanceSqr
        );

        if (entityHitResult == null) {
            return null;
        }

        class_243 hitLocation = entityHitResult.method_17784();
        double entityDistanceSqr = hitLocation.method_1025(eyePosition);
        if (entityDistanceSqr > maxDistanceSqr) {
            return null;
        }

        class_239 blockHitResult = cameraEntity.method_5745(ENTITY_LOOK_DISTANCE_FANCYMENU, partialTicks, false);
        if (blockHitResult != null && blockHitResult.method_17783() != class_239.class_240.field_1333) {
            double blockDistanceSqr = blockHitResult.method_17784().method_1025(eyePosition);
            if (blockDistanceSqr <= entityDistanceSqr) {
                return null;
            }
        }

        return entityHitResult;
    }

}
