package de.keksuccino.fancymenu.mixin.mixins.common.client;

import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import net.minecraft.class_11908;
import net.minecraft.class_309;
import net.minecraft.class_310;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_309.class)
public abstract class MixinKeyboardHandler {

    @Shadow
    @Final
    private class_310 minecraft;

    /**
     * @reason Fire FancyMenu's key listeners after vanilla processing so they run both in menus and during gameplay.
     */
    @Inject(method = "keyPress", at = @At("RETURN"))
    private void triggerKeyListeners_FancyMenu(long window, int action, class_11908 event, CallbackInfo info) {
        if (window != this.minecraft.method_22683().method_4490()) {
            return;
        }

        if (action == GLFW.GLFW_RELEASE) {
            Listeners.ON_KEY_RELEASED.handleKeyReleased(event.comp_4795(), event.comp_4796(), event.comp_4797());
        } else if (action == GLFW.GLFW_PRESS || action == GLFW.GLFW_REPEAT) {
            Listeners.ON_KEY_PRESSED.handleKeyPressed(event.comp_4795(), event.comp_4796(), event.comp_4797());
        }
    }

}