package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.WrapWithCondition;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.listener.listeners.helpers.WorldSessionTracker;
import de.keksuccino.fancymenu.util.rendering.ui.screen.WidgetifiedScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.RendererWidget;
import de.keksuccino.fancymenu.util.rendering.ui.widget.TextWidget;
import net.minecraft.class_11544;
import net.minecraft.class_11653;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3928;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@WidgetifiedScreen
@Mixin(class_3928.class)
public abstract class MixinLevelLoadingScreen extends class_437 {

    @Shadow @Final private static class_2561 DOWNLOADING_TERRAIN_TEXT;
    @Shadow private class_11653 loadTracker;
    @Shadow private float smoothedProgress;

    @Unique private TextWidget downloadingTerrainText_FancyMenu;
    @Unique private RendererWidget chunkRenderer_FancyMenu;
    @Unique private RendererWidget progressBar_FancyMenu;
    @Unique private boolean worldEnteredNotified_FancyMenu;

    protected MixinLevelLoadingScreen(class_2561 component) {
        super(component);
    }

    @Shadow
    protected abstract void drawProgressBar(class_332 p_433901_, int p_433815_, int p_434324_, int p_433974_, int p_433800_, float p_433827_);

    @Override
    protected void method_25426() {

        if (this.isCustomizableFancyMenu()) {

            this.chunkRenderer_FancyMenu = this.method_37063(new RendererWidget((this.field_22789 / 2) - 50, (this.field_22790 / 2) + 30 - 50, 100, 100,
                    (graphics, mouseX, mouseY, partial, x, y, width1, height1, renderer) -> {
                        this.renderChunkBox_FancyMenu(graphics, x + 50, y + 50);
                    }
            )).setWidgetIdentifierFancyMenu("chunks");

            int progressScreenCenterX = this.field_22789 / 2;
            int progressScreenCenterY = this.field_22790 / 2;
            class_11544 statusView = this.loadTracker.method_72904();
            int progressDefaultY;
            if (statusView != null) {
                int i = progressScreenCenterY - statusView.method_72276() * 2;
                progressDefaultY = i - 9 * 3;
            } else {
                progressDefaultY = progressScreenCenterY - 50;
            }
            int progressDefaultX = progressScreenCenterX - 100;

            this.progressBar_FancyMenu = this.method_37063(new RendererWidget(progressDefaultX, progressDefaultY + 9 + 3, 200, 2, (graphics, mouseX, mouseY, partial, x, y, width1, height1, renderer) -> {
                if (this.loadTracker.method_72906()) {
                    this.drawProgressBar(graphics, x, y, width1, height1, this.smoothedProgress);
                }
            })).setWidgetIdentifierFancyMenu("progress_bar");

            this.downloadingTerrainText_FancyMenu = this.method_37063(TextWidget.of(DOWNLOADING_TERRAIN_TEXT, 0, progressDefaultY, 400))
                    .setTextAlignment(TextWidget.TextAlignment.CENTER)
                    .centerWidget(this)
                    .setWidgetIdentifierFancyMenu("downloading_terrain_text");

        } else {
            this.chunkRenderer_FancyMenu = null;
            this.downloadingTerrainText_FancyMenu = null;
            this.progressBar_FancyMenu = null;
        }

    }

    @Inject(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/LevelLoadingScreen;onClose()V", shift = At.Shift.AFTER))
    private void after_onClose_in_tick_FancyMenu(CallbackInfo info) {
        if (this.worldEnteredNotified_FancyMenu) {
            return;
        }
        if (WorldSessionTracker.hasPendingEntry()) {
            this.worldEnteredNotified_FancyMenu = true;
            WorldSessionTracker.handleWorldEntered(class_310.method_1551());
        }
    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/LevelLoadingScreen;renderChunks(Lnet/minecraft/client/gui/GuiGraphics;IIIILnet/minecraft/server/level/progress/ChunkLoadStatusView;)V"))
    private boolean wrap_renderChunks_in_render_FancyMenu(class_332 j1, int chunkstatus, int l1, int i2, int k1, class_11544 j2) {
        return !this.isCustomizableFancyMenu();
    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/GuiGraphics;drawCenteredString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;III)V"))
    private boolean wrap_drawCenteredString_in_render_FancyMenu(class_332 instance, class_327 p_282901_, class_2561 p_282456_, int p_283083_, int p_282276_, int p_281457_) {
        return !this.isCustomizableFancyMenu();
    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/LevelLoadingScreen;drawProgressBar(Lnet/minecraft/client/gui/GuiGraphics;IIIIF)V"))
    private boolean wrap_drawProgressBar_in_render_FancyMenu(class_3928 instance, class_332 p_433901_, int p_433815_, int p_434324_, int p_433974_, int p_433800_, float p_433827_) {
        return !this.isCustomizableFancyMenu();
    }

    @Unique
    private void renderChunkBox_FancyMenu(@NotNull class_332 graphics, int xCenter, int yCenter) {
        if ((this.loadTracker == null) || (this.loadTracker.method_72904() == null)) return;
        class_3928.method_17538(graphics, xCenter, yCenter, 2, 0, this.loadTracker.method_72904());
    }

    @Unique
    private boolean isCustomizableFancyMenu() {
        return ScreenCustomization.isCustomizationEnabledForScreen(this);
    }

}
