package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import de.keksuccino.fancymenu.mixin.interfaces.LocalPlayerDrowningTracker;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_4081;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_8111;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1309.class)
public abstract class MixinLivingEntity {

    @Unique
    private class_1799 lastBrokenStack_FancyMenu = class_1799.field_8037;

    @Unique
    private String lastBrokenItemType_FancyMenu;

    /** @reason Fire FancyMenu listener when the local player gains a status effect. */
    @Inject(method = "onEffectAdded", at = @At("TAIL"))
    private void after_onEffectAdded_FancyMenu(class_1293 effectInstance, @Nullable class_1297 entity, CallbackInfo ci) {
        class_1309 self = (class_1309)(Object)this;
        if (!(self instanceof class_746)) {
            return;
        }
        class_6880<class_1291> effectHolder = effectInstance.method_5579();
        String effectKey = this.resolveEffectKey_FancyMenu(effectHolder);
        String effectType = this.resolveEffectTypeName_FancyMenu(effectHolder.comp_349());
        Listeners.ON_EFFECT_GAINED.onEffectGained(effectKey, effectType, effectInstance.method_5584());
    }

    /** @reason Fire FancyMenu listener when the local player loses a status effect. */
    @Inject(method = "removeEffectNoUpdate", at = @At("TAIL"))
    private void after_removeEffectNoUpdate_FancyMenu(class_6880<class_1291> effectHolder, CallbackInfoReturnable<class_1293> cir) {
        class_1293 removedInstance = cir.getReturnValue();
        if (removedInstance == null) {
            return;
        }

        class_1309 self = (class_1309)(Object)this;
        if (!(self instanceof class_746)) {
            return;
        }

        class_6880<class_1291> removedEffect = removedInstance.method_5579();
        String effectKey = this.resolveEffectKey_FancyMenu(removedEffect);
        String effectType = this.resolveEffectTypeName_FancyMenu(removedEffect.comp_349());
        Listeners.ON_EFFECT_LOST.onEffectLost(effectKey, effectType);
    }

    /** @reason Fire FancyMenu listener when the local player takes drowning damage. */
    @Inject(method = "handleDamageEvent", at = @At("HEAD"))
    private void before_handleDamageEvent_FancyMenu(class_1282 damageSource, CallbackInfo ci) {
        class_1309 self = (class_1309)(Object)this;
        if (!(self instanceof class_746 localPlayer)) {
            return;
        }
        if (!damageSource.method_49708(class_8111.field_42342)) {
            return;
        }
        LocalPlayerDrowningTracker tracker = (LocalPlayerDrowningTracker)localPlayer;
        if (!tracker.fancymenu$isDrowningActive()) {
            tracker.fancymenu$setDrowningActive(true);
            Listeners.ON_STARTED_DROWNING.onStartedDrowning();
        }
    }

    /** @reason Fire FancyMenu listener when the local player finishes consuming an item. */
    @WrapOperation(method = "completeUsingItem", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;finishUsingItem(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/item/ItemStack;"))
    private class_1799 wrap_finishUsingItem_FancyMenu(class_1799 stack, class_1937 level, class_1309 living, Operation<class_1799> operation) {
        String itemKey = null;
        if (!stack.method_7960()) {
            class_2960 itemLocation = class_7923.field_41178.method_10221(stack.method_7909());
            if (itemLocation != null) {
                itemKey = itemLocation.toString();
            }
        }

        class_1799 result = operation.call(stack, level, living);

        if (itemKey != null && living instanceof class_746) {
            Listeners.ON_ITEM_CONSUMED.onItemConsumed(itemKey);
        }

        return result;
    }

    /** @reason Capture the item that is about to break for the local player. */
    @Inject(method = "handleEntityEvent", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;breakItem(Lnet/minecraft/world/item/ItemStack;)V"))
    private void before_breakItem_FancyMenu(byte eventId, CallbackInfo ci) {
        this.captureBrokenItem_FancyMenu(eventId);
    }

    /** @reason Fire FancyMenu listener after the item break animation for the local player. */
    @Inject(method = "handleEntityEvent", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;breakItem(Lnet/minecraft/world/item/ItemStack;)V", shift = At.Shift.AFTER))
    private void after_breakItem_FancyMenu(byte eventId, CallbackInfo ci) {
        class_1309 self = (class_1309)(Object)this;
        if (!(self instanceof class_746) || this.lastBrokenStack_FancyMenu.method_7960()) {
            this.clearBrokenItemCache_FancyMenu();
            return;
        }

        class_2960 itemLocation = class_7923.field_41178.method_10221(this.lastBrokenStack_FancyMenu.method_7909());
        String itemKey = itemLocation != null ? itemLocation.toString() : null;
        Listeners.ON_ITEM_BROKE.onItemBroke(itemKey, this.lastBrokenItemType_FancyMenu);
        this.clearBrokenItemCache_FancyMenu();
    }

    /** @reason Fire FancyMenu listener when the local player jumps. */
    @Inject(method = "jumpFromGround", at = @At("TAIL"))
    private void after_jumpFromGround_FancyMenu(CallbackInfo info) {
        if ((Object)this instanceof class_746) {
            Listeners.ON_JUMP.onJump();
        }
    }

    @Unique
    private void captureBrokenItem_FancyMenu(byte eventId) {
        this.clearBrokenItemCache_FancyMenu();

        class_1309 self = (class_1309)(Object)this;
        if (!(self instanceof class_746 localPlayer)) {
            return;
        }

        class_1304 slot = this.mapEquipmentSlot_FancyMenu(eventId);
        if (slot == null) {
            return;
        }

        class_1799 stack = localPlayer.method_6118(slot);
        if (stack.method_7960()) {
            return;
        }

        this.lastBrokenStack_FancyMenu = stack.method_7972();
        this.lastBrokenItemType_FancyMenu = this.resolveItemType_FancyMenu(slot, stack);
    }

    @Unique
    private void clearBrokenItemCache_FancyMenu() {
        this.lastBrokenStack_FancyMenu = class_1799.field_8037;
        this.lastBrokenItemType_FancyMenu = null;
    }

    @Unique
    private class_1304 mapEquipmentSlot_FancyMenu(byte eventId) {
        return switch (eventId) {
            case 47 -> class_1304.field_6173;
            case 48 -> class_1304.field_6171;
            case 49 -> class_1304.field_6169;
            case 50 -> class_1304.field_6174;
            case 51 -> class_1304.field_6172;
            case 52 -> class_1304.field_6166;
            case 65 -> class_1304.field_48824;
            default -> null;
        };
    }

    @Unique
    private String resolveEffectTypeName_FancyMenu(class_1291 effect) {
        class_4081 category = effect.method_18792();
        return switch (category) {
            case field_18271 -> "positive";
            case field_18272 -> "negative";
            case field_18273 -> "neutral";
        };
    }

    @Unique
    private String resolveEffectKey_FancyMenu(class_6880<class_1291> effectHolder) {
        return effectHolder.method_40230()
                .map(key -> key.method_29177().toString())
                .orElseGet(() -> {
                    class_2960 fallback = class_7923.field_41174.method_10221(effectHolder.comp_349());
                    return fallback != null ? fallback.toString() : "unknown";
                });
    }

    @Unique
    private String resolveItemType_FancyMenu(class_1304 slot, class_1799 stack) {
        if (slot == class_1304.field_48824 || slot.method_5925() == class_1304.class_1305.field_6178) {
            return "armor";
        }
        if ((slot == class_1304.field_6173 || slot == class_1304.field_6171) && stack.method_7963()) {
            return "tool";
        }
        return "other";
    }

}

