package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.keksuccino.fancymenu.customization.gameintro.GameIntroOverlay;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import de.keksuccino.fancymenu.events.screen.ScreenMouseMoveEvent;
import de.keksuccino.fancymenu.events.screen.ScreenMouseScrollEvent;
import de.keksuccino.fancymenu.util.VanillaEvents;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.mcef.BrowserHandler;
import de.keksuccino.fancymenu.util.mcef.MCEFUtil;
import de.keksuccino.fancymenu.util.rendering.ui.FancyMenuUiComponent;
import net.minecraft.class_11910;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_364;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_312.class)
public class MixinMouseHandler {

    @Shadow private double xpos;
    @Shadow private double ypos;
    @Shadow private double accumulatedDX;
    @Shadow private double accumulatedDY;

    @Unique private final class_310 mc_FancyMenu = class_310.method_1551();

    /**
     * @reason This restores Minecraft's old UI component scroll logic to not only scroll the hovered component, but all of them. The old logic is only used for FancyMenu's components.
     */
    @WrapOperation(method = "onScroll", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/Screen;mouseScrolled(DDDD)Z"))
    private boolean wrap_Screen_mouseScrolled_in_onScroll_FancyMenu(class_437 instance, double mouseX, double mouseY, double scrollX, double scrollY, Operation<Boolean> original) {
        this.beforeMouseScrollScreen_FancyMenu(scrollX, scrollY);
        for (class_364 listener : instance.method_25396()) {
            if (listener instanceof FancyMenuUiComponent) {
                if (listener.method_25401(mouseX, mouseY, scrollX, scrollY)) {
                    this.afterMouseScrollScreen_FancyMenu(scrollX, scrollY);
                    return true;
                }
            }
        }
        boolean b = original.call(instance, mouseX, mouseY, scrollX, scrollY);
        this.afterMouseScrollScreen_FancyMenu(scrollX, scrollY);
        return b;
    }

    @Unique
    private void beforeMouseScrollScreen_FancyMenu(double scrollX, double scrollY) {
        boolean isDiscrete = mc_FancyMenu.field_1690.method_42439().method_41753();
        double wheelSensitivity = mc_FancyMenu.field_1690.method_41806().method_41753();
        double scrollDeltaX = (isDiscrete ? Math.signum(scrollX) : scrollX) * wheelSensitivity;
        double scrollDeltaY = (isDiscrete ? Math.signum(scrollY) : scrollY) * wheelSensitivity;
        double mX = this.xpos * (double)this.mc_FancyMenu.method_22683().method_4486() / (double)this.mc_FancyMenu.method_22683().method_4480();
        double mY = this.ypos * (double)this.mc_FancyMenu.method_22683().method_4502() / (double)this.mc_FancyMenu.method_22683().method_4507();
        EventHandler.INSTANCE.postEvent(new ScreenMouseScrollEvent.Pre(mc_FancyMenu.field_1755, mX, mY, scrollDeltaX, scrollDeltaY));
    }

    @Unique
    private void afterMouseScrollScreen_FancyMenu(double scrollX, double scrollY) {
        boolean isDiscrete = mc_FancyMenu.field_1690.method_42439().method_41753();
        double wheelSensitivity = mc_FancyMenu.field_1690.method_41806().method_41753();
        double scrollDeltaX = (isDiscrete ? Math.signum(scrollX) : scrollX) * wheelSensitivity;
        double scrollDeltaY = (isDiscrete ? Math.signum(scrollY) : scrollY) * wheelSensitivity;
        double mX = this.xpos * (double)this.mc_FancyMenu.method_22683().method_4486() / (double)this.mc_FancyMenu.method_22683().method_4480();
        double mY = this.ypos * (double)this.mc_FancyMenu.method_22683().method_4502() / (double)this.mc_FancyMenu.method_22683().method_4507();
        ScreenMouseScrollEvent.Post e = new ScreenMouseScrollEvent.Post(mc_FancyMenu.field_1755, mX, mY, scrollDeltaX, scrollDeltaY);
        EventHandler.INSTANCE.postEvent(e);
    }

    /**
     * @reason Fire FancyMenu's mouse button listeners after vanilla processing so they run once per press/release.
     */
    @Inject(method = "onButton", at = @At("RETURN"))
    private void triggerMouseButtonListeners_FancyMenu(long window, class_11910 buttonInfo, int action, CallbackInfo info) {
        if (window != this.mc_FancyMenu.method_22683().method_4490()) {
            return;
        }
        double guiWidth = this.mc_FancyMenu.method_22683().method_4486();
        double guiHeight = this.mc_FancyMenu.method_22683().method_4502();
        double screenWidth = this.mc_FancyMenu.method_22683().method_4480();
        double screenHeight = this.mc_FancyMenu.method_22683().method_4507();
        double mouseX = this.xpos * guiWidth / screenWidth;
        double mouseY = this.ypos * guiHeight / screenHeight;
        if (action == GLFW.GLFW_PRESS) {
            Listeners.ON_MOUSE_BUTTON_CLICKED.onMouseButtonClicked(buttonInfo.comp_4801(), mouseX, mouseY);
        } else if (action == GLFW.GLFW_RELEASE) {
            Listeners.ON_MOUSE_BUTTON_RELEASED.onMouseButtonReleased(buttonInfo.comp_4801(), mouseX, mouseY);
        }
    }

    @WrapOperation(method = "handleAccumulatedMovement", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/Screen;mouseMoved(DD)V"))
    private void wrap_mouseMoved_in_handleAccumulatedMovement_FancyMenu(class_437 instance, double mouseX, double mouseY, Operation<Void> original) {
        double guiWidth = this.mc_FancyMenu.method_22683().method_4486();
        double guiHeight = this.mc_FancyMenu.method_22683().method_4502();
        double screenWidth = this.mc_FancyMenu.method_22683().method_4480();
        double screenHeight = this.mc_FancyMenu.method_22683().method_4507();
        double deltaX = this.accumulatedDX * guiWidth / screenWidth;
        double deltaY = this.accumulatedDY * guiHeight / screenHeight;
        EventHandler.INSTANCE.postEvent(new ScreenMouseMoveEvent(this.mc_FancyMenu.field_1755, mouseX, mouseY, deltaX, deltaY));
        if (MCEFUtil.isMCEFLoaded()) BrowserHandler.mouseMoved(mouseX, mouseY);
        original.call(instance, mouseX, mouseY);
    }

    @WrapOperation(method = "onButton", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/MouseHandler;simulateRightClick(Lnet/minecraft/client/input/MouseButtonInfo;Z)Lnet/minecraft/client/input/MouseButtonInfo;"))
    private class_11910 wrap_simulateRightClick_in_onButton_FancyMenu(class_312 instance, class_11910 infoIn, boolean pressed, Operation<class_11910> original) {

        // Cache latest MouseButtonInfo
        class_11910 info = original.call(instance, infoIn, pressed);
        VanillaEvents.updateLatestVanillaMouseButtonInfo(info);

        // Handle clicks in GameIntroOverlay
        if (pressed && (class_310.method_1551().method_18506() instanceof GameIntroOverlay o)) {
            o.mouseClicked(VanillaEvents.mouseButtonEvent(), false);
        }

        return info;

    }

}
