package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_636.class)
public class MixinMultiPlayerGameMode {

    @Unique
    @Nullable
    private String capturedItemUseKey_FancyMenu;

    @Unique
    @Nullable
    private String capturedUseItemKey_FancyMenu;

    /** @reason Fire FancyMenu listener after the local player successfully breaks a block. */
    @WrapOperation(method = "destroyBlock", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/block/Block;destroy(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"))
    private void wrap_destroy_in_destroyBlock_FancyMenu(class_2248 block, class_1936 level, class_2338 pos, class_2680 state, Operation<Void> operation) {
        String usedItemKey = this.getMainHandItemKey_FancyMenu();
        operation.call(block, level, pos, state);
        if (level != null && level.method_8608()) {
            Listeners.ON_BLOCK_BROKE.onBlockBroke(pos, state, usedItemKey);
        }
    }

    /** @reason Capture the item key before the local player uses an item on a block. */
    @Inject(method = "performUseItemOn", at = @At("HEAD"))
    private void before_performUseItemOn_captureItem_FancyMenu(class_746 player, class_1268 hand, class_3965 hitResult, CallbackInfoReturnable<class_1269> cir) {
        this.capturedItemUseKey_FancyMenu = this.resolveItemKeyFromHand_FancyMenu(player, hand);
    }

    /** @reason Fire FancyMenu listeners when the local player interacts with a block. */
    @Inject(method = "performUseItemOn", at = @At("RETURN"))
    private void after_performUseItemOn_FancyMenu(class_746 player, class_1268 hand, class_3965 hitResult, CallbackInfoReturnable<class_1269> cir) {
        class_1269 result = cir.getReturnValue();
        if ((result != null) && result.method_23665()) {
            class_310 minecraft = class_310.method_1551();
            class_1937 level = minecraft.field_1687;
            class_2338 blockPos = hitResult.method_17777().method_10062();
            class_2680 state = null;
            String blockKey = "";
            String targetPosX = "-1";
            String targetPosY = "-1";
            String targetPosZ = "-1";

            if ((level != null) && level.method_8477(blockPos)) {
                state = level.method_8320(blockPos);
                blockKey = this.resolveBlockKey_FancyMenu(state);
                targetPosX = Integer.toString(blockPos.method_10263());
                targetPosY = Integer.toString(blockPos.method_10264());
                targetPosZ = Integer.toString(blockPos.method_10260());
                Listeners.ON_INTERACTED_WITH_BLOCK.onBlockInteracted(blockPos, state);
            }

            String itemKey = this.capturedItemUseKey_FancyMenu;
            if (itemKey == null) {
                itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
            }

            Listeners.ON_ITEM_USED.onItemUsed(itemKey, "block", "", blockKey, targetPosX, targetPosY, targetPosZ);
        }

        this.capturedItemUseKey_FancyMenu = null;
    }

    /** @reason Fire FancyMenu listener when the local player places a block. */
    @WrapOperation(method = "performUseItemOn", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/item/ItemStack;useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;"))
    private class_1269 wrap_useOn_FancyMenu(class_1799 stack, class_1838 context, Operation<class_1269> operation) {
        class_1747 blockItem = (stack.method_7909() instanceof class_1747) ? (class_1747)stack.method_7909() : null;
        class_2338 placePos = null;
        if (blockItem != null) {
            placePos = new class_1750(context).method_8037();
        }

        class_1269 result = operation.call(stack, context);

        if ((blockItem != null) && (result != null) && result.method_23665()) {
            class_1937 level = context.method_8045();
            if ((level != null) && level.method_8608() && (placePos != null)) {
                class_2680 placedState = level.method_8320(placePos);
                if (placedState.method_27852(blockItem.method_7711())) {
                    Listeners.ON_BLOCK_PLACED.onBlockPlaced(placePos, placedState);
                }
            }
        }

        return result;
    }

    /** @reason Cache the item key before the local player uses an item without targeting a block or entity. */
    @Inject(method = "useItem", at = @At("HEAD"))
    private void before_useItem_captureItem_FancyMenu(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (player instanceof class_746) {
            this.capturedUseItemKey_FancyMenu = this.resolveItemKeyFromHand_FancyMenu(player, hand);
        } else {
            this.capturedUseItemKey_FancyMenu = null;
        }
    }

    /** @reason Fire FancyMenu listener when the local player successfully uses an item without a direct target. */
    @Inject(method = "useItem", at = @At("RETURN"))
    private void after_useItem_FancyMenu(class_1657 player, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        class_1269 result = cir.getReturnValue();
        if ((player instanceof class_746 localPlayer) && (result != null) && result.method_23665()) {
            String itemKey = this.capturedUseItemKey_FancyMenu;
            if (itemKey == null) {
                itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
            }
            String usedOnType = "none";
            String entityKey = "";
            String targetPosX = "-1";
            String targetPosY = "-1";
            String targetPosZ = "-1";
            if (localPlayer.method_6115()) {
                usedOnType = "self";
                entityKey = this.resolveEntityKey_FancyMenu(localPlayer);
                targetPosX = Double.toString(localPlayer.method_23317());
                targetPosY = Double.toString(localPlayer.method_23318());
                targetPosZ = Double.toString(localPlayer.method_23321());
            }
            Listeners.ON_ITEM_USED.onItemUsed(itemKey, usedOnType, entityKey, "", targetPosX, targetPosY, targetPosZ);
        }
        this.capturedUseItemKey_FancyMenu = null;
    }

    /** @reason Fire FancyMenu listener when the local player interacts with an entity. */
    @WrapOperation(method = "interact", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;interactOn(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"))
    private class_1269 wrap_interactWithEntity_FancyMenu(class_1657 player, class_1297 target, class_1268 hand, Operation<class_1269> original) {
        String itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
        class_1269 result = original.call(player, target, hand);
        if (itemKey == null) {
            itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
        }
        this.handleEntityInteractionResult_FancyMenu(player, target, result, itemKey);
        return result;
    }

    /** @reason Fire FancyMenu listener when the local player interacts with an entity at a precise location. */
    @WrapOperation(method = "interactAt", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;interactAt(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"))
    private class_1269 wrap_interactAtWithEntity_FancyMenu(class_1297 target, class_1657 player, class_243 hitVec, class_1268 hand, Operation<class_1269> original) {
        String itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
        class_1269 result = original.call(target, player, hitVec, hand);
        if (itemKey == null) {
            itemKey = this.resolveItemKeyFromHand_FancyMenu(player, hand);
        }
        this.handleEntityInteractionResult_FancyMenu(player, target, result, itemKey);
        return result;
    }

    @Unique
    private void handleEntityInteractionResult_FancyMenu(class_1657 player, class_1297 target, class_1269 result, @Nullable String itemKey) {
        if (!(player instanceof class_746) || target == null) {
            return;
        }
        if (result == null || !result.method_23665()) {
            return;
        }
        String entityKey = this.resolveEntityKey_FancyMenu(target);
        Listeners.ON_ITEM_USED.onItemUsed(itemKey, "entity", entityKey, "",
                Double.toString(target.method_23317()),
                Double.toString(target.method_23318()),
                Double.toString(target.method_23321()));
        Listeners.ON_INTERACTED_WITH_ENTITY.onEntityInteracted(target);
    }

    @Unique
    private String getMainHandItemKey_FancyMenu() {
        class_310 minecraft = class_310.method_1551();
        class_746 localPlayer = minecraft.field_1724;
        if (localPlayer == null) {
            return null;
        }
        return this.resolveItemKey_FancyMenu(localPlayer.method_6047());
    }

    @Unique
    @Nullable
    private String resolveItemKeyFromHand_FancyMenu(@Nullable class_1657 player, @Nullable class_1268 hand) {
        if (player == null || hand == null) {
            return null;
        }
        return this.resolveItemKey_FancyMenu(player.method_5998(hand));
    }

    @Unique
    @Nullable
    private String resolveItemKey_FancyMenu(@Nullable class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return null;
        }
        class_2960 itemLocation = class_7923.field_41178.method_10221(stack.method_7909());
        return itemLocation != null ? itemLocation.toString() : null;
    }

    @Unique
    private String resolveBlockKey_FancyMenu(@Nullable class_2680 state) {
        if (state == null) {
            return "";
        }
        class_2960 blockLocation = class_7923.field_41175.method_10221(state.method_26204());
        return blockLocation != null ? blockLocation.toString() : "";
    }

    @Unique
    private String resolveEntityKey_FancyMenu(@Nullable class_1297 entity) {
        if (entity == null) {
            return "";
        }
        class_2960 entityLocation = class_7923.field_41177.method_10221(entity.method_5864());
        return entityLocation != null ? entityLocation.toString() : "";
    }
}

