package de.keksuccino.fancymenu.mixin.mixins.common.client;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.events.screen.RenderedScreenBackgroundEvent;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.widget.*;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4399;
import net.minecraft.class_442;
import net.minecraft.class_7077;
import net.minecraft.class_8020;
import net.minecraft.class_8519;
import net.minecraft.client.gui.components.*;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_442.class)
public abstract class MixinTitleScreen extends class_437 {

    @Shadow @Final private static class_2561 COPYRIGHT_TEXT;
    @Shadow public boolean fading;
    @Shadow private @Nullable class_4399 realmsNotificationsScreen;

    @Unique private int cached_mouseX_FancyMenu = -1;
    @Unique private int cached_mouseY_FancyMenu = -1;
    @Unique private float cached_partial_FancyMenu = -1f;

    //unused dummy constructor
    @SuppressWarnings("all")
    private MixinTitleScreen() {
        super(null);
    }

    @Inject(method = "init", at = @At("RETURN"))
    private void after_init_FancyMenu(CallbackInfo info) {

        // Give the Copyright button and identifier
        this.method_25396().forEach(guiEventListener -> {
            if (guiEventListener instanceof class_7077 b) {
                if (b.method_25369() == COPYRIGHT_TEXT) ((UniqueWidget)b).setWidgetIdentifierFancyMenu("title_screen_copyright_button");
            }
        });

        // Add widgets for all Title screen elements to make them editable

        MinecraftLogoRenderer logo = MinecraftLogoRenderer.DEFAULT_INSTANCE;
        this.method_37063(new RendererWidget((this.field_22789 / 2) - (logo.getWidth() / 2), 30, logo.getWidth(), logo.getHeight(),
                        (graphics, mouseX, mouseY, partial, x, y, width, height, renderer) -> {
                            logo.renderLogoAtPosition(graphics, x, y, renderer.getAlpha());
                        }))
                .setWidgetIdentifierFancyMenu("minecraft_logo_widget")
                .method_25355(class_2561.method_43471("fancymenu.widgetified_screens.title_screen.logo"));

        MinecraftSplashRenderer splash = MinecraftSplashRenderer.DEFAULT_INSTANCE;
        this.method_37063(new RendererWidget(splash.getDefaultPositionX(this.field_22789) - 50, splash.getDefaultPositionY() - 20, 100, 40,
                        (graphics, mouseX, mouseY, partial, x, y, width, height, renderer) -> {
                            int splashColor = class_3532.method_15386(renderer.getAlpha() * 255.0F) << 24;
                            splash.renderAt(graphics, x + (width / 2), y + (height / 2), class_310.method_1551().field_1772, splashColor);
                        }))
                .setWidgetIdentifierFancyMenu("minecraft_splash_widget")
                .method_25355(class_2561.method_43471("fancymenu.widgetified_screens.title_screen.splash"));

        if (this.realmsNotificationsScreen != null) {
            RealmsNotificationRenderer notifications = new RealmsNotificationRenderer(this.realmsNotificationsScreen, this.field_22789, this.field_22790);
            int totalWidth = notifications.getTotalWidth();
            if (totalWidth == 0) totalWidth = 50;
            this.method_37063(new RendererWidget(notifications.getDefaultPositionX(), notifications.getDefaultPositionY(), totalWidth, notifications.getTotalHeight(),
                            (graphics, mouseX, mouseY, partial, x, y, width, height, renderer) -> {
                                notifications.renderIcons(graphics, x, y, DrawableColor.WHITE.getColorIntWithAlpha(renderer.getAlpha()));
                            }))
                    .setWidgetIdentifierFancyMenu("minecraft_realms_notification_icons_widget")
                    .method_25355(class_2561.method_43471("fancymenu.widgetified_screens.title_screen.realmsnotification"));
        }

        BrandingRenderer branding = new BrandingRenderer(this.field_22790);
        this.method_37063(new RendererWidget(branding.getDefaultPositionX(), branding.getDefaultPositionY() + 1, branding.getTotalWidth(), branding.getTotalHeight(),
                        (graphics, mouseX, mouseY, partial, x, y, width, height, renderer) -> {
                            branding.setOpacity(renderer.getAlpha());
                            branding.render(graphics, x, y);
                        }))
                .setWidgetIdentifierFancyMenu("minecraft_branding_widget")
                .method_25355(class_2561.method_43471("fancymenu.widgetified_screens.title_screen.branding"));

    }

    @Inject(method = "render", at = @At("HEAD"))
    private void before_render_FancyMenu(class_332 graphics, int mouseX, int mouseY, float partial, CallbackInfo info) {
        this.cached_mouseX_FancyMenu = mouseX;
        this.cached_mouseY_FancyMenu = mouseY;
        this.cached_partial_FancyMenu = partial;
        //Disable fading if customizations enabled, so FancyMenu can properly handle widget alpha
        if (ScreenCustomization.isCustomizationEnabledForScreen(this)) {
            this.fading = false;
        }
    }

    /**
     * @reason Manually fire FancyMenu's {@link RenderedScreenBackgroundEvent} in {@link class_442}, because normal event doesn't work correctly here.
     */
    @WrapOperation(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screens/TitleScreen;renderPanorama(Lnet/minecraft/client/gui/GuiGraphics;F)V"))
    private void wrap_renderPanorama_FancyMenu(class_442 instance, class_332 graphics, float f, Operation<Void> original) {
        ScreenCustomizationLayer l = ScreenCustomizationLayerHandler.getLayerOfScreen(this);
        if ((l != null) && ScreenCustomization.isCustomizationEnabledForScreen(this)) {
            if (!l.layoutBase.menuBackgrounds.isEmpty()) {
                //Render a black background before the custom background gets rendered
                graphics.method_25294(0, 0, this.field_22789, this.field_22790, 0);
            } else {
                original.call(instance, graphics, f);
            }
        } else {
            original.call(instance, graphics, f);
        }
        EventHandler.INSTANCE.postEvent(new RenderedScreenBackgroundEvent(this, graphics, this.cached_mouseX_FancyMenu, this.cached_mouseY_FancyMenu, this.cached_partial_FancyMenu));
    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lcom/mojang/realmsclient/gui/screens/RealmsNotificationsScreen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"))
    private boolean cancel_VanillaRealmsNotificationRendering_FancyMenu(class_4399 instance, class_332 $$0, int $$1, int $$2, float $$3) {
        return false;
    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/LogoRenderer;renderLogo(Lnet/minecraft/client/gui/GuiGraphics;IF)V"))
    private boolean cancel_VanillaLogoRendering_FancyMenu(class_8020 instance, class_332 $$0, int $$1, float $$2) {
        return false;
    }

    @WrapWithCondition(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/components/SplashRenderer;render(Lnet/minecraft/client/gui/GuiGraphics;ILnet/minecraft/client/gui/Font;F)V"))
    private boolean cancel_VanillaSplashRendering_FancyMenu(class_8519 instance, class_332 $$0, int $$1, class_327 $$2, float $$3) {
        return false;
    }

}
