package de.keksuccino.fancymenu.networking;

import de.keksuccino.fancymenu.networking.packets.handshake.HandshakePacket;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import static de.keksuccino.fancymenu.networking.PacketHandler.FANCYMENU_SERVERS;

public class ClientPacketUtils {

    protected static boolean shouldSendToServer(@NotNull Packet packet) {
        if (packet instanceof HandshakePacket) return true;
        String ip = getConnectedServerIp();
        if (ip == null) return false;
        if (!FANCYMENU_SERVERS.contains(ip)) return false;
        return true;
    }

    @Nullable
    public static String getConnectedServerIp() {
        if (class_310.method_1551().method_1562() == null) return null;
        if (class_310.method_1551().method_1562().method_45734() == null) return "local_lan_world";
        return class_310.method_1551().method_1562().method_45734().field_3761;
    }

}
