package de.keksuccino.fancymenu.util;

import de.keksuccino.fancymenu.util.input.MouseUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.Objects;
import net.minecraft.class_11909;
import net.minecraft.class_11910;

public class VanillaEvents {

    private static final Logger LOGGER = LogManager.getLogger();

    public static final int GLFW_NO_MODIFIERS = 0;

    @Nullable
    private static class_11910 latestVanillaMouseButtonInfo = null;
    private static long latestVanillaMouseButtonInfoCachingTime = -1L;

    @NotNull
    public static class_11910 getLatestVanillaMouseButtonInfoOrDummy() {
        long now = System.currentTimeMillis();
        if ((latestVanillaMouseButtonInfoCachingTime != -1L) && ((latestVanillaMouseButtonInfoCachingTime + 2000) < now)) {
            LOGGER.warn("[FANCYMENU] Getting an possibly outdated latestVanillaMouseButtonInfo! Last caching time is more than 2 seconds in the past! This should be avoided.", new Exception("Outdated MouseButtonInfo in VanillaEvents!"));
        }
        if (latestVanillaMouseButtonInfo != null) return latestVanillaMouseButtonInfo;
        LOGGER.warn("[FANCYMENU] Getting latestVanillaMouseButtonInfo before caching it! This should be avoided.", new Exception("No MouseButtonInfo cached in VanillaEvents!"));
        return new class_11910(0, -1);
    }

    public static void updateLatestVanillaMouseButtonInfo(@NotNull class_11910 info) {
        latestVanillaMouseButtonInfoCachingTime = System.currentTimeMillis();
        latestVanillaMouseButtonInfo = Objects.requireNonNull(info);
    }

    /**
     * Will create a new {@link class_11909}.
     */
    @NotNull
    public static class_11909 mouseButtonEvent(double mouseX, double mouseY, @NotNull class_11910 info) {
        return new class_11909(mouseX, mouseY, info);
    }

    /**
     * Will create a new {@link class_11909} with a new {@link class_11910}, using the provided {@code button} and {@code modifiers} parameters.
     */
    @NotNull
    public static class_11909 mouseButtonEvent(double mouseX, double mouseY, int button, int modifiers) {
        return mouseButtonEvent(mouseX, mouseY, new class_11910(button, modifiers));
    }

    /**
     * Will create a new {@link class_11909} with a new {@link class_11910}, using the provided {@code button} parameter and {@link class_11910#comp_4797()} from the {@link VanillaEvents#latestVanillaMouseButtonInfo}.
     */
    @NotNull
    public static class_11909 mouseButtonEvent(double mouseX, double mouseY, int button) {
        class_11910 cached = getLatestVanillaMouseButtonInfoOrDummy();
        return mouseButtonEvent(mouseX, mouseY, new class_11910(button, cached.comp_4797()));
    }

    /**
     * Will create a new {@link class_11909}, automatically resolve the {@code mouseX} and {@code mouseY} coordinates and create a new {@link class_11910}, using the provided {@code button} parameter and {@link class_11910#comp_4797()} from the {@link VanillaEvents#latestVanillaMouseButtonInfo}.
     */
    @NotNull
    public static class_11909 mouseButtonEvent(int button) {
        class_11910 cached = getLatestVanillaMouseButtonInfoOrDummy();
        return mouseButtonEvent(MouseUtils.getScaledMouseX(), MouseUtils.getScaledMouseY(), new class_11910(button, cached.comp_4797()));
    }

    /**
     * Will create a new {@link class_11909}, automatically resolve the {@code mouseX} and {@code mouseY} coordinates and create a new {@link class_11910}, using the provided {@code button} and {@code modifiers} parameters.
     */
    @NotNull
    public static class_11909 mouseButtonEvent(int button, int modifiers) {
        return mouseButtonEvent(MouseUtils.getScaledMouseX(), MouseUtils.getScaledMouseY(), new class_11910(button, modifiers));
    }

    /**
     * Will create a new {@link class_11909} and use the cached {@link VanillaEvents#latestVanillaMouseButtonInfo} as {@link class_11910}.
     */
    @NotNull
    public static class_11909 mouseButtonEvent(double mouseX, double mouseY) {
        return mouseButtonEvent(mouseX, mouseY, getLatestVanillaMouseButtonInfoOrDummy());
    }

    /**
     * Will create a new {@link class_11909}, automatically resolve the {@code mouseX} and {@code mouseY} coordinates and use the cached {@link VanillaEvents#latestVanillaMouseButtonInfo} as {@link class_11910}.
     */
    @NotNull
    public static class_11909 mouseButtonEvent() {
        return mouseButtonEvent(MouseUtils.getScaledMouseX(), MouseUtils.getScaledMouseY(), getLatestVanillaMouseButtonInfoOrDummy());
    }

}
