package de.keksuccino.fancymenu.util.auth;

import de.keksuccino.fancymenu.platform.Services;
import de.keksuccino.fancymenu.util.mod.UniversalModContainer;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_408;
import net.minecraft.class_418;
import net.minecraft.class_429;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_465;
import net.minecraft.class_4667;
import net.minecraft.class_481;
import net.minecraft.class_490;
import net.minecraft.class_500;
import net.minecraft.class_526;
import net.minecraft.client.gui.screens.*;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import java.awt.*;

public class ModValidator {

    private static final Logger LOGGER = LogManager.getLogger();
    private static final DrawableColor INVALID_COLOR = DrawableColor.of(Color.RED);

    public static boolean isFancyMenuLoaded() {
        return Services.PLATFORM.isModLoaded("fancymenu");
    }

    public static boolean isFancyMenuDisplayName() {
        UniversalModContainer mod = Services.PLATFORM.getLoadedMod("fancymenu");
        if (mod == null) return false;
        return "FancyMenu".equals(mod.name());
    }

    public static boolean isFancyMenuDescription() {
        UniversalModContainer mod = Services.PLATFORM.getLoadedMod("fancymenu");
        if (mod == null) return false;
        if (mod.description() == null) return false;
        return mod.description().contains("Customize Minecraft's menus with ease!");
    }

    public static boolean isFancyMenuLicense() {
        UniversalModContainer mod = Services.PLATFORM.getLoadedMod("fancymenu");
        if (mod == null) return false;
        if (mod.license() == null) return false;
        return mod.license().contains("DSMSLv3");
    }

    public static boolean isFancyMenuMetadataValid() {
        if (!isFancyMenuLoaded()) return false;
        if (!isFancyMenuDisplayName()) return false;
        if (!isFancyMenuDescription()) return false;
        if (!isFancyMenuLicense()) return false;
        return true;
    }

    public static void printInfo() {

        LOGGER.warn("");
        LOGGER.warn("================ FANCYMENU ================");
        LOGGER.warn("");

        LOGGER.warn("FM found in loaded mods: " + isFancyMenuLoaded());
        LOGGER.warn("FM metadata has correct display name: " + isFancyMenuDisplayName());
        LOGGER.warn("FM metadata has correct description: " + isFancyMenuDescription());
        LOGGER.warn("FM metadata has correct license: " + isFancyMenuLicense());

        LOGGER.warn("");
        LOGGER.warn("===========================================");
        LOGGER.warn("");

    }

    public static void renderInvalidError(class_332 graphics) {

        class_437 current = class_310.method_1551().field_1755;
        if (current == null) return;

        //Do not render the error in non-Minecraft screens
        if (!isValidMinecraftScreen(current)) return;

        graphics.method_51448().pushMatrix();

        graphics.method_25294(0, 0, current.field_22789, current.field_22790, DrawableColor.BLACK.getColorInt());

        graphics.method_25300(class_310.method_1551().field_1772, "MODIFIED FANCYMENU JAR FOUND!", current.field_22789 / 2, (current.field_22790 / 2) - 10, INVALID_COLOR.getColorInt());
        graphics.method_25300(class_310.method_1551().field_1772, "PLEASE DOWNLOAD A VALID BUILD FROM CURSEFORGE OR MODRINTH!", current.field_22789 / 2, (current.field_22790 / 2) + 5, INVALID_COLOR.getColorInt());

        graphics.method_51448().popMatrix();

    }

    private static boolean isValidMinecraftScreen(@NotNull class_437 screen) {
        if (screen instanceof class_442) return true;
        if (screen instanceof class_433) return true;
        if (screen instanceof class_526) return true;
        if (screen instanceof class_429) return true;
        if (screen instanceof class_4667) return true;
        if (screen instanceof class_500) return true;
        if (screen instanceof class_418) return true;
        if (screen instanceof class_490) return true;
        if (screen instanceof class_465<?>) return true;
        if (screen instanceof class_481) return true;
        if (screen instanceof class_408) return true;
        return false;
    }

}
