package de.keksuccino.fancymenu.util.file.type.groups;

import de.keksuccino.fancymenu.util.file.type.FileType;
import de.keksuccino.fancymenu.util.file.type.types.FileTypes;
import de.keksuccino.fancymenu.util.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.*;
import java.util.function.Supplier;
import net.minecraft.class_2561;

@SuppressWarnings("unused")
public class FileTypeGroup<T extends FileType<?>> {

    @NotNull
    protected Supplier<List<T>> typeSupplier;
    @Nullable
    protected class_2561 displayName;

    @SuppressWarnings("all")
    @NotNull
    public static FileTypeGroup<FileType<Resource>> allSupported() {
        List<FileType<Resource>> types = new ArrayList<>();
        FileTypes.getAllImageFileTypes().forEach(imageFileType -> types.add((FileType<Resource>)((FileType<?>)imageFileType)));
        FileTypes.getAllAudioFileTypes().forEach(imageFileType -> types.add((FileType<Resource>)((FileType<?>)imageFileType)));
        FileTypes.getAllVideoFileTypes().forEach(imageFileType -> types.add((FileType<Resource>)((FileType<?>)imageFileType)));
        FileTypes.getAllTextFileTypes().forEach(imageFileType -> types.add((FileType<Resource>)((FileType<?>)imageFileType)));
        FileTypeGroup<FileType<Resource>> group = new FileTypeGroup<>(() -> types, null);
        group.setDisplayName(class_2561.method_43471("fancymenu.file_types.groups.all_supported"));
        return group;
    }

    @SafeVarargs
    @NotNull
    public static <T extends FileType<?>> FileTypeGroup<T> of(@NotNull T... types) {
        FileTypeGroup<T> group = new FileTypeGroup<>(() -> Arrays.asList(types));
        if (types.length == 1) group.setDisplayName(types[0].getDisplayName());
        return group;
    }

    public FileTypeGroup(@NotNull Supplier<List<T>> typeSupplier) {
        this(typeSupplier, null);
    }

    public FileTypeGroup(@NotNull Supplier<List<T>> typeSupplier, @Nullable class_2561 displayName) {
        this.typeSupplier = typeSupplier;
        this.displayName = displayName;
    }

    @NotNull
    public List<T> getFileTypes() {
        return Objects.requireNonNullElse(this.typeSupplier.get(), new ArrayList<>());
    }

    @NotNull
    public Supplier<List<T>> getTypeSupplier() {
        return this.typeSupplier;
    }

    public void setTypeSupplier(@NotNull Supplier<List<T>> typeSupplier) {
        this.typeSupplier = typeSupplier;
    }

    @Nullable
    public class_2561 getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(@Nullable class_2561 displayName) {
        this.displayName = displayName;
    }

}
