package de.keksuccino.fancymenu.util.minecraftoptions;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.io.StringReader;
import java.util.Set;
import net.minecraft.class_1664;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_7172;

public class MinecraftOption {

    private static final Gson GSON = new Gson();

    protected String name;
    protected class_7172<Object> optionInstance;
    protected class_304 keyMapping;
    protected class_1664 modelPart;

    @NotNull
    public static MinecraftOption of(@NotNull String name, @NotNull class_7172<Object> optionInstance) {
        MinecraftOption option = new MinecraftOption();
        option.optionInstance = optionInstance;
        option.name = name;
        return option;
    }

    @NotNull
    public static MinecraftOption of(@NotNull class_304 keyMapping) {
        MinecraftOption option = new MinecraftOption();
        option.name = "key_" + keyMapping.method_1431();
        option.keyMapping = keyMapping;
        return option;
    }

    @NotNull
    public static MinecraftOption of(@NotNull class_1664 modelPart) {
        MinecraftOption option = new MinecraftOption();
        option.name = "modelPart_" + modelPart.method_7429();
        option.modelPart = modelPart;
        return option;
    }

    protected MinecraftOption() {
    }

    @Nullable
    public String get() {
        try {
            if (this.optionInstance != null) {
                DataResult<JsonElement> result = this.optionInstance.method_42404().encodeStart(JsonOps.INSTANCE, this.optionInstance.method_41753());
                if (result.error().isPresent()) return null;
                if (result.result().isPresent()) {
                    JsonElement json = result.result().get();
                    return GSON.toJson(json);
                }
            } else if (this.keyMapping != null) {
                return this.keyMapping.method_1428();
            } else if (this.modelPart != null) {
                return "" + ((IMixinOptions)class_310.method_1551().field_1690).getModelPartsFancyMenu().contains(this.modelPart);
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public void set(@NotNull String value) {
        try {
            if (this.optionInstance != null) {
                JsonReader reader = new JsonReader(new StringReader(value.isEmpty() ? "\"\"" : value));
                JsonElement json = JsonParser.parseReader(reader);
                DataResult<Object> result = this.optionInstance.method_42404().parse(JsonOps.INSTANCE, json);
                if (result.error().isPresent()) return;
                result.result().ifPresent(this.optionInstance::method_41748);
            } else if (this.keyMapping != null) {
                this.keyMapping.method_1422(class_3675.method_15981(value));
            } else if (this.modelPart != null) {
                Set<class_1664> parts = ((IMixinOptions)class_310.method_1551().field_1690).getModelPartsFancyMenu();
                if (value.equalsIgnoreCase("true") && !parts.contains(this.modelPart)) {
                    parts.add(this.modelPart);
                } else if (value.equalsIgnoreCase("false")) {
                    parts.remove(this.modelPart);
                }
            }
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @NotNull
    public class_7172<?> getOptionInstance() {
        return this.optionInstance;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

}
