package de.keksuccino.fancymenu.util.minecraftoptions;

import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.*;
import java.util.function.Function;
import net.minecraft.class_1664;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_7172;

public class MinecraftOptions {

    private static final Map<String, MinecraftOption> CACHED_OPTIONS = new LinkedHashMap<>();

    @NotNull
    public static Map<String, MinecraftOption> getOptions() {
        cacheOptions();
        return CACHED_OPTIONS;
    }

    @Nullable
    public static MinecraftOption getOption(@NotNull String name) {
        return getOptions().get(name);
    }

    public static void save() {
        class_310.method_1551().field_1690.method_1640();
    }

    @SuppressWarnings("all")
    private static void cacheOptions() {

        if (CACHED_OPTIONS.isEmpty()) {

            try {

                ((IMixinOptions)class_310.method_1551().field_1690).invokeProcessOptionsFancyMenu(new class_315.class_5823() {
                    @Override
                    public <T> void method_42570(String name, class_7172<T> instance) {
                        CACHED_OPTIONS.put(name, MinecraftOption.of(name, (class_7172<Object>) instance));
                    }
                    @Override
                    public int method_33680(String s, int i) {
                        return i;
                    }
                    @Override
                    public boolean method_33684(String s, boolean b) {
                        return b;
                    }
                    @Override
                    public String method_33683(String s, String s1) {
                        return s1;
                    }
                    @Override
                    public float method_33679(String s, float v) {
                        return v;
                    }
                    @Override
                    public <T> T method_33681(String s, T t, Function<String, T> function, Function<T, String> function1) {
                        return t;
                    }
                });

                for (class_304 keyMapping : class_310.method_1551().field_1690.field_1839) {
                    MinecraftOption option = MinecraftOption.of(keyMapping);
                    CACHED_OPTIONS.put(option.name, option);
                }

                for (class_1664 modelPart : class_1664.values()) {
                    MinecraftOption option = MinecraftOption.of(modelPart);
                    CACHED_OPTIONS.put(option.name, option);
                }

            } catch (Exception ex) {
                ex.printStackTrace();
            }

        }

    }

}
