package de.keksuccino.fancymenu.util.reload;

import com.mojang.logging.LogUtils;
import de.keksuccino.fancymenu.util.resource.ResourceHandlers;
import de.keksuccino.fancymenu.util.resource.preload.ResourcePreLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public class FancyMenuResourceReload {

    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DUMMY_RETURN = "FANCYMENU RESOURCE RELOAD LISTENER";
    private static final Map<Long, Runnable> LISTENERS = new HashMap<>();
    private static long id = 0;

    public static final class_2960 FANCYMENU_RELOAD_LISTENER_ID = class_2960.method_60655("fancymenu", "fancymenu_reload_listener");

    static {

        registerReloadListener(ResourceHandlers::reloadAll);

        registerReloadListener(() -> ResourcePreLoader.preLoadAll(120000)); //waits for 120 seconds per resource

    }

    public static long registerReloadListener(@NotNull Runnable runnable) {
        id++;
        LISTENERS.put(id, runnable);
        return id;
    }

    public static void removeReloadListener(long listenerId) {
        LISTENERS.remove(listenerId);
    }

    @ApiStatus.Internal
    @NotNull
    public static class_4080<String> createMinecraftPreparableReloadListener() {
        return new class_4080<>() {
            @Override
            protected @NotNull String method_18789(@NotNull class_3300 var1, @NotNull class_3695 var2) {
                return DUMMY_RETURN;
            }
            @Override
            protected void apply(@NotNull String prepareReturnValue, @NotNull class_3300 var2, @NotNull class_3695 var3) {
                LISTENERS.forEach((aLong, runnable) -> runnable.run());
            }
        };
    }

}
