package de.keksuccino.fancymenu.util.rendering.text;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.JsonOps;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_8824;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentParser {

    private static final Logger LOGGER = LogManager.getLogger();

    public static @NotNull class_2561 fromJsonOrPlainText(@NotNull String serializedComponentOrPlainText) {
        serializedComponentOrPlainText = PlaceholderParser.replacePlaceholders(serializedComponentOrPlainText);
        if (!serializedComponentOrPlainText.startsWith("{") && !serializedComponentOrPlainText.startsWith("[")) {
            return class_2561.method_43470(serializedComponentOrPlainText);
        } else {
            try {
                class_2561 c = deserializeComponentFromJson(serializedComponentOrPlainText);
                if (c != null) {
                    return c;
                }
            } catch (Exception ignore) {}
            return class_2561.method_43470(serializedComponentOrPlainText);
        }
    }

    @NotNull
    public static String toJson(@NotNull class_2561 component) {
        return class_8824.field_46597.encodeStart(JsonOps.INSTANCE, component).getOrThrow(JsonParseException::new).toString();
    }

    private static @Nullable class_5250 deserializeComponentFromJson(@NotNull String json) {
        try {
            JsonElement jsonElement = JsonParser.parseString(json);
            return jsonElement == null ? null : deserializeComponent(jsonElement);
        } catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to deserialize Component!", ex);
            return null;
        }
    }

    private static class_5250 deserializeComponent(JsonElement jsonElement) {
        Object var2 = class_8824.field_46597.parse(JsonOps.INSTANCE, jsonElement).getOrThrow();
        if (var2 instanceof class_5250 m) {
            return m;
        } else {
            throw new IllegalStateException("Deserialized component was not a MutableComponent!");
        }
    }

}
