package de.keksuccino.fancymenu.util.rendering.text.color;

import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import org.jetbrains.annotations.NotNull;

import java.util.Objects;
import net.minecraft.class_2583;

public class TextColorFormatter {

    protected final char code;
    protected final DrawableColor color;

    public TextColorFormatter(char code, @NotNull DrawableColor color) {
        Objects.requireNonNull(color);
        this.code = code;
        this.color = color;
    }

    public char getCode() {
        return this.code;
    }

    public String getCodeString() {
        return "" + this.code;
    }

    public DrawableColor getColor() {
        return this.color;
    }

    public class_2583 getStyle() {
        return class_2583.field_24360.method_36139(this.getColor().getColorInt());
    }

}
