package de.keksuccino.fancymenu.util.rendering.ui;

import de.keksuccino.fancymenu.util.VanillaEvents;
import org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_11909;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public abstract class UIComponent extends UIBase implements FocuslessContainerEventHandler, class_4068, class_6379 {

    public float posZ = 0f;
    protected boolean hovered = false;
    protected boolean visible = true;
    protected class_310 mc = class_310.method_1551();
    protected boolean dragging = false;
    protected final List<class_364> children = new ArrayList<>();

    /**
     * Make sure to render everything here at X=0 and Y=0!<br>
     * The {@link UIComponent} gets translated to the correct position!
     */
    public abstract void renderComponent(@NotNull class_332 graphics, double mouseX, double mouseY, float partial);

    @Override
    public void method_25394(@NotNull class_332 graphics, int ignoredMouseX, int ignoredMouseY, float partial) {

        if (!this.isVisible()) return;

        this.hovered = this.isMouseOver();

        graphics.method_51448().pushMatrix();
        graphics.method_51448().scale(this.getFixedComponentScale(), this.getFixedComponentScale());
        graphics.method_51448().translate(this.getTranslatedX(), this.getTranslatedY());

        this.renderComponent(graphics, this.getRealMouseX(), this.getRealMouseY(), partial);

        graphics.method_51448().popMatrix();

    }

    /**
     * This is always 0, since {@link UIComponent}s get translated to their "final" positions on render.
     */
    protected float getRealX() {
        return 0;
    }

    /**
     * This is always 0, since {@link UIComponent}s get translated to their "final" positions on render.
     */
    protected float getRealY() {
        return 0;
    }

    /**
     * This is the X-position the {@link UIComponent} gets translated to on render.<br>
     * Keep in mind that this is NOT the REAL position.
     */
    public abstract float getTranslatedX();

    /**
     * This is the Y-position the {@link UIComponent} gets translated to on render.<br>
     * Keep in mind that this is NOT the REAL position.
     */
    public abstract float getTranslatedY();

    public abstract float getWidth();

    public abstract float getHeight();

    /**
     * Since {@link UIComponent} positions get translated and scaled on render, normal mouse positions wouldn't work, so you need to use these whenever
     * you do anything mouse-pos-related. They corrected to work in this custom-scaled and -translated render environment.
     */
    public double getRealMouseX() {
        return (this.mc.field_1729.method_1603() - (this.getTranslatedX() * this.getComponentScale())) / this.getComponentScale();
    }

    /**
     * Since {@link UIComponent} positions get translated and scaled on render, normal mouse positions wouldn't work, so you need to use these whenever
     * you do anything mouse-pos-related. They corrected to work in this custom-scaled and -translated render environment.
     */
    public double getRealMouseY() {
        return (this.mc.field_1729.method_1604() - (this.getTranslatedY() * this.getComponentScale())) / this.getComponentScale();
    }

    /**
     * The mouse position after the {@link UIComponent} got translated on render.
     */
    public double getTranslatedMouseX() {
        return this.mc.field_1729.method_1603() / this.getComponentScale();
    }

    /**
     * The mouse position after the {@link UIComponent} got translated on render.
     */
    public double getTranslatedMouseY() {
        return this.mc.field_1729.method_1604() / this.getComponentScale();
    }

    protected float getScreenWidth() {
        return this.mc.method_22683().method_4489() / this.getComponentScale();
    }

    protected float getScreenHeight() {
        return this.mc.method_22683().method_4506() / this.getComponentScale();
    }

    /**
     * Checks if a component area is hovered.
     */
    protected boolean isComponentAreaHovered(float x, float y, float width, float height, boolean isRealPosition) {
        double mX = this.getRealMouseX();
        double mY = this.getRealMouseY();
        if (!isRealPosition) {
            x -= this.getTranslatedX();
            y -= this.getTranslatedY();
        }
        return isXYInArea(mX, mY, x, y, width+1, height+1);
    }

    /**
     * The scale of the {@link UIComponent}.
     */
    public float getComponentScale() {
        return getUIScale();
    }

    /**
     * This scale works against the actual GUI scale to make it possible to render the {@link UIComponent} in a different scale than the GUI scale.
     */
    public float getFixedComponentScale() {
        return calculateFixedScale(this.getComponentScale());
    }

    /**
     * Scissor with automatic scale handling.
     */
    protected void enableComponentScissor(class_332 graphics, int x, int y, int width, int height, boolean isRealPosition) {
        if (isRealPosition) {
            x += this.getTranslatedX();
            y += this.getTranslatedY();
        }
        int scissorX = (int) (x * this.getFixedComponentScale());
        int scissorY = (int) (y * this.getFixedComponentScale());
        int scissorWidth = (int) (width * this.getFixedComponentScale());
        int scissorHeight = (int) (height * this.getFixedComponentScale());
        graphics.method_44379(scissorX, scissorY, scissorX + scissorWidth, scissorY + scissorHeight);
    }

    protected void disableComponentScissor(class_332 graphics) {
        graphics.method_44380();
    }

    public boolean isHovered() {
        if (!this.isVisible()) return false;
        return this.hovered;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public @NotNull List<class_364> method_25396() {
        return this.children;
    }

    protected boolean mouseClickedComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, int button) {
        for(class_364 child : this.method_25396()) {
            if (child.method_25402(buildMouseButtonEvent(realMouseX, realMouseY, button), false)) {
                this.method_25395(child);
                if (button == 0) {
                    this.method_25398(true);
                }
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @Override
    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        return this.mouseClickedComponent(this.getRealMouseX(), this.getRealMouseY(), this.getTranslatedMouseX(), this.getTranslatedMouseY(), event.method_74245());
    }

    protected boolean mouseReleasedComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, int button) {
        this.method_25398(false);
        for(class_364 child : this.method_25396()) {
            if (child.method_25406(buildMouseButtonEvent(realMouseX, realMouseY, button))) {
                return true;
            }
        }
        return false;
    }

    @Deprecated
    @Override
    public boolean method_25406(class_11909 event) {
        return this.mouseReleasedComponent(this.getRealMouseX(), this.getRealMouseY(), this.getTranslatedMouseX(), this.getTranslatedMouseY(), event.method_74245());
    }

    /**
     * Real mouse coordinates don't really support drag offset calculation, so you should use translated coordinates here.
     */
    protected boolean mouseDraggedComponent(double translatedMouseX, double translatedMouseY, int button, double d1, double d2) {
        if (this.method_25397() && (button == 0)) {
            for (class_364 child : this.method_25396()) {
                if (child.method_25403(buildMouseButtonEvent(this.getRealMouseX(), this.getRealMouseY(), button), d1, d2)) return true;
            }
        }
        return false;
    }

    @Deprecated
    @Override
    public boolean method_25403(class_11909 event, double d1, double d2) {
        return this.mouseDraggedComponent(this.getTranslatedMouseX(), this.getTranslatedMouseY(), event.method_74245(), d1, d2);
    }

    @Override
    public boolean method_25397() {
        return this.dragging;
    }

    @Override
    public void method_25398(boolean dragging) {
        this.dragging = dragging;
    }

    protected boolean mouseScrolledComponent(double realMouseX, double realMouseY, double translatedMouseX, double translatedMouseY, double scrollDeltaX, double scrollDeltaY) {
        for(class_364 child : this.method_25396()) {
            if (child.method_25401(realMouseX, realMouseY, scrollDeltaX, scrollDeltaY)) return true;
        }
        return false;
    }

    @Deprecated
    @Override
    public boolean method_25401(double ignoredMouseX, double ignoredMouseY, double scrollDeltaX, double scrollDeltaY) {
        return this.mouseScrolledComponent(this.getRealMouseX(), this.getRealMouseY(), this.getTranslatedMouseX(), this.getTranslatedMouseY(), scrollDeltaX, scrollDeltaY);
    }

    protected void mouseMovedComponent(double realMouseX, double realMouseY) {
    }

    @Deprecated
    @Override
    public void method_16014(double ignoredMouseX, double ignoredMouseY) {
        this.mouseMovedComponent(this.getRealMouseX(), this.getRealMouseY());
    }

    public boolean isMouseOver() {
        if (!this.isVisible()) return false;
        return this.isComponentAreaHovered(this.getTranslatedX(), this.getTranslatedY(), this.getWidth(), this.getHeight(), false);
    }

    @Deprecated
    @Override
    public boolean method_25405(double ignoredMouseX, double ignoredMouseY) {
        return this.isMouseOver();
    }

    @Override
    public void method_25365(boolean var1) {
    }

    @Override
    public boolean method_25370() {
        return false;
    }

    @Override
    public @NotNull class_6380 method_37018() {
        return class_6380.field_33784;
    }

    @Override
    public void method_37020(@NotNull class_6382 var1) {
    }

    @NotNull
    public static class_11909 buildMouseButtonEvent(double mouseX, double mouseY, int button) {
        return VanillaEvents.mouseButtonEvent(mouseX, mouseY, button);
    }

}