package de.keksuccino.fancymenu.util.rendering.ui.screen;

import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.input.InputConstants;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ConfirmationScreen extends class_437 {

    @NotNull
    protected List<class_2561> textLines;
    @NotNull
    protected List<class_5250> renderTextLines = new ArrayList<>();
    protected DrawableColor headlineColor;
    protected boolean headlineBold = false;
    protected Consumer<Boolean> callback;
    protected long delayEnd = -1;

    protected ExtendedButton confirmButton;
    protected ExtendedButton cancelButton;

    @NotNull
    public static ConfirmationScreen critical(@NotNull Consumer<Boolean> callback, @NotNull class_2561... textLines) {
        return ofComponents(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().error_text_color);
    }

    @NotNull
    public static ConfirmationScreen critical(@NotNull Consumer<Boolean> callback, @NotNull String... textLines) {
        return ofStrings(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().error_text_color);
    }

    @NotNull
    public static ConfirmationScreen warning(@NotNull Consumer<Boolean> callback, @NotNull class_2561... textLines) {
        return ofComponents(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().warning_text_color);
    }

    @NotNull
    public static ConfirmationScreen warning(@NotNull Consumer<Boolean> callback, @NotNull String... textLines) {
        return ofStrings(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().warning_text_color);
    }

    @NotNull
    public static ConfirmationScreen ofStrings(@NotNull Consumer<Boolean> callback, @NotNull String... textLines) {
        ConfirmationScreen s = new ConfirmationScreen(callback, new ArrayList<>());
        for (String line : textLines) {
            s.textLines.add(class_2561.method_43470(line));
        }
        return s;
    }

    @NotNull
    public static ConfirmationScreen ofStrings(@NotNull Consumer<Boolean> callback, @NotNull List<String> textLines) {
        return ofStrings(callback, textLines.toArray(new String[0]));
    }

    @NotNull
    public static ConfirmationScreen ofComponents(@NotNull Consumer<Boolean> callback, @NotNull class_2561... textLines) {
        return new ConfirmationScreen(callback, Arrays.asList(textLines));
    }

    @NotNull
    public static ConfirmationScreen ofComponents(@NotNull Consumer<Boolean> callback, @NotNull List<class_2561> textLines) {
        return new ConfirmationScreen(callback, textLines);
    }

    protected ConfirmationScreen(@NotNull Consumer<Boolean> callback, @NotNull List<class_2561> textLines) {
        super((!textLines.isEmpty()) ? textLines.get(0) : class_2561.method_43473());
        this.callback = callback;
        this.textLines = textLines;
    }

    @Override
    protected void method_25426() {

        this.confirmButton = new ExtendedButton(0, 0, 150, 20, class_2561.method_43471("fancymenu.common_components.ok"), (button) -> {
            this.callback.accept(true);
        }).setForceDefaultTooltipStyle(true).setTooltipSupplier(consumes -> {
            if (!consumes.field_22763) {
                int secs = (int)((this.delayEnd - System.currentTimeMillis()) / 1000);
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.ui.confirmation_screen.delay.tooltip", "" + secs));
            }
            return null;
        });
        this.method_25429(this.confirmButton);
        UIBase.applyDefaultWidgetSkinTo(this.confirmButton);

        this.cancelButton = new ExtendedButton(0, 0, 150, 20, class_2561.method_43471("fancymenu.common_components.cancel"), (button) -> {
            this.callback.accept(false);
        });
        this.method_25429(this.cancelButton);
        UIBase.applyDefaultWidgetSkinTo(this.cancelButton);

        this.updateRenderTextLines();

    }

    protected void updateRenderTextLines() {
        List<class_5250> linesCopy = TextFormattingUtils.lineWrapComponents(this.textLines, 100000); // to split newlines
        if (!linesCopy.isEmpty()) {
            class_5250 first = linesCopy.get(0);
            if (this.headlineColor != null) first.method_10862(first.method_10866().method_36139(this.headlineColor.getColorInt()));
            if (this.headlineBold) first.method_10862(first.method_10866().method_10982(true));
        }
        this.renderTextLines = TextFormattingUtils.lineWrapComponents(linesCopy, this.field_22789 - 80);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());

        int y = (this.field_22790 / 2) - ((this.renderTextLines.size() * 14) / 2);
        for (class_2561 c : this.renderTextLines) {
            int textWidth = this.field_22793.method_27525(c);
            graphics.method_51439(this.field_22793, c, ((this.field_22789 / 2) - (textWidth / 2)), y, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
            y += 14;
        }

        this.confirmButton.field_22763 = this.delayEnd <= System.currentTimeMillis();
        this.confirmButton.method_46421((this.field_22789 / 2) - this.confirmButton.method_25368() - 5);
        this.confirmButton.method_46419(this.field_22790 - 40);
        this.confirmButton.method_25394(graphics, mouseX, mouseY, partial);

        this.cancelButton.method_46421((this.field_22789 / 2) + 5);
        this.cancelButton.method_46419(this.field_22790 - 40);
        this.cancelButton.method_25394(graphics, mouseX, mouseY, partial);

        super.method_25394(graphics, mouseX, mouseY, partial);

    }

    @Override
    public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
    }

    public ConfirmationScreen setDelay(long delay) {
        this.delayEnd = System.currentTimeMillis() + delay;
        return this;
    }

    @Nullable
    public DrawableColor getHeadlineColor() {
        return this.headlineColor;
    }

    public ConfirmationScreen setHeadlineColor(@Nullable DrawableColor headlineColor) {
        this.headlineColor = headlineColor;
        return this;
    }

    public boolean isHeadlineBold() {
        return this.headlineBold;
    }

    public ConfirmationScreen setHeadlineBold(boolean headlineBold) {
        this.headlineBold = headlineBold;
        return this;
    }

    @Override
    public boolean method_25404(class_11908 event) {

        //ENTER
        if (event.comp_4795() == InputConstants.KEY_ENTER) {
            this.callback.accept(true);
            return true;
        }

        return super.method_25404(event);

    }

    @Override
    public void method_25419() {
        this.callback.accept(false);
    }

}
