package de.keksuccino.fancymenu.util.rendering.ui.screen;

import de.keksuccino.fancymenu.util.input.InputConstants;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;

@SuppressWarnings("unused")
public class NotificationScreen extends class_437 {

    protected List<class_2561> textLines;
    protected DrawableColor headlineColor;
    protected boolean headlineBold = false;
    protected Consumer<Boolean> callback;

    protected ExtendedButton okayButton;

    @NotNull
    public static NotificationScreen error(@NotNull Consumer<Boolean> callback, @NotNull class_2561... textLines) {
        return ofComponents(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().error_text_color);
    }

    @NotNull
    public static NotificationScreen error(@NotNull Consumer<Boolean> callback, @NotNull String... textLines) {
        return ofStrings(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().error_text_color);
    }

    @NotNull
    public static NotificationScreen warning(@NotNull Consumer<Boolean> callback, @NotNull class_2561... textLines) {
        return ofComponents(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().warning_text_color);
    }

    @NotNull
    public static NotificationScreen warning(@NotNull Consumer<Boolean> callback, @NotNull String... textLines) {
        return ofStrings(callback, textLines).setHeadlineBold(true).setHeadlineColor(UIBase.getUIColorTheme().warning_text_color);
    }

    @NotNull
    public static NotificationScreen notificationWithHeadline(@NotNull Consumer<Boolean> callback, @NotNull class_2561... textLines) {
        return ofComponents(callback, textLines).setHeadlineBold(true);
    }

    @NotNull
    public static NotificationScreen notificationWithHeadline(@NotNull Consumer<Boolean> callback, @NotNull String... textLines) {
        return ofStrings(callback, textLines).setHeadlineBold(true);
    }

    @NotNull
    public static NotificationScreen ofStrings(@NotNull Consumer<Boolean> callback, @NotNull String... textLines) {
        NotificationScreen s = new NotificationScreen(callback, new ArrayList<>());
        for (String line : textLines) {
            s.textLines.add(class_2561.method_43470(line));
        }
        return s;
    }

    @NotNull
    public static NotificationScreen ofStrings(@NotNull Consumer<Boolean> callback, @NotNull List<String> textLines) {
        return ofStrings(callback, textLines.toArray(new String[0]));
    }

    @NotNull
    public static NotificationScreen ofComponents(@NotNull Consumer<Boolean> callback, @NotNull class_2561... textLines) {
        return new NotificationScreen(callback, Arrays.asList(textLines));
    }

    @NotNull
    public static NotificationScreen ofComponents(@NotNull Consumer<Boolean> callback, @NotNull List<class_2561> textLines) {
        return new NotificationScreen(callback, textLines);
    }

    protected NotificationScreen(@NotNull Consumer<Boolean> callback, @NotNull List<class_2561> textLines) {
        super((!textLines.isEmpty()) ? textLines.get(0) : class_2561.method_43473());
        this.callback = callback;
        this.textLines = textLines;
    }

    @Override
    protected void method_25426() {

        this.okayButton = new ExtendedButton(0, 0, 150, 20, class_2561.method_43471("fancymenu.common_components.ok"), (button) -> {
            this.callback.accept(true);
        });
        this.method_25429(this.okayButton);
        UIBase.applyDefaultWidgetSkinTo(this.okayButton);

    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());

        int y = (this.field_22790 / 2) - ((this.textLines.size() * 14) / 2);
        int lineCounter = 0;
        for (class_2561 c : this.textLines) {
            class_5250 line = c.method_27661();
            if (lineCounter == 0) {
                if (this.headlineColor != null) line.method_10862(line.method_10866().method_36139(this.headlineColor.getColorInt()));
                if (this.headlineBold) line.method_10862(line.method_10866().method_10982(true));
            }
            int textWidth = this.field_22793.method_27525(line);
            graphics.method_51439(this.field_22793, line, (int)((this.field_22789 / 2) - (textWidth / 2)), y, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
            y += 14;
            lineCounter++;
        }

        this.okayButton.method_46421((this.field_22789 / 2) - (this.okayButton.method_25368() / 2));
        this.okayButton.method_46419(this.field_22790 - 40);
        this.okayButton.method_25394(graphics, mouseX, mouseY, partial);

        super.method_25394(graphics, mouseX, mouseY, partial);

    }

    @Override
    public void method_25420(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
    }

    @Nullable
    public DrawableColor getHeadlineColor() {
        return this.headlineColor;
    }

    public NotificationScreen setHeadlineColor(@Nullable DrawableColor headlineColor) {
        this.headlineColor = headlineColor;
        return this;
    }

    public boolean isHeadlineBold() {
        return this.headlineBold;
    }

    public NotificationScreen setHeadlineBold(boolean headlineBold) {
        this.headlineBold = headlineBold;
        return this;
    }

    @Override
    public boolean method_25404(class_11908 event) {

        if (event.comp_4795() == InputConstants.KEY_ENTER) {
            this.callback.accept(true);
            return true;
        }

        return super.method_25404(event);

    }

    @Override
    public void method_25419() {
        this.callback.accept(true);
    }

}
