package de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer;

import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.UniqueWidget;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2588;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_4667;
import net.minecraft.class_500;
import net.minecraft.class_5250;
import net.minecraft.class_526;
import net.minecraft.class_5375;
import net.minecraft.class_7417;

public class ScrollScreenNormalizer {

    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ScrollableScreenBlacklistRule> SCROLLABLE_SCREEN_BLACKLIST = new ArrayList<>();

    static {

        addScrollableScreenBlacklistRule(screen -> (screen instanceof class_526));
        addScrollableScreenBlacklistRule(screen -> (screen instanceof class_500));
        addScrollableScreenBlacklistRule(screen -> (screen instanceof class_5375));
        addScrollableScreenBlacklistRule(screen -> (screen instanceof CustomGuiBaseScreen));

    }

    @NotNull
    public static class_437 normalizeScrollableScreen(@NotNull class_437 screen) {

        if (isBlacklisted(screen)) return screen;
        if (!ScrollScreenNormalizerHandler.shouldNormalize(screen)) return screen;
        if (!ScreenCustomization.isCustomizationEnabledForScreen(screen)) return screen;

        List<class_339> extracted = extractAllWidgetsFromScrollListsOfScreen(screen);
        IMixinScreen accessor = ((IMixinScreen)screen);

        extractAllScrollListsOfScreen(screen).forEach(scroll -> {
            scroll.method_57714(1000000, 1000000, 0);
            accessor.getChildrenFancyMenu().remove(scroll);
            accessor.getNarratablesFancyMenu().remove(scroll);
            accessor.getRenderablesFancyMenu().remove(scroll);
        });
        extracted.forEach(widget -> {
            accessor.getChildrenFancyMenu().remove(widget);
            accessor.getNarratablesFancyMenu().remove(widget);
            accessor.getRenderablesFancyMenu().remove(widget);
        });

        int pos = 50;
        Map<String, Integer> ids = new HashMap<>();
        for (class_339 widget : extracted) {

            widget.method_46421(pos);
            widget.method_46419(pos);
            pos++;

            if (screen instanceof class_4667) {
                if (widget instanceof UniqueWidget w) {
                    StringBuilder id = new StringBuilder("options");
                    buildId(widget.method_25369().method_10851(), id);
                    String idString = id.toString();
                    if (idString.equals("options")) idString += "_generic";
                    if (ids.containsKey(idString)) {
                        int count = ids.get(idString);
                        count++;
                        ids.put(idString, count);
                        idString = idString + "_" + count;
                    } else {
                        ids.put(idString, 0);
                    }
                    w.setWidgetIdentifierFancyMenu(idString);
                }
            }

            accessor.getChildrenFancyMenu().add(widget);
            accessor.getRenderablesFancyMenu().add(widget);
            accessor.getNarratablesFancyMenu().add(widget);

        }

        return screen;

    }

    @NotNull
    private static StringBuilder buildId(@NotNull class_7417 contents, @NotNull StringBuilder builder) {
        if (contents instanceof class_2588 t) {
            builder.append("_");
            Object[] args = t.method_11023();
            if (args.length > 0) {
                if (args[0] instanceof class_5250 c) {
                    if (c.method_10851() instanceof class_2588 t2) {
                        builder.append(t2.method_11022());
                        return builder;
                    }
                }
            }
            builder.append(t.method_11022());
        }
        return builder;
    }

    public static boolean isBlacklisted(@NotNull class_437 screen) {
        for (ScrollableScreenBlacklistRule e : SCROLLABLE_SCREEN_BLACKLIST) {
            if (e.isBlacklisted(screen)) return true;
        }
        return false;
    }

    @NotNull
    public static List<class_350<?>> extractAllScrollListsOfScreen(@NotNull class_437 screen) {
        List<class_350<?>> list = new ArrayList<>();
        screen.method_25396().forEach(o -> {
            if (o instanceof class_350<?> l) list.add(l);
        });
        return list;
    }

    @NotNull
    public static List<class_339> extractAllWidgetsFromScrollListsOfScreen(@NotNull class_437 screen) {
        List<class_339> list = new ArrayList<>();
        for (Object o : ((IMixinScreen)screen).getChildrenFancyMenu()) {
            if (o instanceof class_350<?> sel) {
                sel.method_25396().forEach(entry -> {
                    if (entry instanceof class_4069 h) {
                        extractWidgetsRecursively(h, list);
                    }
                });
            }
        }
        return list;
    }

    private static void extractWidgetsRecursively(@NotNull class_4069 container, @NotNull List<class_339> list) {
        container.method_25396().forEach(child -> {
            if (child instanceof class_4069 childContainer) {
                // Recursively extract widgets from nested containers
                extractWidgetsRecursively(childContainer, list);
            } else if (child instanceof class_339 widget) {
                list.add(widget);
            }
        });
    }

    public static void addScrollableScreenBlacklistRule(@NotNull ScrollScreenNormalizer.ScrollableScreenBlacklistRule rule) {
        SCROLLABLE_SCREEN_BLACKLIST.add(rule);
    }

    @FunctionalInterface
    public interface ScrollableScreenBlacklistRule {
        boolean isBlacklisted(@NotNull class_437 screen);
    }

}
