package de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry;

import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import org.jetbrains.annotations.NotNull;
import java.awt.*;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class TextListScrollAreaEntry extends ScrollAreaEntry {

    public Color listDotColor;
    protected class_2561 text;
    protected int textWidth;
    public class_327 font = class_310.method_1551().field_1772;
    protected Consumer<TextListScrollAreaEntry> onClickCallback;

    public TextListScrollAreaEntry(ScrollArea parent, @NotNull class_2561 text, @NotNull Color listDotColor, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
        super(parent, 0, 16);
        this.listDotColor = listDotColor;
        this.onClickCallback = onClick;
        this.setText(text);
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partial) {

        super.method_25394(graphics, mouseX, mouseY, partial);

        int centerY = this.getY() + (this.getHeight() / 2);

        renderListingDot(graphics, this.getX() + 5, centerY - 2, this.listDotColor);

        graphics.method_51439(this.font, this.text, (this.getX() + 5 + 4 + 3), (centerY - (this.font.field_2000 / 2)), UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

    }

    @Override
    public void onClick(ScrollAreaEntry entry) {
        this.onClickCallback.accept((TextListScrollAreaEntry) entry);
    }

    public void setText(@NotNull class_2561 text) {
        this.text = text;
        this.textWidth = this.font.method_27525(this.text);
        this.setWidth(5 + 4 + 3 + this.textWidth + 5);
    }

    public class_2561 getText() {
        return this.text;
    }

    public int getTextWidth() {
        return this.textWidth;
    }

}
