package de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry;

import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import org.jetbrains.annotations.NotNull;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

@SuppressWarnings("unused")
public class TextScrollAreaEntry extends ScrollAreaEntry {

    protected class_2561 text;
    protected int textWidth;
    public class_327 font = class_310.method_1551().field_1772;
    protected Consumer<TextScrollAreaEntry> onClickCallback;
    protected int textBaseColor = UIBase.getUIColorTheme().generic_text_base_color.getColorInt();

    public TextScrollAreaEntry(ScrollArea parent, @NotNull class_2561 text, @NotNull Consumer<TextScrollAreaEntry> onClick) {
        super(parent, 0, 14);
        this.onClickCallback = onClick;
        this.setText(text);
    }

    @Override
    public void renderEntry(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        float centerY = this.getY() + (this.getHeight() / 2f);
        graphics.method_51439(this.font, this.text, (int)(this.getX() + 5f), (int)(centerY - (this.font.field_2000 / 2f)), this.textBaseColor, false);
    }

    @Override
    public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
        this.onClickCallback.accept((TextScrollAreaEntry) entry);
    }

    public void setText(@NotNull class_2561 text) {
        this.text = text;
        this.textWidth = this.font.method_27525(this.text);
        this.setWidth(5 + this.textWidth + 5);
    }

    public class_2561 getText() {
        return this.text;
    }

    public int getTextWidth() {
        return this.textWidth;
    }

    public int getTextBaseColor() {
        return textBaseColor;
    }

    public void setTextBaseColor(int textBaseColor) {
        this.textBaseColor = textBaseColor;
    }

}
