package de.keksuccino.fancymenu.util.rendering.ui.tooltip;

import de.keksuccino.fancymenu.util.event.acara.EventHandler;
import de.keksuccino.fancymenu.util.event.acara.EventListener;
import de.keksuccino.fancymenu.events.screen.InitOrResizeScreenEvent;
import de.keksuccino.fancymenu.events.screen.RenderScreenEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import java.util.function.BooleanSupplier;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_8001;

public class TooltipHandler {

    private static final Logger LOGGER = LogManager.getLogger();

    /** Default instance. **/
    public static final TooltipHandler INSTANCE = new TooltipHandler();

    private final List<HandledTooltip> tooltips = new ArrayList<>();
    private final Map<class_339, HandledTooltip> widgetTooltips = new HashMap<>();
    private Runnable vanillaTooltip = null;

    public TooltipHandler() {
        EventHandler.INSTANCE.registerListenersOf(this);
    }

    @EventListener(priority = -1000)
    public void onScreenRenderPost(RenderScreenEvent.Post e) {
        HandledTooltip renderTooltip = null;
        for (HandledTooltip t : new ArrayList<>(this.tooltips)) {
            if (t.shouldRender.getAsBoolean()) {
                renderTooltip = t;
            }
            if (t.removeAfterScreenRender) {
                t.remove();
            }
        }
        if (renderTooltip != null) {
            renderTooltip.tooltip.method_25394(e.getGraphics(), e.getMouseX(), e.getMouseY(), e.getPartial());
        } else if (this.vanillaTooltip != null) {
            this.vanillaTooltip.run();
            this.vanillaTooltip = null;
        }
    }

    @EventListener(priority = 1000)
    public void onScreenInitResizePre(InitOrResizeScreenEvent.Pre e) {
        for (HandledTooltip t : new ArrayList<>(this.tooltips)) {
            if (t.removeOnScreenInitOrResize) t.remove();
        }
    }

    public void setVanillaTooltip(@NotNull class_332 graphics, @NotNull List<class_2561> lines, @NotNull Optional<class_5632> tooltipImage, int x, int y, @Nullable class_2960 background) {
        List<class_5684> tooltipLines = lines.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(class_156.method_58579());
        tooltipImage.ifPresent(component -> tooltipLines.add(tooltipLines.isEmpty() ? 0 : 1, class_5684.method_32663(component)));
        this.vanillaTooltip = () -> graphics.method_51435(class_310.method_1551().field_1772, tooltipLines, x, y, class_8001.field_41687, background);
    }

    public HandledTooltip addWidgetTooltip(@NotNull class_339 widget, @NotNull Tooltip tooltip, boolean removeOnScreenInitOrResize, boolean removeAfterScreenRender) {
        if (this.widgetTooltips.containsKey(widget)) {
            this.removeTooltip(this.widgetTooltips.get(widget));
        }
        HandledTooltip t = this.addTooltip(tooltip, () -> widget.method_49606() && widget.field_22764, removeOnScreenInitOrResize, removeAfterScreenRender);
        t.widget = widget;
        this.widgetTooltips.put(widget, t);
        return t;
    }

    public HandledTooltip addTooltip(@NotNull Tooltip tooltip, @NotNull BooleanSupplier shouldRender, boolean removeOnScreenInitOrResize, boolean removeAfterScreenRender) {
        HandledTooltip t = new HandledTooltip(this, tooltip, shouldRender, removeOnScreenInitOrResize, removeAfterScreenRender);
        this.tooltips.add(t);
        return t;
    }

    public void removeTooltip(HandledTooltip tooltip) {
        this.tooltips.remove(tooltip);
        if (tooltip.widget != null) {
            this.widgetTooltips.remove(tooltip.widget);
        }
    }

    public static class HandledTooltip {

        private final TooltipHandler parent;
        public final Tooltip tooltip;
        public final BooleanSupplier shouldRender;
        public final boolean removeOnScreenInitOrResize;
        public final boolean removeAfterScreenRender;
        protected class_339 widget = null;

        private HandledTooltip(TooltipHandler parent, Tooltip tooltip, BooleanSupplier shouldRender, boolean removeOnScreenInitOrResize, boolean removeAfterScreenRender) {
            this.parent = parent;
            this.tooltip = tooltip;
            this.shouldRender = shouldRender;
            this.removeOnScreenInitOrResize = removeOnScreenInitOrResize;
            this.removeAfterScreenRender = removeAfterScreenRender;
        }

        /** Removes the tooltip from its handler. **/
        public void remove() {
            this.parent.removeTooltip(this);
        }

    }

}
