package de.keksuccino.fancymenu.util.rendering.ui.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinAbstractWidget;
import de.keksuccino.fancymenu.util.ClassExtender;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.resource.PlayableResource;
import de.keksuccino.fancymenu.util.resource.RenderableResource;
import net.minecraft.class_10799;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_357;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

/**
 * This interface gets applied to the {@link class_357} class to add a bunch of helper methods for easier customization.
 */
@ClassExtender(class_357.class)
public interface CustomizableSlider {

    void setNineSliceCustomSliderBackground_FancyMenu(boolean nineSlice);

    boolean isNineSliceCustomSliderBackground_FancyMenu();

    void setNineSliceSliderBackgroundBorderX_FancyMenu(int borderX);

    int getNineSliceSliderBackgroundBorderX_FancyMenu();

    void setNineSliceSliderBackgroundBorderY_FancyMenu(int borderY);

    int getNineSliceSliderBackgroundBorderY_FancyMenu();

    void setNineSliceCustomSliderHandle_FancyMenu(boolean nineSlice);

    boolean isNineSliceCustomSliderHandle_FancyMenu();

    void setNineSliceSliderHandleBorderX_FancyMenu(int borderX);

    int getNineSliceSliderHandleBorderX_FancyMenu();

    void setNineSliceSliderHandleBorderY_FancyMenu(int borderY);

    int getNineSliceSliderHandleBorderY_FancyMenu();

    void setCustomSliderBackgroundNormalFancyMenu(@Nullable RenderableResource background);

    @Nullable
    RenderableResource getCustomSliderBackgroundNormalFancyMenu();

    void setCustomSliderBackgroundHighlightedFancyMenu(@Nullable RenderableResource background);

    @Nullable
    RenderableResource getCustomSliderBackgroundHighlightedFancyMenu();

    /**
     * Returns if the slider should render its Vanilla background (true) or not (false).
     */
    default boolean renderSliderBackgroundFancyMenu(class_332 graphics, class_357 widget, boolean canChangeValue) {
        class_2960 location = null;
        RenderableResource texture = null;
        if (widget.method_25370() && !canChangeValue) {
            if (this.getCustomSliderBackgroundNormalFancyMenu() instanceof PlayableResource p) p.pause();
            if (this.getCustomSliderBackgroundHighlightedFancyMenu() != null) {
                if (this.getCustomSliderBackgroundHighlightedFancyMenu() instanceof PlayableResource p) p.play();
                texture = this.getCustomSliderBackgroundHighlightedFancyMenu();
                location = this.getCustomSliderBackgroundHighlightedFancyMenu().getResourceLocation();
            }
        } else {
            if (this.getCustomSliderBackgroundHighlightedFancyMenu() instanceof PlayableResource p) p.pause();
            if (this.getCustomSliderBackgroundNormalFancyMenu() != null) {
                if (this.getCustomSliderBackgroundNormalFancyMenu() instanceof PlayableResource p) p.play();
                texture = this.getCustomSliderBackgroundNormalFancyMenu();
                location = this.getCustomSliderBackgroundNormalFancyMenu().getResourceLocation();
            }
        }
        if (location != null) {
            if (this.isNineSliceCustomSliderBackground_FancyMenu()) {
                RenderingUtils.blitNineSlicedTexture(graphics, location, widget.method_46426(), widget.method_46427(), widget.method_25368(), widget.method_25364(), texture.getWidth(), texture.getHeight(), this.getNineSliceSliderBackgroundBorderY_FancyMenu(), this.getNineSliceSliderBackgroundBorderX_FancyMenu(), this.getNineSliceSliderBackgroundBorderY_FancyMenu(), this.getNineSliceSliderBackgroundBorderX_FancyMenu(), class_9848.method_61317(((IMixinAbstractWidget)this).getAlphaFancyMenu()));
            } else {
                graphics.method_25291(class_10799.field_56883, location, widget.method_46426(), widget.method_46427(), 0.0F, 0.0F, widget.method_25368(), widget.method_25364(), widget.method_25368(), widget.method_25364(), DrawableColor.WHITE.getColorIntWithAlpha(((IMixinAbstractWidget)this).getAlphaFancyMenu()));
            }
            return false;
        }
        return true;
    }

}
