package de.keksuccino.fancymenu.util.rendering.ui.widget;

import de.keksuccino.fancymenu.util.rendering.ui.widget.slider.FancyMenuWidget;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RendererWidget extends class_339 implements UniqueWidget, NavigatableWidget, FancyMenuWidget {

    @NotNull
    protected RendererWidgetBody body;
    @Nullable
    protected String identifier;

    public RendererWidget(int x, int y, int width, int height, @NotNull RendererWidgetBody body) {
        super(x, y, width, height, class_2561.method_43473());
        this.body = body;
    }

    @Override
    public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.body.render(graphics, mouseX, mouseY, partial, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this);
    }

    @Override
    protected void method_47399(@NotNull class_6382 var1) {
    }

    public RendererWidget setBody(@NotNull RendererWidgetBody body) {
        this.body = body;
        return this;
    }

    @Override
    @Nullable
    public String getWidgetIdentifierFancyMenu() {
        return this.identifier;
    }

    @Override
    public RendererWidget setWidgetIdentifierFancyMenu(@Nullable String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        throw new RuntimeException("RendererWidgets are not focusable!");
    }

    @Override
    public boolean isNavigatable() {
        return false;
    }

    @Override
    public void setNavigatable(boolean navigatable) {
        throw new RuntimeException("RendererWidgets are not navigatable!");
    }

    @Override
    public void method_25354(@NotNull class_1144 $$0) {
        //no click sound
    }

    public float getAlpha() {
        return this.field_22765;
    }

    @FunctionalInterface
    public interface RendererWidgetBody {
        void render(@NotNull class_332 graphics, int mouseX, int mouseY, float partial, int x, int y, int width, int height, @NotNull RendererWidget renderer);
    }

}
