package de.keksuccino.fancymenu.util.rendering.ui.widget.button;

import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CheckboxButton extends ExtendedButton {

    public static final class_2960 CHECKBOX_BACKGROUND_TEXTURE_NORMAL_DEFAULT = class_2960.method_60655("fancymenu", "textures/widgets/checkbox/background_normal.png");
    public static final class_2960 CHECKBOX_BACKGROUND_TEXTURE_HOVER_DEFAULT = class_2960.method_60655("fancymenu", "textures/widgets/checkbox/background_hover.png");
    public static final class_2960 CHECKBOX_BACKGROUND_TEXTURE_INACTIVE_DEFAULT = class_2960.method_60655("fancymenu", "textures/widgets/checkbox/background_inactive.png");
    public static final class_2960 CHECKBOX_CHECKMARK_TEXTURE_DEFAULT = class_2960.method_60655("fancymenu", "textures/widgets/checkbox/checkmark.png");

    protected boolean checkboxState = false;
    @NotNull
    protected StateChangedAction onStateChanged;
    @Nullable
    protected ITexture customCheckmarkTexture = null;
    @Nullable
    protected ITexture customBackgroundTextureNormal = null;
    @Nullable
    protected ITexture customBackgroundTextureHover = null;
    @Nullable
    protected ITexture customBackgroundTextureInactive = null;

    public CheckboxButton(int x, int y, int width, int height, @NotNull StateChangedAction onStateChanged) {
        super(x, y, width, height, class_2561.method_43473(), button -> {});
        this.onStateChanged = onStateChanged;
        this.setPressAction(button -> {
            this.checkboxState = !this.checkboxState;
            onStateChanged.onStateChanged(this, checkboxState);
        });
    }

    @Override
    public void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {

        super.method_48579(graphics, mouseX, mouseY, partial);

        if (this.checkboxState && this.method_37303()) {
            graphics.method_25290(class_10799.field_56883, this.getCheckboxCheckmarkTexture(), this.method_46426(), this.method_46427(), 0.0F, 0.0F, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());
        }

    }

    @Override
    protected void renderBackground(@NotNull class_332 graphics) {

        graphics.method_25290(class_10799.field_56883, this.getCheckboxBackground(), this.method_46426(), this.method_46427(), 0.0F, 0.0F, this.method_25368(), this.method_25364(), this.method_25368(), this.method_25364());

    }

    @Override
    protected void renderLabelText(@NotNull class_332 graphics) {
        // do nothing
    }

    @NotNull
    public class_2960 getCheckboxCheckmarkTexture() {
        if (this.customCheckmarkTexture != null) {
            class_2960 loc = this.customCheckmarkTexture.getResourceLocation();
            if (loc != null) return loc;
        }
        return CHECKBOX_CHECKMARK_TEXTURE_DEFAULT;
    }

    public void setCustomCheckboxCheckmarkTexture(@Nullable ITexture customCheckmarkTexture) {
        this.customCheckmarkTexture = customCheckmarkTexture;
    }

    public void setCustomBackgroundTextureNormal(@Nullable ITexture customBackgroundTextureNormal) {
        this.customBackgroundTextureNormal = customBackgroundTextureNormal;
    }

    public void setCustomBackgroundTextureHover(@Nullable ITexture customBackgroundTextureHover) {
        this.customBackgroundTextureHover = customBackgroundTextureHover;
    }

    public void setCustomBackgroundTextureInactive(@Nullable ITexture customBackgroundTextureInactive) {
        this.customBackgroundTextureInactive = customBackgroundTextureInactive;
    }

    @NotNull
    public class_2960 getCheckboxBackground() {
        if (!this.method_37303()) {
            return this.getCheckboxBackgroundTextureInactive();
        }
        if (this.method_25367()) {
            return this.getCheckboxBackgroundTextureHover();
        }
        return this.getCheckboxBackgroundTextureNormal();
    }

    @NotNull
    public class_2960 getCheckboxBackgroundTextureNormal() {
        if (this.customBackgroundTextureNormal != null) {
            class_2960 loc = this.customBackgroundTextureNormal.getResourceLocation();
            if (loc != null) return loc;
        }
        return CHECKBOX_BACKGROUND_TEXTURE_NORMAL_DEFAULT;
    }

    @NotNull
    public class_2960 getCheckboxBackgroundTextureHover() {
        if (this.customBackgroundTextureHover != null) {
            class_2960 loc = this.customBackgroundTextureHover.getResourceLocation();
            if (loc != null) return loc;
        }
        return CHECKBOX_BACKGROUND_TEXTURE_HOVER_DEFAULT;
    }

    @NotNull
    public class_2960 getCheckboxBackgroundTextureInactive() {
        if (this.customBackgroundTextureInactive != null) {
            class_2960 loc = this.customBackgroundTextureInactive.getResourceLocation();
            if (loc != null) return loc;
        }
        return CHECKBOX_BACKGROUND_TEXTURE_INACTIVE_DEFAULT;
    }

    public boolean getCheckboxState() {
        return checkboxState;
    }

    public void setCheckboxState(boolean state, boolean callOnStateChanged) {
        this.checkboxState = state;
        if (callOnStateChanged) {
            this.onStateChanged.onStateChanged(this, this.checkboxState);
        }
    }

    @FunctionalInterface
    public interface StateChangedAction {
        void onStateChanged(@NotNull CheckboxButton checkbox, boolean state);
    }

}
