package de.keksuccino.fancymenu.util.rendering.ui.widget.component;

import com.google.gson.*;
import com.google.gson.stream.JsonReader;
import com.mojang.serialization.JsonOps;
import org.jetbrains.annotations.Nullable;
import java.io.StringReader;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7225;

public class ComponentSerialization {

    public static class Serializer {

        private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

        private Serializer() {
        }

        static class_5250 deserialize(JsonElement json, class_7225.class_7874 provider) {
            return (class_5250) net.minecraft.class_8824.field_46597.parse(provider.method_57093(JsonOps.INSTANCE), json).getOrThrow(JsonParseException::new);
        }

        static JsonElement serialize(class_2561 component, class_7225.class_7874 provider) {
            return net.minecraft.class_8824.field_46597.encodeStart(provider.method_57093(JsonOps.INSTANCE), component).getOrThrow(JsonParseException::new);
        }

        public static String toJson(class_2561 component, class_7225.class_7874 registries) {
            return GSON.toJson(serialize(component, registries));
        }

        @Nullable
        public static class_5250 fromJson(String json, class_7225.class_7874 registries) {
            JsonElement jsonElement = JsonParser.parseString(json);
            return jsonElement == null ? null : deserialize(jsonElement, registries);
        }

        @Nullable
        public static class_5250 fromJson(@Nullable JsonElement json, class_7225.class_7874 registries) {
            return json == null ? null : deserialize(json, registries);
        }

        @Nullable
        public static class_5250 fromJsonLenient(String json, class_7225.class_7874 registries) {
            JsonReader jsonReader = new JsonReader(new StringReader(json));
            jsonReader.setLenient(true);
            JsonElement jsonElement = JsonParser.parseReader(jsonReader);
            return jsonElement == null ? null : deserialize(jsonElement, registries);
        }

    }

}
