package de.keksuccino.fancymenu.util.rendering.ui.widget.editbox;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinCommandSuggestions;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinSuggestionsList;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.awt.*;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_241;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4717;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_637;
import net.minecraft.class_768;
import net.minecraft.class_8001;

@SuppressWarnings("unused")
public class EditBoxSuggestions extends class_4717 {

    private static final Logger LOGGER = LogManager.getLogger();

    protected static final Pattern WHITESPACE_PATTERN = Pattern.compile("(\\s+)");
    protected static final class_2583 UNPARSED_STYLE = class_2583.field_24360.method_10977(class_124.field_1061);
    protected static final class_2583 LITERAL_STYLE = class_2583.field_24360.method_10977(class_124.field_1080);
    protected static final List<class_2583> ARGUMENT_STYLES = Stream.of(class_124.field_1075, class_124.field_1054, class_124.field_1060, class_124.field_1076, class_124.field_1065).map(class_2583.field_24360::method_10977).collect(ImmutableList.toImmutableList());

    protected final class_310 minecraft;
    protected final class_437 screen;
    protected final class_342 input;
    protected final class_327 font;
    protected final boolean commandsOnly;
    protected final boolean onlyShowIfCursorPastError;
    protected final int lineStartOffset;
    protected final int suggestionLineLimit;
    protected final boolean anchorToBottom;
    protected final List<String> customSuggestionsList = new ArrayList<>();
    protected boolean onlyCustomSuggestions = false;
    protected boolean allowRenderUsage = true;
    @NotNull
    protected SuggestionsRenderPosition renderPosition = SuggestionsRenderPosition.VANILLA;
    protected DrawableColor backgroundColor = DrawableColor.of(new Color(0,0,0));
    protected DrawableColor normalTextColor = DrawableColor.of(new Color(-5592406));
    protected DrawableColor selectedTextColor = DrawableColor.of(new Color(-256));
    protected boolean textShadow = true;
    protected boolean autoSuggestions = true;

    @NotNull
    public static EditBoxSuggestions createWithCustomSuggestions(@NotNull class_437 screen, @NotNull class_342 editBox, @NotNull SuggestionsRenderPosition renderPosition, @NotNull List<String> suggestions) {
        EditBoxSuggestions variableNameSuggestions = new EditBoxSuggestions(class_310.method_1551(), screen, editBox, class_310.method_1551().field_1772, false, true, 0, 7, false);
        variableNameSuggestions.method_23933(true);
        variableNameSuggestions.enableOnlyCustomSuggestionsMode(true);
        variableNameSuggestions.setSuggestionsRenderPosition(renderPosition);
        variableNameSuggestions.setAllowRenderUsage(false);
        variableNameSuggestions.setCustomSuggestions(suggestions);
        variableNameSuggestions.method_23934();
        return variableNameSuggestions;
    }

    public EditBoxSuggestions(@NotNull class_310 mc, @NotNull class_437 parentScreen, @NotNull class_342 targetEditBox, @NotNull class_327 font, boolean commandsOnly, boolean onlyShowIfCursorPastError, int lineStartOffset, int suggestionLineLimit, boolean anchorToBottom) {
        super(mc, parentScreen, targetEditBox, font, commandsOnly, onlyShowIfCursorPastError, lineStartOffset, suggestionLineLimit, anchorToBottom, Integer.MIN_VALUE);
        this.minecraft = mc;
        this.screen = parentScreen;
        this.input = targetEditBox;
        this.font = font;
        this.commandsOnly = commandsOnly;
        this.onlyShowIfCursorPastError = onlyShowIfCursorPastError;
        this.lineStartOffset = lineStartOffset;
        this.suggestionLineLimit = suggestionLineLimit;
        this.anchorToBottom = anchorToBottom;
    }

    @Override
    public void method_23923(@NotNull class_332 graphics, int mouseX, int mouseY) {
        if (!this.input.method_25370()) {
            this.setSuggestions(null);
        }
        super.method_23923(graphics, mouseX, mouseY);
    }

    @Override
    public void method_44932(@NotNull class_332 graphics) {
        if (!this.isAllowRenderUsage()) return;
        super.method_44932(graphics);
    }

    @Override
    public void method_23934() {

        String editBoxValue = this.input.method_1882();

        if ((this.getCurrentParse() != null) && !this.getCurrentParse().getReader().getString().equals(editBoxValue)) {
            this.setCurrentParse(null);
        }

        if (!this.isKeepSuggestions()) {
            this.input.method_1887(null);
            this.setSuggestions(null);
        }

        this.getCommandUsage().clear();
        StringReader valueReader = new StringReader(editBoxValue);
        boolean isReaderCursorAtSlash = valueReader.canRead() && valueReader.peek() == '/';
        if (isReaderCursorAtSlash) {
            valueReader.skip();
        }

        boolean treatAsCommand = this.commandsOnly || isReaderCursorAtSlash;
        if (this.onlyCustomSuggestions) treatAsCommand = false;
        int editBoxCursorPos = this.input.method_1881();
        if (treatAsCommand) {
            if (this.minecraft.field_1724 != null) {
                CommandDispatcher<class_637> commands = this.minecraft.field_1724.field_3944.method_2886();
                if (this.getCurrentParse() == null) {
                    this.setCurrentParse(commands.parse(valueReader, this.minecraft.field_1724.field_3944.method_2875()));
                }
                int readerCursorPos = this.onlyShowIfCursorPastError ? valueReader.getCursor() : 1;
                if ((editBoxCursorPos >= readerCursorPos) && ((this.getSuggestions() == null) || !this.isKeepSuggestions())) {
                    this.setPendingSuggestions(commands.getCompletionSuggestions(this.getCurrentParse(), editBoxCursorPos));
                    this.getPendingSuggestions().thenRun(() -> {
                        if (this.getPendingSuggestions().isDone()) {
                            this.method_23937();
                        }
                    });
                }
            }
        } else {
            String editBoxSubValue = editBoxValue.substring(0, editBoxCursorPos);
            int lastWordIndex = method_23930(editBoxSubValue);
            Collection<String> suggestionStringList = new ArrayList<>(this.customSuggestionsList);
            if (suggestionStringList.isEmpty() && (this.minecraft.field_1724 != null)) {
                suggestionStringList = this.minecraft.field_1724.field_3944.method_2875().method_44750();
            }
            this.setPendingSuggestions(class_2172.method_9265(suggestionStringList, new SuggestionsBuilder(editBoxSubValue, lastWordIndex)));
            //Always show suggestions without pressing TAB
            if (this.autoSuggestions && this.suggestionsAllowed() && this.minecraft.field_1690.method_42425().method_41753()) {
                this.method_23920(false);
            }
        }

    }

    @Override
    public void method_23920(boolean someNarratingRelatedBoolean) {
        if ((this.getPendingSuggestions() != null) && this.getPendingSuggestions().isDone()) {

            Suggestions suggestions = this.getPendingSuggestions().join();
            if (!suggestions.isEmpty()) {

                List<Suggestion> sortedSuggestions = this.method_30104(suggestions);

                int totalSuggestionsWidth = 0;
                for(Suggestion suggestion : suggestions.getList()) {
                    totalSuggestionsWidth = Math.max(totalSuggestionsWidth, this.font.method_1727(suggestion.getText()));
                }

                int listX = class_3532.method_15340(this.input.method_1889(suggestions.getRange().getStart()), 0, this.input.method_1889(0) + this.input.method_1859() - totalSuggestionsWidth);
                int listY = this.anchorToBottom ? this.screen.field_22790 - 12 : 72;
                int listHeight = Math.min(sortedSuggestions.size(), this.suggestionLineLimit) * 12;
                if (this.renderPosition == SuggestionsRenderPosition.ABOVE_EDIT_BOX) {
                    listY = this.input.method_46427() - listHeight - 2;
                }
                if (this.renderPosition == SuggestionsRenderPosition.BELOW_EDIT_BOX) {
                    listY = this.input.method_46427() + this.input.method_25364() + 2;
                }
                this.setSuggestions(new EditBoxSuggestionsList(listX, listY, totalSuggestionsWidth, sortedSuggestions, someNarratingRelatedBoolean));

            }

        }
    }

    @Override
    public boolean method_23924(class_11908 event) {
        if (!this.input.method_25370()) return false;
        if ((this.getSuggestions() != null) && this.getSuggestions().method_2377(event)) {
            return true;
        } else if (event.comp_4795() == 258) {
            this.method_23920(true);
            return true;
        } else {
            return false;
        }
    }

    @Override
    public boolean method_23922(class_11909 event) {
        if (!this.input.method_25370()) return false;
        return super.method_23922(event);
    }

    @Override
    public boolean method_23921(double $$0) {
        if (!this.input.method_25370()) return false;
        return super.method_23921($$0);
    }

    protected void method_23937() {
        this.getAccessor().invokeUpdateUsageInfoFancyMenu();
    }

    protected List<Suggestion> method_30104(Suggestions suggestions) {
        return this.getAccessor().invokeSortSuggestionsFancyMenu(suggestions);
    }

    public boolean suggestionsAllowed() {
        return this.getAccessor().getAllowSuggestionsFancyMenu();
    }

    public boolean autoSuggestionsEnabled() {
        return this.autoSuggestions;
    }

    public void setAutoSuggestionsEnabled(boolean enabled) {
        this.autoSuggestions = enabled;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public void setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
    }

    public DrawableColor getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(@NotNull DrawableColor backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public DrawableColor getNormalTextColor() {
        return this.normalTextColor;
    }

    public void setNormalTextColor(@NotNull DrawableColor normalTextColor) {
        this.normalTextColor = normalTextColor;
    }

    public DrawableColor getSelectedTextColor() {
        return this.selectedTextColor;
    }

    public void setSelectedTextColor(@NotNull DrawableColor selectedTextColor) {
        this.selectedTextColor = selectedTextColor;
    }

    public void setSuggestionsRenderPosition(@NotNull SuggestionsRenderPosition position) {
        this.renderPosition = Objects.requireNonNull(position);
    }

    @NotNull
    public SuggestionsRenderPosition getSuggestionsRenderPosition() {
        return this.renderPosition;
    }

    public void setAllowRenderUsage(boolean allow) {
        this.allowRenderUsage = allow;
    }

    public boolean isAllowRenderUsage() {
        return this.allowRenderUsage;
    }

    public void enableOnlyCustomSuggestionsMode(boolean enable) {
        this.onlyCustomSuggestions = enable;
    }

    public boolean isOnlyCustomSuggestionsMode() {
        return this.onlyCustomSuggestions;
    }

    public void setCustomSuggestions(@Nullable List<String> customSuggestions) {
        if (this.commandsOnly) throw new RuntimeException("Can't set custom suggestions in commands-only mode!");
        this.customSuggestionsList.clear();
        if (customSuggestions != null) {
            this.customSuggestionsList.addAll(customSuggestions);
        }
    }

    public class_4717.class_464 getSuggestions() {
        return this.getAccessor().getSuggestionsFancyMenu();
    }

    public void setSuggestions(class_4717.class_464 suggestions) {
        this.getAccessor().setSuggestionsFancyMenu(suggestions);
    }

    public CompletableFuture<Suggestions> getPendingSuggestions() {
        return this.getAccessor().getPendingSuggestionsFancyMenu();
    }

    public void setPendingSuggestions(CompletableFuture<Suggestions> pendingSuggestions) {
        this.getAccessor().setPendingSuggestionsFancyMenu(pendingSuggestions);
    }

    public ParseResults<class_637> getCurrentParse() {
        return this.getAccessor().getCurrentParseFancyMenu();
    }

    public void setCurrentParse(ParseResults<class_637> currentParse) {
        this.getAccessor().setCurrentParseFancyMenu(currentParse);
    }

    public boolean isKeepSuggestions() {
        return this.getAccessor().getKeepSuggestionsFancyMenu();
    }

    public IMixinCommandSuggestions getAccessor() {
        return ((IMixinCommandSuggestions)this);
    }

    public List<class_5481> getCommandUsage() {
        return this.getAccessor().getCommandUsageFancyMenu();
    }

    @SuppressWarnings("all")
    protected static int method_23930(String editBoxValue) {
        if (Strings.isNullOrEmpty(editBoxValue)) {
            return 0;
        } else {
            int index = 0;
            for(Matcher matcher = WHITESPACE_PATTERN.matcher(editBoxValue); matcher.find(); index = matcher.end()) {}
            return index;
        }
    }

    public enum SuggestionsRenderPosition {
        VANILLA,
        ABOVE_EDIT_BOX,
        BELOW_EDIT_BOX
    }
    
    public class EditBoxSuggestionsList extends class_464 {

        protected List<Suggestion> suggestionList;

        public EditBoxSuggestionsList(int x, int y, int width, List<Suggestion> suggestionList, boolean someNarratingRelatedBoolean) {
            super(x, y, width, suggestionList, someNarratingRelatedBoolean);
            this.suggestionList = suggestionList;
        }

        @Override
        public void method_2373(@NotNull class_332 graphics, int mouseX, int mouseY) {
            Message message;
            int suggestionLineCount = Math.min(this.suggestionList.size(), EditBoxSuggestions.this.suggestionLineLimit);
            boolean bl = this.getOffset() > 0;
            boolean bl2 = this.suggestionList.size() > this.getOffset() + suggestionLineCount;
            boolean bl3 = bl || bl2;
            boolean bl4 = (this.getLastMouse().field_1343 != (float)mouseX) || (this.getLastMouse().field_1342 != (float)mouseY);
            if (bl4) {
                this.setLastMouse(new class_241(mouseX, mouseY));
            }
            if (bl3) {
                int m;
                graphics.method_25294(this.getRect().method_3321(), this.getRect().method_3322() - 1, this.getRect().method_3321() + this.getRect().method_3319(), this.getRect().method_3322(), EditBoxSuggestions.this.backgroundColor.getColorInt());
                graphics.method_25294(this.getRect().method_3321(), this.getRect().method_3322() + this.getRect().method_3320(), this.getRect().method_3321() + this.getRect().method_3319(), this.getRect().method_3322() + this.getRect().method_3320() + 1, EditBoxSuggestions.this.backgroundColor.getColorInt());
                if (bl) {
                    for (m = 0; m < this.getRect().method_3319(); ++m) {
                        if (m % 2 != 0) continue;
                        graphics.method_25294(this.getRect().method_3321() + m, this.getRect().method_3322() - 1, this.getRect().method_3321() + m + 1, this.getRect().method_3322(), -1);
                    }
                }
                if (bl2) {
                    for (m = 0; m < this.getRect().method_3319(); ++m) {
                        if (m % 2 != 0) continue;
                        graphics.method_25294(this.getRect().method_3321() + m, this.getRect().method_3322() + this.getRect().method_3320(), this.getRect().method_3321() + m + 1, this.getRect().method_3322() + this.getRect().method_3320() + 1, -1);
                    }
                }
            }
            boolean bl52 = false;
            for (int n = 0; n < suggestionLineCount; ++n) {
                Suggestion suggestion = this.suggestionList.get(n + this.getOffset());
                graphics.method_25294(this.getRect().method_3321(), this.getRect().method_3322() + 12 * n, this.getRect().method_3321() + this.getRect().method_3319(), this.getRect().method_3322() + 12 * n + 12, EditBoxSuggestions.this.backgroundColor.getColorInt());
                if (mouseX > this.getRect().method_3321() && mouseX < this.getRect().method_3321() + this.getRect().method_3319() && mouseY > this.getRect().method_3322() + 12 * n && mouseY < this.getRect().method_3322() + 12 * n + 12) {
                    if (bl4) {
                        this.method_2374(n + this.getOffset());
                    }
                    bl52 = true;
                }
                graphics.method_51433(EditBoxSuggestions.this.font, suggestion.getText(), (this.getRect().method_3321() + 1), (this.getRect().method_3322() + 2 + 12 * n), ((n + this.getOffset()) == this.getCurrent()) ? EditBoxSuggestions.this.selectedTextColor.getColorInt() : EditBoxSuggestions.this.normalTextColor.getColorInt(), EditBoxSuggestions.this.textShadow);
            }
            if (bl52 && (message = this.suggestionList.get(this.getCurrent()).getTooltip()) != null) {
                class_5684 tooltipComponent = class_5684.method_32662(class_2564.method_10883(message).method_30937());
                graphics.method_51435(EditBoxSuggestions.this.font, List.of(tooltipComponent), mouseX, mouseY, class_8001.field_41687, null);
            }
        }

        public class_768 getRect() {
            return this.getAccessor().getRectFancyMenu();
        }

        public int getOffset() {
            return this.getAccessor().getOffsetFancyMenu();
        }

        public int getCurrent() {
            return this.getAccessor().getCurrentFancyMenu();
        }
        
        public class_241 getLastMouse() {
            return this.getAccessor().getLastMouseFancyMenu();
        }

        public void setLastMouse(class_241 lastMouse) {
            this.getAccessor().setLastMouseFancyMenu(lastMouse);
        }

        public IMixinSuggestionsList getAccessor() {
            return (IMixinSuggestionsList) this;
        }
        
    }

}
