package de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v1;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_3532;

public class ListSliderButton extends ExtendedSliderButton {

    private static final Logger LOGGER = LogManager.getLogger("fancymenu/ListSliderButton");

    public List<String> values;

    public ListSliderButton(int x, int y, int width, int height, boolean handleClick, @NotNull List<String> values, double selectedIndex, Consumer<ExtendedSliderButton> applyValueCallback) {
        super(x, y, width, height, handleClick, 0, applyValueCallback);
        this.values = values;
        this.setSelectedIndex(selectedIndex);
        this.method_25346();
    }

    @Override
    public String getSliderMessageWithoutPrefixSuffix() {
        return this.getSelectedListValue();
    }

    public String getSelectedListValue() {
        return this.values.get(this.getSelectedIndex());
    }

    public int getSelectedIndex() {
        if (!this.values.isEmpty()) {
            double minValue = 0;
            double maxValue = this.values.size()-1;
            return (int) class_3532.method_16436(class_3532.method_15350(this.field_22753, 0.0D, 1.0D), minValue, maxValue);
        }
        return 0;
    }

//    public int getSelectedIndex() {
//        if (!this.values.isEmpty()) {
//            int valueCount = this.values.size();
//            return ((int) Mth.lerp(Mth.clamp(this.value, 0.0D, 1.0D), 1, valueCount))-1;
//        }
//        return 0;
//    }

    public void setSelectedIndex(double index) {
        if ((this.values != null) && !this.values.isEmpty()) {
            double minValue = 0;
            double maxValue = this.values.size()-1;
            this.method_25347(((class_3532.method_15350(index, minValue, maxValue) - minValue) / (maxValue - minValue)));
        }
    }

//    public void setSelectedIndex(double index) {
//        if ((this.values != null) && !this.values.isEmpty()) {
//            double minValue = 0;
//            double maxValue = this.values.size();
//            if (index < 0) {
//                index = 0;
//            }
//            if (index > this.values.size()-1) {
//                index = this.values.size()-1;
//            }
//            this.setValue(((Mth.clamp((float)(index + 1), 1, this.values.size()) - 1) / (this.values.size() - 1)));
//        }
//    }

}
