package de.keksuccino.fancymenu.util.rendering.ui.widget.slider.v1;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import java.util.function.Consumer;
import net.minecraft.class_3532;

public class RangeSliderButton extends ExtendedSliderButton {

    private static final Logger LOGGER = LogManager.getLogger();

    public double minValue;
    public double maxValue;

    public RangeSliderButton(int x, int y, int width, int height, boolean handleClick, double minRangeValue, double maxRangeValue, double selectedRangeValue, Consumer<ExtendedSliderButton> applyValueCallback) {
        super(x, y, width, height, handleClick, 0, applyValueCallback);
        this.minValue = minRangeValue;
        this.maxValue = maxRangeValue;
        this.setSelectedRangeValue(selectedRangeValue);
        this.method_25346();
    }

    @Override
    public String getSliderMessageWithoutPrefixSuffix() {
        return "" + getSelectedRangeValue();
    }

    public int getSelectedRangeValue() {
        return (int) class_3532.method_16436(class_3532.method_15350(this.field_22753, 0.0D, 1.0D), minValue, maxValue);
    }

    public double getSelectedRangeDoubleValue() {
        return class_3532.method_16436(class_3532.method_15350(this.field_22753, 0.0D, 1.0D), minValue, maxValue);
    }

    public void setSelectedRangeValue(double rangeValue) {
        this.method_25347(((class_3532.method_15350(rangeValue, this.minValue, this.maxValue) - this.minValue) / (this.maxValue - this.minValue)));
    }

}
