package de.keksuccino.fancymenu.util.resource.resources.texture;

import de.keksuccino.fancymenu.util.resource.RenderableResource;
import de.keksuccino.konkrete.rendering.RenderUtils;
import org.apache.commons.io.file.Counters;
import org.jetbrains.annotations.NotNull;
import java.util.Objects;
import net.minecraft.class_1044;
import net.minecraft.class_2960;

public interface ITexture extends RenderableResource {

    public static final Counters.Counter TEX_REGISTRY_COUNTER = Counters.longCounter();

    @NotNull
    default class_2960 registerAbstractTexture(@NotNull class_1044 texture) {
        TEX_REGISTRY_COUNTER.increment();
        return RenderUtils.register("fancymenu_texture_" + TEX_REGISTRY_COUNTER.get(), Objects.requireNonNull(texture));
    }

}
