/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.file;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.action.ActionInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.file.DotMinecraftUtils;
import de.keksuccino.fancymenu.util.file.GameDirectoryUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.DualTextInputScreen;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenameFileAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public RenameFileAction() {
        super("rename_file_in_game_dir");
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        try {
            if (value != null && value.contains("||")) {
                File oldFile;
                String[] valueArray = value.split("\\|\\|", 2);
                String filePath = valueArray[0];
                String newFileName = valueArray[1];
                if (newFileName.isEmpty()) {
                    throw new IllegalArgumentException("New name cannot be empty!");
                }
                String resolvedPath = DotMinecraftUtils.resolveMinecraftPath(filePath);
                if (!DotMinecraftUtils.isInsideMinecraftDirectory(resolvedPath)) {
                    resolvedPath = GameDirectoryUtils.getAbsoluteGameDirectoryPath(resolvedPath);
                }
                if (!(oldFile = new File(resolvedPath)).exists()) {
                    throw new FileNotFoundException("Source not found! Can't rename: " + resolvedPath);
                }
                File parentDir = oldFile.getParentFile();
                if (parentDir == null) {
                    throw new IllegalStateException("Unable to resolve parent directory for: " + resolvedPath);
                }
                File newFile = new File(parentDir, newFileName);
                if (newFile.exists()) {
                    throw new FileAlreadyExistsException("Target already exists! Can't rename to: " + newFile.getAbsolutePath());
                }
                Path sourcePath = oldFile.toPath();
                Path targetPath = newFile.toPath();
                Files.move(sourcePath, targetPath, new CopyOption[0]);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to rename file in game directory via RenameFileAction: " + value, (Throwable)ex);
        }
    }

    @Override
    @NotNull
    public class_2561 getActionDisplayName() {
        return class_2561.method_43471((String)"fancymenu.actions.rename_file");
    }

    @Override
    @NotNull
    public class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.rename_file.desc", new String[0]);
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43473();
    }

    @Override
    public String getValueExample() {
        return "/config/some_mod_folder/old_name.txt||new_name.txt";
    }

    @Override
    public void editValue(@NotNull class_437 parentScreen, @NotNull ActionInstance instance) {
        DualTextInputScreen s = DualTextInputScreen.build(this.getActionDisplayName(), (class_2561)class_2561.method_43471((String)"fancymenu.actions.rename_file.value.filepath"), (class_2561)class_2561.method_43471((String)"fancymenu.actions.rename_file.value.new_name"), null, callback -> {
            if (callback != null) {
                instance.value = (String)callback.getKey() + "||" + (String)callback.getValue();
            }
            class_310.method_1551().method_1507(parentScreen);
        });
        String val = instance.value;
        if (val != null && val.contains("||")) {
            String[] array = val.split("\\|\\|", 2);
            s.setFirstText(array[0]);
            s.setSecondText(array[1]);
        }
        class_310.method_1551().method_1507((class_437)s);
    }
}

