/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.customgui;

import de.keksuccino.fancymenu.customization.customgui.CustomGui;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomGuiBaseScreen
extends class_437 {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final DrawableColor DARK_BACKGROUND = DrawableColor.BLACK;
    private static final float BACKGROUND_ALPHA = 0.4f;
    protected final CustomGui gui;
    protected final class_437 overrideScreen;
    protected final class_437 parentScreen;

    public CustomGuiBaseScreen(@NotNull CustomGui customGui, @Nullable class_437 parentScreen, @Nullable class_437 overrideScreen) {
        super((class_2561)class_2561.method_43473());
        this.gui = customGui;
        this.overrideScreen = overrideScreen;
        this.parentScreen = parentScreen;
    }

    protected void method_25426() {
        super.method_25426();
        if (this.gui.popupMode) {
            this.resizePopupMenuBackgroundScreen(class_310.method_1551(), this.field_22789, this.field_22790);
        }
    }

    protected void resizePopupMenuBackgroundScreen(class_310 minecraft, int width, int height) {
        try {
            if (this.parentScreen != null) {
                class_437 current = class_310.method_1551().field_1755;
                class_310.method_1551().field_1755 = this.parentScreen;
                this.parentScreen.method_25410(minecraft, width, height);
                class_310.method_1551().field_1755 = current;
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to resize popup menu background screen of Custom GUI!", (Throwable)ex);
        }
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parentScreen);
    }

    public boolean method_25422() {
        return this.gui.allowEsc;
    }

    public boolean method_25421() {
        return this.gui.pauseGame;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this._renderBackground(graphics, mouseX, mouseY, partial);
        super.method_25394(graphics, mouseX, mouseY, partial);
        String title = PlaceholderParser.replacePlaceholders(this.getTitleString());
        class_5250 titleComp = LocalizationUtils.isLocalizationKey(title) ? class_2561.method_43471((String)title) : class_2561.method_43470((String)title);
        graphics.method_27534(this.field_22793, (class_2561)titleComp, this.field_22789 / 2, 8, -1);
    }

    protected void _renderBackground(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        boolean popupOverlay;
        boolean popup = this.gui.popupMode && this.parentScreen != null;
        boolean bl = popupOverlay = popup && this.gui.popupModeBackgroundOverlay;
        if (popup) {
            this.renderPopupMenuBackgroundScreen(graphics, mouseX, mouseY, partial);
        } else if (class_310.method_1551().field_1687 == null || !this.gui.worldBackground) {
            this.method_25434(graphics);
            return;
        }
        if (popupOverlay) {
            this.renderDarkBackgroundOverlay(graphics);
        }
        if (!popup) {
            this.method_25420(graphics);
        }
    }

    protected void renderDarkBackgroundOverlay(@NotNull class_332 graphics) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, DARK_BACKGROUND.getColorIntWithAlpha(0.4f));
    }

    protected void renderPopupMenuBackgroundScreen(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        RenderingUtils.setTooltipRenderingBlocked(true);
        class_437 current = class_310.method_1551().field_1755;
        CustomGui.isCurrentlyRenderingPopupBackgroundScreen = true;
        try {
            class_310.method_1551().field_1755 = this.parentScreen;
            this.parentScreen.method_47413(graphics, -500, -500, partial);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to render popup menu background screen of Custom GUI!", (Throwable)ex);
        }
        CustomGui.isCurrentlyRenderingPopupBackgroundScreen = false;
        class_310.method_1551().field_1755 = current;
        RenderingUtils.setTooltipRenderingBlocked(false);
    }

    @NotNull
    public String getTitleString() {
        return this.gui.title;
    }

    @NotNull
    public String getIdentifier() {
        return this.gui.identifier;
    }

    @Nullable
    public class_437 getOverriddenScreen() {
        return this.overrideScreen;
    }

    @NotNull
    public CustomGui getGuiMetadata() {
        return this.gui;
    }

    @Nullable
    public class_437 getParentScreen() {
        return this.parentScreen;
    }
}

