/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.animationcontroller;

import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.ElementSelectorScreen;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.TextInputScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class TargetElementManagerScreen
extends CellScreen {
    protected final AnimationControllerElement element;
    protected final LayoutEditorScreen parentLayoutEditor;
    protected final Consumer<List<AnimationControllerElement.TargetElement>> callback;
    protected final List<AnimationControllerElement.TargetElement> targets;

    public TargetElementManagerScreen(@NotNull AnimationControllerEditorElement editorElement, @NotNull Consumer<List<AnimationControllerElement.TargetElement>> callback) {
        super((class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.manage_targets"));
        this.element = editorElement.getElement();
        this.parentLayoutEditor = editorElement.editor;
        this.callback = callback;
        this.targets = new ArrayList<AnimationControllerElement.TargetElement>(this.element.targetElements);
    }

    @Override
    protected void initCells() {
        this.addStartEndSpacerCell();
        this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.manage_targets.info").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true))));
        this.addCellGroupEndSpacerCell();
        this.addCellGroupEndSpacerCell();
        if (this.targets.isEmpty()) {
            this.addLabelCell((class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.manage_targets.no_targets").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt())));
        } else {
            for (AnimationControllerElement.TargetElement target : this.targets) {
                AbstractEditorElement e = this.parentLayoutEditor.getElementByInstanceIdentifier(target.targetElementId);
                class_5250 label = e != null ? e.element.getDisplayName().method_27661() : class_2561.method_43470((String)"---");
                label = label.method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
                label = label.method_10852((class_2561)class_2561.method_43470((String)(" [" + target.targetElementId + "]")).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().generic_text_base_color.getColorInt())));
                this.addCell(new TargetEntryCell(target, (class_2561)label));
                this.addCellGroupEndSpacerCell();
            }
        }
        this.addStartEndSpacerCell();
    }

    @Override
    protected void initRightSideWidgets() {
        this.addRightSideButton(20, (class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.manage_targets.add"), button -> {
            ElementSelectorScreen selector = new ElementSelectorScreen(this.parentLayoutEditor, this, this.getElementIds(), selectedElement -> {
                if (selectedElement != null) {
                    String elementId = selectedElement.element.getInstanceIdentifier();
                    if (this.targets.stream().anyMatch(t -> t.targetElementId.equals(elementId))) {
                        class_310.method_1551().method_1507((class_437)ConfirmationScreen.warning(result -> class_310.method_1551().method_1507((class_437)this), LocalizationUtils.splitLocalizedLines("fancymenu.elements.animation_controller.manage_targets.already_exists", new String[0])));
                    } else {
                        this.targets.add(new AnimationControllerElement.TargetElement(elementId));
                        class_310.method_1551().method_1507((class_437)this);
                    }
                } else {
                    class_310.method_1551().method_1507((class_437)this);
                }
            });
            class_310.method_1551().method_1507((class_437)selector);
        });
        this.addRightSideDefaultSpacer();
        this.addRightSideButton(20, (class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.manage_targets.remove_by_id"), button -> {
            TextInputScreen inputScreen = TextInputScreen.build((class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.manage_targets.remove_by_id.input"), null, result -> {
                String trimmed;
                boolean removed = false;
                if (result != null && !(trimmed = result.trim()).isEmpty()) {
                    removed = this.targets.removeIf(target -> target.targetElementId.equals(trimmed));
                }
                class_310.method_1551().method_1507((class_437)this);
                if (removed) {
                    this.rebuild();
                }
            });
            class_310.method_1551().method_1507((class_437)inputScreen);
        });
        this.addRightSideDefaultSpacer();
    }

    protected List<String> getElementIds() {
        ArrayList<String> ids = new ArrayList<String>();
        this.targets.forEach(targetElement -> ids.add(targetElement.targetElementId));
        return ids;
    }

    @Override
    protected void onCancel() {
        this.callback.accept(null);
    }

    @Override
    protected void onDone() {
        this.callback.accept(this.targets);
    }

    protected class TargetEntryCell
    extends CellScreen.RenderCell {
        protected final AnimationControllerElement.TargetElement targetElement;
        protected final class_2561 label;
        protected final ExtendedButton removeButton;

        protected TargetEntryCell(@NotNull AnimationControllerElement.TargetElement targetElement, class_2561 label) {
            super(TargetElementManagerScreen.this);
            this.targetElement = targetElement;
            this.label = label;
            this.removeButton = new ExtendedButton(0, 0, 20, 20, (class_2561)class_2561.method_43471((String)"fancymenu.elements.animation_controller.manage_targets.remove"), button -> {
                TargetElementManagerScreen.this.targets.remove(this.targetElement);
                TargetElementManagerScreen.this.rebuild();
            });
            UIBase.applyDefaultWidgetSkinTo(this.removeButton);
            this.method_25396().add((class_364)this.removeButton);
            this.setSearchStringSupplier(() -> this.label.getString());
        }

        @Override
        public void renderCell(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
            int buttonWidth = class_310.method_1551().field_1772.method_27525((class_5348)this.removeButton.method_25369()) + 10;
            if (buttonWidth < 80) {
                buttonWidth = 80;
            }
            this.removeButton.method_25358(buttonWidth);
            this.removeButton.setHeight(20);
            this.removeButton.method_46421(this.getX() + this.getWidth() - this.removeButton.method_25368());
            this.removeButton.method_46419(this.getY() + (this.getHeight() - this.removeButton.method_25364()) / 2);
            RenderingUtils.resetShaderColor(graphics);
            int n = this.getY();
            int n2 = this.getHeight();
            Objects.requireNonNull(class_310.method_1551().field_1772);
            int textY = n + (n2 - 9) / 2;
            UIBase.drawElementLabel(graphics, class_310.method_1551().field_1772, this.label, this.getX(), textY);
            RenderingUtils.resetShaderColor(graphics);
        }

        @Override
        protected void updateSize(@NotNull CellScreen.CellScrollEntry scrollEntry) {
            super.updateSize(scrollEntry);
            Objects.requireNonNull(class_310.method_1551().field_1772);
            this.setHeight(Math.max(9 + 4, 20));
        }
    }
}

