/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.element.elements.image;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.ElementBuilder;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.rendering.AspectRatio;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.RenderingUtils;
import de.keksuccino.fancymenu.util.resource.PlayableResource;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageElement
extends AbstractElement {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nullable
    public ResourceSupplier<ITexture> textureSupplier;
    public boolean repeat = false;
    public boolean nineSlice = false;
    public int nineSliceBorderX = 5;
    public int nineSliceBorderY = 5;
    public boolean restartAnimatedOnMenuLoad = false;
    @NotNull
    public String imageTint = "#FFFFFF";
    @Nullable
    public String lastImageTint;
    @Nullable
    private DrawableColor currentImageTint;

    public ImageElement(@NotNull ElementBuilder<?, ?> builder) {
        super(builder);
        this.allowDepthTestManipulation = true;
    }

    @Override
    public void onOpenScreen() {
        ITexture texture;
        super.onOpenScreen();
        if (this.restartAnimatedOnMenuLoad && this.textureSupplier != null && (texture = this.textureSupplier.get()) instanceof PlayableResource) {
            PlayableResource r = (PlayableResource)((Object)texture);
            r.stop();
            r.play();
        }
    }

    protected void tickImageTint() {
        String tint = PlaceholderParser.replacePlaceholders(this.imageTint);
        if (!tint.equals(this.lastImageTint)) {
            this.currentImageTint = DrawableColor.of(tint);
            if (this.currentImageTint == DrawableColor.EMPTY) {
                this.currentImageTint = DrawableColor.of("#FFFFFF");
                LOGGER.error("[FANCYMENU] Failed to parse tint color for ImageElement! Defaulting to WHITE as tint because parsing failed for: " + tint + " (RAW: " + this.imageTint + ")", (Throwable)new IllegalStateException("Failed to parse image tint color"));
            }
        }
        this.lastImageTint = tint;
        if (this.currentImageTint == null) {
            this.currentImageTint = DrawableColor.of("#FFFFFF");
        }
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        if (this.shouldRender()) {
            this.tickImageTint();
            if (this.currentImageTint == null) {
                return;
            }
            int x = this.getAbsoluteX();
            int y = this.getAbsoluteY();
            RenderSystem.enableBlend();
            this.currentImageTint.setAsShaderColor(graphics, this.opacity);
            ITexture t = this.getTextureResource();
            if (t != null && t.isReady()) {
                class_2960 loc = t.getResourceLocation();
                if (loc != null) {
                    if (this.repeat) {
                        RenderingUtils.blitRepeat(graphics, loc, x, y, this.getAbsoluteWidth(), this.getAbsoluteHeight(), t.getWidth(), t.getHeight());
                    } else if (this.nineSlice) {
                        RenderingUtils.blitNineSlicedTexture(graphics, loc, x, y, this.getAbsoluteWidth(), this.getAbsoluteHeight(), t.getWidth(), t.getHeight(), this.nineSliceBorderY, this.nineSliceBorderX, this.nineSliceBorderY, this.nineSliceBorderX);
                    } else {
                        graphics.method_25290(loc, x, y, 0.0f, 0.0f, this.getAbsoluteWidth(), this.getAbsoluteHeight(), this.getAbsoluteWidth(), this.getAbsoluteHeight());
                    }
                }
            } else if (ImageElement.isEditor()) {
                RenderingUtils.renderMissing(graphics, this.getAbsoluteX(), this.getAbsoluteY(), this.getAbsoluteWidth(), this.getAbsoluteHeight());
            }
            this.currentImageTint.resetShaderColor(graphics);
            RenderSystem.disableBlend();
        }
    }

    @Nullable
    public ITexture getTextureResource() {
        if (this.textureSupplier != null) {
            return this.textureSupplier.get();
        }
        return null;
    }

    public void restoreAspectRatio() {
        ITexture t = this.getTextureResource();
        AspectRatio ratio = t != null ? t.getAspectRatio() : new AspectRatio(10, 10);
        this.baseWidth = ratio.getAspectRatioWidth(this.getAbsoluteHeight());
    }
}

