/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.loadingrequirement.ui;

import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirement;
import de.keksuccino.fancymenu.customization.loadingrequirement.LoadingRequirementRegistry;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.customization.loadingrequirement.internal.LoadingRequirementInstance;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.text.TextFormattingUtils;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v2.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.ExtendedEditBox;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildRequirementScreen
extends class_437 {
    protected class_437 parentScreen;
    protected LoadingRequirementContainer parent;
    protected final LoadingRequirementInstance instance;
    protected boolean isEdit;
    protected Consumer<LoadingRequirementInstance> callback;
    protected ScrollArea requirementsListScrollArea = new ScrollArea(0.0f, 0.0f, 0.0f, 0.0f);
    protected ScrollArea descriptionScrollArea = new ScrollArea(0.0f, 0.0f, 0.0f, 0.0f);
    protected ExtendedEditBox searchBar;
    private static final Comparator<LoadingRequirement> REQUIREMENT_DISPLAY_NAME_COMPARATOR = Comparator.comparing(requirement -> requirement.getDisplayName(), String.CASE_INSENSITIVE_ORDER).thenComparing(LoadingRequirement::getDisplayName).thenComparing(LoadingRequirement::getIdentifier);

    public BuildRequirementScreen(@Nullable class_437 parentScreen, @NotNull LoadingRequirementContainer parent, @Nullable LoadingRequirementInstance instanceToEdit, @NotNull Consumer<LoadingRequirementInstance> callback) {
        super((class_2561)(instanceToEdit != null ? class_2561.method_43471((String)"fancymenu.requirements.screens.edit_requirement") : class_2561.method_43471((String)"fancymenu.requirements.screens.add_requirement")));
        this.parentScreen = parentScreen;
        this.parent = parent;
        this.instance = instanceToEdit != null ? instanceToEdit : new LoadingRequirementInstance(null, null, LoadingRequirementInstance.RequirementMode.IF, parent);
        this.isEdit = instanceToEdit != null;
        this.callback = callback;
    }

    protected void method_25426() {
        String oldSearchValue = this.searchBar != null ? this.searchBar.method_1882() : "";
        this.searchBar = new ExtendedEditBox(class_310.method_1551().field_1772, 21, 66, this.field_22789 / 2 - 40 - 2, 18, (class_2561)class_2561.method_43473());
        this.searchBar.setHintFancyMenu(consumes -> class_2561.method_43471((String)"fancymenu.requirements.build_requirement.screen.search_requirement"));
        this.searchBar.method_1852(oldSearchValue);
        this.searchBar.method_1863(s -> this.updateRequirementsList());
        this.method_37063((class_364)this.searchBar);
        UIBase.applyDefaultWidgetSkinTo(this.searchBar);
        this.method_48265((class_364)this.searchBar);
        this.requirementsListScrollArea.setWidth(this.field_22789 / 2 - 40, true);
        this.requirementsListScrollArea.setHeight(this.field_22790 - 85 - 25, true);
        this.requirementsListScrollArea.setX(20.0f, true);
        this.requirementsListScrollArea.setY(90.0f, true);
        this.method_37063(this.requirementsListScrollArea);
        this.descriptionScrollArea.setWidth(this.field_22789 / 2 - 40, true);
        this.descriptionScrollArea.setHeight(Math.max(40, this.field_22790 / 2 - 50 - 25), true);
        this.descriptionScrollArea.setX((float)(this.field_22789 - 20) - this.descriptionScrollArea.getWidthWithBorder(), true);
        this.descriptionScrollArea.setY(65.0f, true);
        this.descriptionScrollArea.horizontalScrollBar.active = false;
        this.method_37063(this.descriptionScrollArea);
        int doneButtonX = this.field_22789 - 20 - 150;
        int doneButtonY = this.field_22790 - 20 - 20;
        int cancelButtonX = doneButtonX;
        int cancelButtonY = doneButtonY - 5 - 20;
        int editValueButtonX = doneButtonX;
        int editValueButtonY = (this.isEdit ? doneButtonY : cancelButtonY) - 15 - 20;
        int requirementModeButtonX = doneButtonX;
        int requirementModeButtonY = editValueButtonY - 5 - 20;
        ExtendedButton editValueButton = new ExtendedButton(editValueButtonX, editValueButtonY, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.requirements.screens.build_screen.edit_value"), button -> {
            if (this.instance.requirement != null) {
                this.instance.requirement.editValue(this, this.instance);
            }
        }).setTooltipSupplier(consumes -> {
            if (this.instance.requirement != null && !this.instance.requirement.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.edit_value.desc.no_value", new String[0]));
            }
            return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.edit_value.desc.normal", new String[0]));
        }).setIsActiveSupplier(consumes -> this.instance.requirement != null && this.instance.requirement.hasValue());
        this.method_37063((class_364)editValueButton);
        UIBase.applyDefaultWidgetSkinTo(editValueButton);
        ExtendedButton doneButton = new ExtendedButton(doneButtonX, doneButtonY, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.common_components.done"), button -> {
            class_310.method_1551().method_1507(this.parentScreen);
            this.callback.accept(this.instance);
        }).setTooltipSupplier(consumes -> {
            if (this.instance.requirement == null) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.finish.desc.no_requirement_selected", new String[0]));
            }
            if (this.instance.value == null && this.instance.requirement.hasValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.finish.desc.no_value_set", new String[0]));
            }
            return null;
        }).setIsActiveSupplier(consumes -> {
            if (this.instance.requirement == null) {
                return false;
            }
            if (this.instance.value == null && this.instance.requirement.hasValue()) {
                return false;
            }
            return true;
        });
        this.method_37063((class_364)doneButton);
        UIBase.applyDefaultWidgetSkinTo(doneButton);
        ExtendedButton cancelButton = new ExtendedButton(cancelButtonX, cancelButtonY, 150, 20, (class_2561)class_2561.method_43471((String)"fancymenu.common_components.cancel"), button -> {
            class_310.method_1551().method_1507(this.parentScreen);
            if (this.isEdit) {
                this.callback.accept(this.instance);
            } else {
                this.callback.accept(null);
            }
        }).setIsActiveSupplier(consumes -> !this.isEdit);
        cancelButton.field_22764 = !this.isEdit;
        this.method_37063((class_364)cancelButton);
        UIBase.applyDefaultWidgetSkinTo(cancelButton);
        ExtendedButton requirementModeButton = new ExtendedButton(requirementModeButtonX, requirementModeButtonY, 150, 20, (class_2561)class_2561.method_43473(), button -> {
            this.instance.mode = this.instance.mode == LoadingRequirementInstance.RequirementMode.IF ? LoadingRequirementInstance.RequirementMode.IF_NOT : LoadingRequirementInstance.RequirementMode.IF;
        }).setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.requirements.screens.build_screen.requirement_mode.desc", new String[0]))).setLabelSupplier(consumes -> {
            if (this.instance.mode == LoadingRequirementInstance.RequirementMode.IF) {
                return class_2561.method_43471((String)"fancymenu.requirements.screens.build_screen.requirement_mode.normal");
            }
            return class_2561.method_43471((String)"fancymenu.requirements.screens.build_screen.requirement_mode.opposite");
        });
        this.method_37063((class_364)requirementModeButton);
        UIBase.applyDefaultWidgetSkinTo(requirementModeButton);
        this.updateRequirementsList();
        this.setDescription(this.instance.requirement);
    }

    public void method_25419() {
        class_310.method_1551().method_1507(this.parentScreen);
        if (this.isEdit) {
            this.callback.accept(this.instance);
        } else {
            this.callback.accept(null);
        }
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        graphics.method_25294(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());
        class_5250 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
        graphics.method_51439(this.field_22793, (class_2561)titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        graphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"fancymenu.requirements.screens.build_screen.available_requirements"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        class_5250 descLabel = class_2561.method_43471((String)"fancymenu.requirements.screens.build_screen.requirement_description");
        int descLabelWidth = this.field_22793.method_27525((class_5348)descLabel);
        graphics.method_51439(this.field_22793, (class_2561)descLabel, this.field_22789 - 20 - descLabelWidth, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);
        super.method_25394(graphics, mouseX, mouseY, partial);
    }

    public void method_25420(@NotNull class_332 graphics) {
    }

    protected void setDescription(@Nullable LoadingRequirement requirement) {
        this.descriptionScrollArea.clearEntries();
        this.descriptionScrollArea.addEntry(new CellScreen.SpacerScrollAreaEntry(this.descriptionScrollArea, 5));
        if (requirement != null && requirement.getDescription() != null) {
            for (String s : requirement.getDescription()) {
                this.addDescriptionLine((class_2561)class_2561.method_43470((String)s));
            }
        }
        this.descriptionScrollArea.addEntry(new CellScreen.SpacerScrollAreaEntry(this.descriptionScrollArea, 5));
    }

    protected void addDescriptionLine(@NotNull class_2561 line) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        int maxWidth = (int)(this.descriptionScrollArea.getInnerWidth() - 15.0f);
        if (this.field_22793.method_27525((class_5348)line) > maxWidth) {
            this.field_22793.method_27527().method_27495((class_5348)line, maxWidth, class_2583.field_24360).forEach(formatted -> lines.add((class_2561)TextFormattingUtils.convertFormattedTextToComponent(formatted)));
        } else {
            lines.add(line);
        }
        lines.forEach(component -> {
            TextScrollAreaEntry e = new TextScrollAreaEntry(this.descriptionScrollArea, (class_2561)component, entry -> {});
            e.setSelectable(false);
            e.setBackgroundColorHover(e.getBackgroundColorNormal());
            e.setPlayClickSound(false);
            e.setTextBaseColor(UIBase.getUIColorTheme().description_area_text_color.getColorInt());
            this.descriptionScrollArea.addEntry(e);
        });
    }

    protected boolean requirementFitsSearchValue(@NotNull LoadingRequirement requirement, @Nullable String s) {
        if (s == null || s.isBlank()) {
            return true;
        }
        s = s.toLowerCase();
        if (requirement.getDisplayName().toLowerCase().contains(s)) {
            return true;
        }
        return this.requirementDescriptionContains(requirement, s);
    }

    protected boolean requirementDescriptionContains(@NotNull LoadingRequirement requirement, @NotNull String s) {
        List desc = Objects.requireNonNullElse(requirement.getDescription(), new ArrayList());
        for (String line : desc) {
            if (!line.toLowerCase().contains(s)) continue;
            return true;
        }
        return false;
    }

    protected void setContentOfRequirementsList(@Nullable String category) {
        block7: {
            LinkedHashMap<String, List<LoadingRequirement>> categories;
            block6: {
                String searchValue;
                String string = searchValue = this.searchBar != null ? this.searchBar.method_1882() : "";
                if (searchValue.isBlank()) {
                    searchValue = null;
                }
                this.requirementsListScrollArea.clearEntries();
                if (searchValue != null) {
                    List<LoadingRequirement> requirements = LoadingRequirementRegistry.getRequirements();
                    requirements.sort(REQUIREMENT_DISPLAY_NAME_COMPARATOR);
                    for (LoadingRequirement r : requirements) {
                        if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance()) || !this.requirementFitsSearchValue(r, searchValue)) continue;
                        class_5250 class_52502 = class_2561.method_43470((String)r.getDisplayName()).method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
                        RequirementScrollEntry e = new RequirementScrollEntry(this.requirementsListScrollArea, (class_2561)class_52502, UIBase.getUIColorTheme().listing_dot_color_1, entry -> {
                            this.instance.requirement = r;
                            this.setDescription(this.instance.requirement);
                        });
                        e.requirement = r;
                        this.requirementsListScrollArea.addEntry(e);
                    }
                    return;
                }
                categories = LoadingRequirementRegistry.getRequirementsOrderedByCategories();
                categories.values().forEach(list -> list.sort(REQUIREMENT_DISPLAY_NAME_COMPARATOR));
                ArrayList<Map.Entry<String, List<LoadingRequirement>>> sortedCategories = new ArrayList<Map.Entry<String, List<LoadingRequirement>>>(categories.entrySet());
                sortedCategories.sort(Comparator.comparing(entry -> (String)entry.getKey(), String.CASE_INSENSITIVE_ORDER).thenComparing(Map.Entry::getKey));
                if (category != null) break block6;
                for (Map.Entry entry2 : sortedCategories) {
                    class_5250 label = class_2561.method_43470((String)((String)entry2.getKey())).method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
                    TextListScrollAreaEntry e = new TextListScrollAreaEntry(this.requirementsListScrollArea, (class_2561)label, UIBase.getUIColorTheme().listing_dot_color_2, entry -> {
                        this.setContentOfRequirementsList((String)entry2.getKey());
                        this.instance.requirement = null;
                        this.setDescription(null);
                    });
                    e.setSelectable(false);
                    this.requirementsListScrollArea.addEntry(e);
                }
                List<LoadingRequirement> uncategorized = LoadingRequirementRegistry.getRequirementsWithoutCategory();
                uncategorized.sort(REQUIREMENT_DISPLAY_NAME_COMPARATOR);
                for (LoadingRequirement r : uncategorized) {
                    if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance())) continue;
                    class_5250 label = class_2561.method_43470((String)r.getDisplayName()).method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
                    RequirementScrollEntry e = new RequirementScrollEntry(this.requirementsListScrollArea, (class_2561)label, UIBase.getUIColorTheme().listing_dot_color_1, entry -> {
                        this.instance.requirement = r;
                        this.setDescription(this.instance.requirement);
                    });
                    e.requirement = r;
                    this.requirementsListScrollArea.addEntry(e);
                }
                break block7;
            }
            class_5250 backLabel = class_2561.method_43471((String)"fancymenu.requirements.screens.lists.back").method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().warning_text_color.getColorInt()));
            TextListScrollAreaEntry textListScrollAreaEntry = new TextListScrollAreaEntry(this.requirementsListScrollArea, (class_2561)backLabel, UIBase.getUIColorTheme().listing_dot_color_2, entry -> {
                this.setContentOfRequirementsList(null);
                this.instance.requirement = null;
                this.setDescription(null);
            });
            textListScrollAreaEntry.setSelectable(false);
            this.requirementsListScrollArea.addEntry(textListScrollAreaEntry);
            List<LoadingRequirement> l = categories.get(category);
            if (l == null) break block7;
            for (LoadingRequirement r : l) {
                if (LayoutEditorScreen.getCurrentInstance() != null && !r.shouldShowUpInEditorRequirementMenu(LayoutEditorScreen.getCurrentInstance())) continue;
                class_5250 label = class_2561.method_43470((String)r.getDisplayName()).method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().element_label_color_normal.getColorInt()));
                RequirementScrollEntry e = new RequirementScrollEntry(this.requirementsListScrollArea, (class_2561)label, UIBase.getUIColorTheme().listing_dot_color_1, entry -> {
                    this.instance.requirement = r;
                    this.setDescription(this.instance.requirement);
                });
                e.requirement = r;
                this.requirementsListScrollArea.addEntry(e);
            }
        }
    }

    protected void updateRequirementsList() {
        this.setContentOfRequirementsList(null);
        if (this.instance.requirement != null) {
            this.setContentOfRequirementsList(this.instance.requirement.getCategory());
            for (ScrollAreaEntry e : this.requirementsListScrollArea.getEntries()) {
                if (!(e instanceof RequirementScrollEntry) || ((RequirementScrollEntry)e).requirement != this.instance.requirement) continue;
                e.setSelected(true);
                break;
            }
        }
    }

    public class RequirementScrollEntry
    extends TextListScrollAreaEntry {
        public LoadingRequirement requirement;
        protected long lastClickTime;
        protected static final long DOUBLE_CLICK_TIME = 500L;

        public RequirementScrollEntry(@NotNull ScrollArea parent, @NotNull class_2561 text, @NotNull DrawableColor listDotColor, Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, text, listDotColor, onClick);
            this.lastClickTime = 0L;
        }

        @Override
        public void onClick(ScrollAreaEntry entry, double mouseX, double mouseY, int button) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastClickTime < 500L && this.requirement != null && BuildRequirementScreen.this.instance.requirement == this.requirement) {
                if (this.requirement.hasValue()) {
                    BuildRequirementScreen.this.instance.requirement.editValue(BuildRequirementScreen.this, BuildRequirementScreen.this.instance);
                } else {
                    class_310.method_1551().method_1507(BuildRequirementScreen.this.parentScreen);
                    BuildRequirementScreen.this.callback.accept(BuildRequirementScreen.this.instance);
                }
                this.lastClickTime = 0L;
                return;
            }
            this.lastClickTime = currentTime;
            super.onClick(entry, mouseX, mouseY, button);
        }
    }
}

