/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.overlay;

import com.google.common.io.Files;
import de.keksuccino.fancymenu.CreditsScreen;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.customization.ScreenCustomization;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiBaseScreen;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.customization.customgui.ManageCustomGuisScreen;
import de.keksuccino.fancymenu.customization.customgui.ManageOverriddenGuisScreen;
import de.keksuccino.fancymenu.customization.layout.Layout;
import de.keksuccino.fancymenu.customization.layout.LayoutHandler;
import de.keksuccino.fancymenu.customization.layout.ManageLayoutsScreen;
import de.keksuccino.fancymenu.customization.listener.gui.ManageListenersScreen;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlay;
import de.keksuccino.fancymenu.customization.overlay.CustomizationOverlayMenuBar;
import de.keksuccino.fancymenu.customization.overlay.DebugOverlay;
import de.keksuccino.fancymenu.customization.overlay.DebugOverlayBuilder;
import de.keksuccino.fancymenu.customization.screen.dummyscreen.DummyScreenBuilder;
import de.keksuccino.fancymenu.customization.screen.dummyscreen.DummyScreenRegistry;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.variables.ManageVariablesScreen;
import de.keksuccino.fancymenu.util.ListUtils;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.WebUtils;
import de.keksuccino.fancymenu.util.cycle.CommonCycles;
import de.keksuccino.fancymenu.util.cycle.LocalizedEnumValueCycle;
import de.keksuccino.fancymenu.util.cycle.LocalizedGenericValueCycle;
import de.keksuccino.fancymenu.util.cycle.ValueCycle;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.file.ResourceFile;
import de.keksuccino.fancymenu.util.file.type.FileCodec;
import de.keksuccino.fancymenu.util.file.type.FileMediaType;
import de.keksuccino.fancymenu.util.file.type.FileType;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroup;
import de.keksuccino.fancymenu.util.file.type.groups.FileTypeGroups;
import de.keksuccino.fancymenu.util.file.type.types.FileTypes;
import de.keksuccino.fancymenu.util.file.type.types.ImageFileType;
import de.keksuccino.fancymenu.util.input.CharacterFilter;
import de.keksuccino.fancymenu.util.input.TextValidators;
import de.keksuccino.fancymenu.util.rendering.ui.NonStackableOverlayUI;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.menubar.v2.MenuBar;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.NotificationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringListChooserScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.TextInputScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.resource.ResourceChooserScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer.ScrollScreenNormalizer;
import de.keksuccino.fancymenu.util.rendering.ui.screen.scrollnormalizer.ScrollScreenNormalizerHandler;
import de.keksuccino.fancymenu.util.rendering.ui.theme.UIColorTheme;
import de.keksuccino.fancymenu.util.rendering.ui.theme.UIColorThemeRegistry;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.resource.ResourceHandlers;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import de.keksuccino.fancymenu.util.resource.ResourceSourceType;
import de.keksuccino.fancymenu.util.resource.ResourceSupplier;
import de.keksuccino.fancymenu.util.resource.preload.ManageResourcePreLoadScreen;
import de.keksuccino.fancymenu.util.resource.resources.texture.ITexture;
import de.keksuccino.fancymenu.util.threading.MainThreadTaskExecutor;
import de.keksuccino.fancymenu.util.window.WindowHandler;
import de.keksuccino.konkrete.math.MathUtils;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomizationOverlayUI {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceSupplier<ITexture> FM_LOGO_TEXTURE_SUPPLIER = ResourceSupplier.image(ResourceSource.of("fancymenu:textures/menubar/icons/fancymenu_logo.png", ResourceSourceType.LOCATION).getSourceWithPrefix());
    private static final ResourceSupplier<ITexture> LEAVE_SCREEN_TEXTURE_SUPPLIER = ResourceSupplier.image(ResourceSource.of("fancymenu:textures/menubar/icons/exit.png", ResourceSourceType.LOCATION).getSourceWithPrefix());
    private static CustomizationOverlayMenuBar grandfatheredMenuBar = null;

    @NotNull
    public static DebugOverlay buildDebugOverlay(@NotNull MenuBar menuBar) {
        return DebugOverlayBuilder.buildDebugOverlay(menuBar);
    }

    @Nullable
    protected static MenuBar.ContextMenuBarEntry getScreenMenuBarTab() {
        MenuBar.MenuBarEntry tab;
        CustomizationOverlayMenuBar bar = CustomizationOverlay.getCurrentMenuBarInstance();
        if (bar != null && (tab = bar.getEntry("screen")) instanceof MenuBar.ContextMenuBarEntry) {
            MenuBar.ContextMenuBarEntry c = (MenuBar.ContextMenuBarEntry)tab;
            return c;
        }
        return null;
    }

    protected static void forScreenMenuBarTab(Consumer<MenuBar.ContextMenuBarEntry> task) {
        MenuBar.ContextMenuBarEntry tab = CustomizationOverlayUI.getScreenMenuBarTab();
        if (tab != null) {
            MainThreadTaskExecutor.executeInMainThread(() -> task.accept(tab), MainThreadTaskExecutor.ExecuteTiming.PRE_CLIENT_TICK);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected static CustomizationOverlayMenuBar buildMenuBar(boolean expanded) {
        CustomizationOverlayMenuBar grand = grandfatheredMenuBar;
        if (grand != null) {
            grandfatheredMenuBar = null;
            return grand;
        }
        CustomizationOverlayMenuBar menuBar = new CustomizationOverlayMenuBar();
        menuBar.setExpanded(expanded);
        class_437 screen = class_310.method_1551().field_1755;
        String identifier = screen != null ? ScreenIdentifierHandler.getIdentifierOfScreen(screen) : null;
        CustomizationOverlayUI.buildFMIconTabAndAddTo(menuBar);
        ContextMenu customizationMenu = new ContextMenu();
        menuBar.addContextMenuEntry("screen", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization"), customizationMenu);
        ((ContextMenu.ValueCycleContextMenuEntry)((ContextMenu.ValueCycleContextMenuEntry)customizationMenu.addValueCycleEntry("toggle_current_customization", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.customization.current_customization", ScreenCustomization.isCustomizationEnabledForScreen(screen)).addCycleListener(cycle -> MainThreadTaskExecutor.executeInMainThread(() -> {
            grandfatheredMenuBar = CustomizationOverlay.getCurrentMenuBarInstance();
            ScreenCustomization.setCustomizationForScreenEnabled(screen, cycle.getAsBoolean());
            ScreenCustomization.reInitCurrentScreen();
        }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK))).setIsActiveSupplier((menu, entry) -> !(screen instanceof CustomGuiBaseScreen))).setTooltipSupplier((menu, entry) -> {
            if (screen instanceof CustomGuiBaseScreen) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.current_customization.cant_toggle_custom_guis", new String[0]));
            }
            return null;
        })).setIcon(ContextMenu.IconFactory.getIcon("edit"));
        ((ContextMenu.ClickableContextMenuEntry)customizationMenu.addClickableEntry("copy_current_screen_identifier", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.copy_current_screen_identifier"), (menu, entry) -> {
            if (identifier != null) {
                class_310.method_1551().field_1774.method_1455(identifier);
                menu.closeMenu();
            }
        }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.copy_current_screen_identifier.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("copy"));
        ((ContextMenu.ValueCycleContextMenuEntry)customizationMenu.addValueCycleEntry("normalize_current_scroll_screen", CommonCycles.cycleEnabledDisabled("fancymenu.scroll_screen_normalizer", ScrollScreenNormalizerHandler.shouldNormalize(screen)).addCycleListener(cycle -> MainThreadTaskExecutor.executeInMainThread(() -> {
            grandfatheredMenuBar = CustomizationOverlay.getCurrentMenuBarInstance();
            ScrollScreenNormalizerHandler.setForScreen(screen, cycle.getAsBoolean());
            ScreenCustomization.reInitCurrentScreen();
        }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK))).addIsActiveSupplier((menu, entry) -> !ScrollScreenNormalizer.isBlacklisted(screen))).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.scroll_screen_normalizer.desc", new String[0])));
        customizationMenu.addClickableEntry("force_close_current_screen", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.close_current_screen"), (menu, entry) -> {
            menu.closeMenu();
            class_310.method_1551().method_1507(null);
        }).setIcon(ContextMenu.IconFactory.getIcon("exit"));
        customizationMenu.addSeparatorEntry("separator_after_override_current");
        ContextMenu layoutMenu = new ContextMenu();
        customizationMenu.addSubMenuEntry("layouts", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.layout"), layoutMenu).setIcon(ContextMenu.IconFactory.getIcon("layout"));
        ContextMenu layoutNewMenu = new ContextMenu();
        layoutMenu.addSubMenuEntry("new_layout", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.layout.new"), layoutNewMenu).setIcon(ContextMenu.IconFactory.getIcon("add"));
        ((ContextMenu.ClickableContextMenuEntry)layoutNewMenu.addClickableEntry("new_layout_for_current", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.layout.new.current"), (menu, entry) -> {
            if (screen != null) {
                LayoutHandler.openLayoutEditor(new Layout(screen), screen);
            }
        }).setIsActiveSupplier((menu, entry) -> ScreenCustomization.isCustomizationEnabledForScreen(screen))).setTooltipSupplier((menu, entry) -> {
            if (!ScreenCustomization.isCustomizationEnabledForScreen(screen)) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.layout.new.current.disabled.tooltip", new String[0]));
            }
            return null;
        });
        layoutNewMenu.addClickableEntry("new_universal_layout", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.layout.new.universal"), (menu, entry) -> LayoutHandler.openLayoutEditor(new Layout(), null));
        ContextMenu layoutManageMenu = new ContextMenu();
        layoutMenu.addSubMenuEntry("manage_layouts", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.layout.manage"), layoutManageMenu).setIcon(ContextMenu.IconFactory.getIcon("edit"));
        ContextMenu layoutManageCurrentMenu = new ContextMenu();
        ((ContextMenu.SubMenuContextMenuEntry)layoutManageMenu.addSubMenuEntry("manage_layouts_for_current", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.layout.manage.current"), layoutManageCurrentMenu).setIsActiveSupplier((menu, entry) -> ScreenCustomization.isCustomizationEnabledForScreen(screen))).setTooltipSupplier((menu, entry) -> {
            if (!ScreenCustomization.isCustomizationEnabledForScreen(screen)) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.layout.manage.current.disabled.tooltip", new String[0]));
            }
            return null;
        });
        if (identifier != null) {
            int i = 0;
            List<Layout> allLayouts = LayoutHandler.getAllLayoutsForScreenIdentifier(identifier, false);
            int allLayoutsCount = allLayouts.size();
            for (Layout layout : LayoutHandler.sortLayoutListByLastEdited(allLayouts, true, 8)) {
                layoutManageCurrentMenu.addSubMenuEntry("layout_" + i, (class_2561)class_2561.method_43473(), CustomizationOverlayUI.buildManageLayoutSubMenu(layout, List.of("layouts", "manage_layouts", "manage_layouts_for_current"))).setLabelSupplier((menu, entry) -> {
                    class_2583 style = layout.getStatus().getValueComponentStyle();
                    class_5250 c = class_2561.method_43470((String)layout.getLayoutName());
                    c.method_10852((class_2561)class_2561.method_43470((String)" (").method_10862(style));
                    c.method_10852((class_2561)layout.getStatus().getValueComponent());
                    c.method_10852((class_2561)class_2561.method_43470((String)")").method_10862(style));
                    return c;
                });
                ++i;
            }
            if (allLayoutsCount > 8) {
                String moreLayoutCount = "" + (allLayoutsCount - 8);
                layoutManageCurrentMenu.addClickableEntry("x_more_layouts", (class_2561)class_2561.method_43469((String)"fancymenu.overlay.menu_bar.customization.layout.manage.more_layouts", (Object[])new Object[]{moreLayoutCount}), (menu, entry) -> class_310.method_1551().method_1507((class_437)new ManageLayoutsScreen(LayoutHandler.getAllLayoutsForScreenIdentifier(identifier, false), screen, layouts -> class_310.method_1551().method_1507(screen))));
            }
        }
        layoutManageCurrentMenu.addSeparatorEntry("layout.manage.current.separator_1");
        layoutManageCurrentMenu.addClickableEntry("layout_manage_current_all", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.layout.manage.all"), (menu, entry) -> {
            if (identifier != null) {
                class_310.method_1551().method_1507((class_437)new ManageLayoutsScreen(LayoutHandler.getAllLayoutsForScreenIdentifier(identifier, false), screen, layouts -> class_310.method_1551().method_1507(screen)));
            }
        });
        ContextMenu layoutManageUniversalMenu = new ContextMenu();
        layoutManageMenu.addSubMenuEntry("layout_manage_universal", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.layout.manage.universal"), layoutManageUniversalMenu);
        int i = 0;
        List<Layout> allLayouts = LayoutHandler.getAllLayoutsForScreenIdentifier("%fancymenu:universal_layout%", true);
        int allLayoutsCount = allLayouts.size();
        for (Layout l : LayoutHandler.sortLayoutListByLastEdited(allLayouts, true, 8)) {
            layoutManageUniversalMenu.addSubMenuEntry("layout.manage.universal.recent_" + i, (class_2561)class_2561.method_43473(), CustomizationOverlayUI.buildManageLayoutSubMenu(l, List.of("layouts", "manage_layouts", "layout_manage_universal"))).setLabelSupplier((menu, entry) -> {
                class_2583 style = l.getStatus().getValueComponentStyle();
                class_5250 c = class_2561.method_43470((String)l.getLayoutName());
                c.method_10852((class_2561)class_2561.method_43470((String)" (").method_10862(style));
                c.method_10852((class_2561)l.getStatus().getValueComponent());
                c.method_10852((class_2561)class_2561.method_43470((String)")").method_10862(style));
                return c;
            });
            ++i;
        }
        if (allLayoutsCount > 8) {
            String string = "" + (allLayoutsCount - 8);
            layoutManageUniversalMenu.addClickableEntry("x_more_layouts", (class_2561)class_2561.method_43469((String)"fancymenu.overlay.menu_bar.customization.layout.manage.more_layouts", (Object[])new Object[]{string}), (menu, entry) -> class_310.method_1551().method_1507((class_437)new ManageLayoutsScreen(LayoutHandler.getAllLayoutsForScreenIdentifier("%fancymenu:universal_layout%", true), null, layouts -> class_310.method_1551().method_1507(screen))));
        }
        layoutManageUniversalMenu.addSeparatorEntry("layout.manage.universal.separator_1");
        layoutManageUniversalMenu.addClickableEntry("layout.manage.universal.all", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.layout.manage.all"), (menu, entry) -> class_310.method_1551().method_1507((class_437)new ManageLayoutsScreen(LayoutHandler.getAllLayoutsForScreenIdentifier("%fancymenu:universal_layout%", true), null, layouts -> class_310.method_1551().method_1507(screen))));
        layoutMenu.addSeparatorEntry("separator_after_manage_layouts");
        if (identifier != null) {
            boolean bl = false;
            List<Layout> allLayouts2 = LayoutHandler.getAllLayoutsForScreenIdentifier(identifier, false);
            allLayouts2.addAll(LayoutHandler.getAllLayoutsForScreenIdentifier("%fancymenu:universal_layout%", true));
            int allLayoutsCount2 = allLayouts2.size();
            for (Layout layout : LayoutHandler.sortLayoutListByLastEdited(allLayouts2, true, 8)) {
                void var14_23;
                layoutMenu.addSubMenuEntry("layout_" + (int)var14_23, (class_2561)class_2561.method_43473(), CustomizationOverlayUI.buildManageLayoutSubMenu(layout, List.of("layouts"))).setLabelSupplier((menu, entry) -> {
                    class_2583 style = layout.getStatus().getValueComponentStyle();
                    class_5250 c = class_2561.method_43470((String)layout.getLayoutName());
                    c.method_10852((class_2561)class_2561.method_43470((String)" "));
                    if (layout.isUniversalLayout()) {
                        class_5250 universalSuffix = class_2561.method_43471((String)"fancymenu.ui.customization_overlay.layouts.universal_suffix").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
                        c.method_10852((class_2561)universalSuffix);
                    } else {
                        class_5250 normalSuffix = class_2561.method_43471((String)"fancymenu.ui.customization_overlay.layouts.normal_suffix").method_10862(class_2583.field_24360.method_10982(Boolean.valueOf(true)));
                        c.method_10852((class_2561)normalSuffix);
                    }
                    c.method_10852((class_2561)class_2561.method_43470((String)" (").method_10862(style));
                    c.method_10852((class_2561)layout.getStatus().getValueComponent());
                    c.method_10852((class_2561)class_2561.method_43470((String)")").method_10862(style));
                    return c;
                });
                ++var14_23;
            }
            if (allLayoutsCount2 > 8) {
                String moreLayoutCount = "" + (allLayoutsCount2 - 8);
                ((ContextMenu.ContextMenuEntry)layoutMenu.addClickableEntry("x_more_layouts", (class_2561)class_2561.method_43469((String)"fancymenu.overlay.menu_bar.customization.layout.manage.more_layouts", (Object[])new Object[]{moreLayoutCount}), (menu, entry) -> {}).setClickSoundEnabled(false)).setChangeBackgroundColorOnHover(false);
            }
        }
        customizationMenu.addSeparatorEntry("separator_after_layout_menu");
        ContextMenu contextMenu = new ContextMenu();
        customizationMenu.addSubMenuEntry("screen_settings", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.settings"), contextMenu).setIcon(ContextMenu.IconFactory.getIcon("settings"));
        ((ContextMenu.ValueCycleContextMenuEntry)contextMenu.addValueCycleEntry("advanced_customization_mode", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.customization.settings.advanced_customization_mode", FancyMenu.getOptions().advancedCustomizationMode.getValue()).addCycleListener(cycle -> FancyMenu.getOptions().advancedCustomizationMode.setValue(cycle.getAsBoolean()))).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.settings.advanced_customization_mode.tooltip", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("warning"));
        contextMenu.addSeparatorEntry("separator_after_advanced_mode");
        contextMenu.addValueCycleEntry("play_menu_music", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.customization.settings.play_menu_music", FancyMenu.getOptions().playVanillaMenuMusic.getValue()).addCycleListener(cycle -> {
            FancyMenu.getOptions().playVanillaMenuMusic.setValue(cycle.getAsBoolean());
            class_310.method_1551().method_1538().method_4859();
            if (FancyMenu.getOptions().playVanillaMenuMusic.getValue().booleanValue()) {
                class_310.method_1551().method_1538().method_4858(class_310.method_1551().method_1544());
            }
        })).setIcon(ContextMenu.IconFactory.getIcon("sound"));
        ((ContextMenu.ClickableContextMenuEntry)NonStackableOverlayUI.addIntegerInputContextMenuEntryTo(contextMenu, "default_gui_scale", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.settings.set_default_gui_scale"), () -> FancyMenu.getOptions().defaultGuiScale.getValue(), integer -> FancyMenu.getOptions().defaultGuiScale.setValue((Integer)integer), true, FancyMenu.getOptions().defaultGuiScale.getDefaultValue(), null, null, (screen1, s) -> {
            class_310.method_1551().method_1507(screen1);
            CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "default_gui_scale")));
        }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.settings.set_default_gui_scale.tooltip", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("measure"));
        contextMenu.addValueCycleEntry("force_fullscreen", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.customization.settings.force_fullscreen", FancyMenu.getOptions().forceFullscreen.getValue()).addCycleListener(cycle -> FancyMenu.getOptions().forceFullscreen.setValue(cycle.getAsBoolean()))).setIcon(ContextMenu.IconFactory.getIcon("fullscreen"));
        ContextMenu screenSettingsGameIntroMenu = new ContextMenu();
        ((ContextMenu.SubMenuContextMenuEntry)contextMenu.addSubMenuEntry("game_intro", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.settings.game_intro"), screenSettingsGameIntroMenu).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.game_intro.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("video"));
        ResourceSupplier<ITexture> emptyImageSupplier = ResourceSupplier.empty(ITexture.class, FileMediaType.IMAGE);
        FileTypeGroup introFileTypeGroup = FileTypeGroup.of((FileType[])new ImageFileType[]{FileTypes.APNG_IMAGE, FileTypes.GIF_IMAGE, FileTypes.FMA_IMAGE});
        NonStackableOverlayUI.addGenericResourceChooserContextMenuEntryTo(screenSettingsGameIntroMenu, "set_game_intro", () -> new ResourceChooserScreen((class_2561)class_2561.method_43473(), introFileTypeGroup, null, s -> {}), ResourceSupplier::image, emptyImageSupplier, () -> {
            if (FancyMenu.getOptions().gameIntroAnimation.getValue().trim().isEmpty()) {
                return emptyImageSupplier;
            }
            return ResourceSupplier.image(FancyMenu.getOptions().gameIntroAnimation.getValue());
        }, supplier -> {
            FancyMenu.getOptions().gameIntroAnimation.setValue(supplier.getSourceWithPrefix());
            CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "game_intro", "set_game_intro")));
        }, (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.settings.game_intro.set"), true, introFileTypeGroup, null, true, true, false);
        screenSettingsGameIntroMenu.addSeparatorEntry("separator_after_game_intro_set_animation");
        screenSettingsGameIntroMenu.addValueCycleEntry("game_intro_allow_skip", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.customization.settings.game_intro.allow_skip", FancyMenu.getOptions().gameIntroAllowSkip.getValue()).addCycleListener(cycle -> FancyMenu.getOptions().gameIntroAllowSkip.setValue(cycle.getAsBoolean())));
        screenSettingsGameIntroMenu.addValueCycleEntry("game_intro_fade_out", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.customization.settings.game_intro.fade_out", FancyMenu.getOptions().gameIntroFadeOut.getValue()).addCycleListener(cycle -> FancyMenu.getOptions().gameIntroFadeOut.setValue(cycle.getAsBoolean())));
        NonStackableOverlayUI.addInputContextMenuEntryTo(screenSettingsGameIntroMenu, "game_intro_set_custom_skip_text", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.settings.game_intro.set_custom_skip_text"), () -> {
            String s = FancyMenu.getOptions().gameIntroCustomSkipText.getValue();
            if (s.equals("")) {
                return null;
            }
            return s;
        }, s -> FancyMenu.getOptions().gameIntroCustomSkipText.setValue(s != null ? s : ""), true, null, null, false, false, null, null, (screen1, s) -> {
            class_310.method_1551().method_1507(screen1);
            CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "game_intro", "game_intro_set_custom_skip_text")));
        }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.settings.game_intro.set_custom_skip_text.tooltip", new String[0])));
        contextMenu.addSeparatorEntry("separator_after_preload_animations");
        contextMenu.addValueCycleEntry("singleplayer_world_icons", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.customization.settings.singleplayer_screen.world_icons", FancyMenu.getOptions().showSingleplayerScreenWorldIcons.getValue()).addCycleListener(cycle -> FancyMenu.getOptions().showSingleplayerScreenWorldIcons.setValue(cycle.getAsBoolean())));
        contextMenu.addValueCycleEntry("multiplayer_server_icons", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.customization.settings.multiplayer_screen.server_icons", FancyMenu.getOptions().showMultiplayerScreenServerIcons.getValue()).addCycleListener(cycle -> FancyMenu.getOptions().showMultiplayerScreenServerIcons.setValue(cycle.getAsBoolean())));
        contextMenu.addSeparatorEntry("separator_after_mp_server_icons");
        ContextMenu windowIconMenu = new ContextMenu();
        contextMenu.addSubMenuEntry("window_icon", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.settings.custom_window_icon"), windowIconMenu).setIcon(ContextMenu.IconFactory.getIcon("image"));
        ValueCycle windowIconToggleCycle = CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.toggle", FancyMenu.getOptions().showCustomWindowIcon.getValue()).addCycleListener(cycle -> {
            FancyMenu.getOptions().showCustomWindowIcon.setValue(cycle.getAsBoolean());
            if (cycle.getAsBoolean()) {
                WindowHandler.updateCustomWindowIcon();
            } else {
                WindowHandler.resetWindowIcon();
            }
        });
        ((ContextMenu.ValueCycleContextMenuEntry)windowIconMenu.addValueCycleEntry("window_icon_toggle", windowIconToggleCycle).setIsActiveSupplier((menu, entry) -> WindowHandler.allCustomWindowIconsSetAndFound())).setTooltipSupplier((menu, entry) -> !WindowHandler.allCustomWindowIconsSetAndFound() ? Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.toggle.disabled.tooltip", new String[0])) : null);
        FileTypeGroup pngFileGroup = FileTypeGroup.of((FileType[])new ImageFileType[]{FileTypes.PNG_IMAGE});
        pngFileGroup.setDisplayName(FileTypeGroups.IMAGE_GROUP_COMPONENT);
        NonStackableOverlayUI.addFileChooserContextMenuEntryTo(windowIconMenu, "icon_16", (class_2561)class_2561.method_43473(), () -> FancyMenu.getOptions().customWindowIcon16.getValue(), arg_0 -> CustomizationOverlayUI.lambda$buildMenuBar$58((LocalizedEnumValueCycle)windowIconToggleCycle, arg_0), true, FancyMenu.getOptions().customWindowIcon16.getDefaultValue(), null, pngFileGroup, (screen1, file) -> {
            if (file != null) {
                ITexture tex = ResourceHandlers.getImageHandler().get(ResourceSource.of(file.getPath(), ResourceSourceType.LOCAL));
                if (tex != null) {
                    tex.waitForReady(5000L);
                    if (tex.getWidth() != 16 || tex.getHeight() != 16) {
                        class_310.method_1551().method_1507((class_437)NotificationScreen.error(b -> {
                            FancyMenu.getOptions().customWindowIcon16.setValue("");
                            class_310.method_1551().method_1507(screen1);
                            CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "window_icon")));
                        }, LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.wrong_resolution", "16x16")));
                    } else {
                        class_310.method_1551().method_1507(screen1);
                        CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "window_icon")));
                    }
                } else {
                    class_310.method_1551().method_1507(screen1);
                    CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "window_icon")));
                }
            } else {
                class_310.method_1551().method_1507(screen1);
                CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "window_icon")));
            }
        }).setLabelSupplier((menu, entry) -> {
            class_5250 notFound = class_2561.method_43470((String)"\u2716").method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt()));
            class_5250 found = class_2561.method_43470((String)"\u2714").method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().success_text_color.getColorInt()));
            File icon = WindowHandler.getCustomWindowIcon16();
            if (icon != null && icon.isFile()) {
                return class_2561.method_43469((String)"fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.choose_16", (Object[])new Object[]{found});
            }
            return class_2561.method_43469((String)"fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.choose_16", (Object[])new Object[]{notFound});
        });
        NonStackableOverlayUI.addFileChooserContextMenuEntryTo(windowIconMenu, "icon_32", (class_2561)class_2561.method_43473(), () -> FancyMenu.getOptions().customWindowIcon32.getValue(), arg_0 -> CustomizationOverlayUI.lambda$buildMenuBar$67((LocalizedEnumValueCycle)windowIconToggleCycle, arg_0), true, FancyMenu.getOptions().customWindowIcon32.getDefaultValue(), null, pngFileGroup, (screen1, file) -> {
            if (file != null) {
                ITexture tex = ResourceHandlers.getImageHandler().get(ResourceSource.of(file.getPath(), ResourceSourceType.LOCAL));
                if (tex != null) {
                    tex.waitForReady(5000L);
                    if (tex.getWidth() != 32 || tex.getHeight() != 32) {
                        class_310.method_1551().method_1507((class_437)NotificationScreen.error(b -> {
                            FancyMenu.getOptions().customWindowIcon32.setValue("");
                            class_310.method_1551().method_1507(screen1);
                            CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "window_icon")));
                        }, LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.wrong_resolution", "32x32")));
                    } else {
                        class_310.method_1551().method_1507(screen1);
                        CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "window_icon")));
                    }
                } else {
                    class_310.method_1551().method_1507(screen1);
                    CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "window_icon")));
                }
            } else {
                class_310.method_1551().method_1507(screen1);
                CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "window_icon")));
            }
        }).setLabelSupplier((menu, entry) -> {
            class_5250 notFound = class_2561.method_43470((String)"\u2716").method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt()));
            class_5250 found = class_2561.method_43470((String)"\u2714").method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().success_text_color.getColorInt()));
            File icon = WindowHandler.getCustomWindowIcon32();
            if (icon != null && icon.isFile()) {
                return class_2561.method_43469((String)"fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.choose_32", (Object[])new Object[]{found});
            }
            return class_2561.method_43469((String)"fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.choose_32", (Object[])new Object[]{notFound});
        });
        FileTypeGroup macOsIconTypeGroup = FileTypeGroup.of((FileType[])new ImageFileType[]{new ImageFileType(FileCodec.empty(ITexture.class), null, "icns")});
        macOsIconTypeGroup.setDisplayName((class_2561)class_2561.method_43471((String)"fancymenu.file_types.icns"));
        NonStackableOverlayUI.addFileChooserContextMenuEntryTo(windowIconMenu, "icon_macos", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.choose_macos"), () -> FancyMenu.getOptions().customWindowIconMacOS.getValue(), arg_0 -> CustomizationOverlayUI.lambda$buildMenuBar$76((LocalizedEnumValueCycle)windowIconToggleCycle, arg_0), true, FancyMenu.getOptions().customWindowIconMacOS.getDefaultValue(), null, macOsIconTypeGroup, (screen1, file) -> {
            class_310.method_1551().method_1507(screen1);
            CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "window_icon")));
        }).setLabelSupplier((menu, entry) -> {
            class_5250 notFound = class_2561.method_43470((String)"\u2716").method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt()));
            class_5250 found = class_2561.method_43470((String)"\u2714").method_27696(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().success_text_color.getColorInt()));
            File icon = WindowHandler.getCustomWindowIconMacOS();
            if (icon != null && icon.isFile()) {
                return class_2561.method_43469((String)"fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.choose_macos", (Object[])new Object[]{found});
            }
            return class_2561.method_43469((String)"fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.choose_macos", (Object[])new Object[]{notFound});
        });
        windowIconMenu.addSeparatorEntry("separator_after_macos_icon");
        windowIconMenu.addClickableEntry("convert_png_to_macos_icon", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.settings.custom_window_icon.convert_to_macos_icon"), (menu, entry) -> WebUtils.openWebLink("https://miconv.com/convert-png-to-icns/"));
        ((ContextMenu.ClickableContextMenuEntry)NonStackableOverlayUI.addInputContextMenuEntryTo(contextMenu, "window_title", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.settings.custom_window_title"), () -> FancyMenu.getOptions().customWindowTitle.getValue(), s -> {
            FancyMenu.getOptions().customWindowTitle.setValue((String)s);
            WindowHandler.updateWindowTitle();
        }, true, FancyMenu.getOptions().customWindowTitle.getDefaultValue(), null, false, false, TextValidators.NO_EMPTY_STRING_SPACES_ALLOWED_TEXT_VALIDATOR, null, (screen1, s) -> {
            class_310.method_1551().method_1507(screen1);
            CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "window_title")));
        }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.settings.custom_window_title.tooltip", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("text"));
        contextMenu.addSeparatorEntry("separator_after_window_title");
        NonStackableOverlayUI.addLongInputContextMenuEntryTo(contextMenu, "placeholder_caching_duration", (class_2561)class_2561.method_43471((String)"fancymenu.settings.caching.placeholders.set"), () -> FancyMenu.getOptions().placeholderCachingDurationMs.getValue(), duration -> FancyMenu.getOptions().placeholderCachingDurationMs.setValue((Long)duration), true, FancyMenu.getOptions().placeholderCachingDurationMs.getDefaultValue(), null, null, (screen1, s) -> {
            class_310.method_1551().method_1507(screen1);
            CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "placeholder_caching_duration")));
        }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.settings.caching.placeholders.set.desc", new String[0])));
        NonStackableOverlayUI.addLongInputContextMenuEntryTo(contextMenu, "requirement_caching_duration", (class_2561)class_2561.method_43471((String)"fancymenu.settings.caching.requirements.set"), () -> FancyMenu.getOptions().requirementCachingDurationMs.getValue(), duration -> FancyMenu.getOptions().requirementCachingDurationMs.setValue((Long)duration), true, FancyMenu.getOptions().requirementCachingDurationMs.getDefaultValue(), null, null, (screen1, s) -> {
            class_310.method_1551().method_1507(screen1);
            CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("screen_settings", "requirement_caching_duration")));
        }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.settings.caching.requirements.set.desc", new String[0])));
        customizationMenu.addSeparatorEntry("separator_after_settings");
        ContextMenu customGuiMenu = new ContextMenu();
        ((ContextMenu.SubMenuContextMenuEntry)customizationMenu.addSubMenuEntry("custom_guis", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.custom_guis"), customGuiMenu).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.custom_guis.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("gui"));
        customGuiMenu.addClickableEntry("manage_custom_guis", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.custom_guis.manage"), (menu, entry) -> {
            class_437 s = class_310.method_1551().field_1755;
            class_310.method_1551().method_1507((class_437)new ManageCustomGuisScreen(() -> class_310.method_1551().method_1507(s)));
        });
        customGuiMenu.addSeparatorEntry("separator_after_manage_custom_guis");
        ((ContextMenu.ClickableContextMenuEntry)customGuiMenu.addClickableEntry("override_current", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.custom_guis.override_current"), (menu, entry) -> {
            class_437 current = class_310.method_1551().field_1755;
            if (!(current instanceof CustomGuiBaseScreen)) {
                class_310.method_1551().method_1507((class_437)ConfirmationScreen.warning(override -> {
                    if (override.booleanValue()) {
                        class_310.method_1551().method_1507((class_437)new StringListChooserScreen((class_2561)class_2561.method_43471((String)"fancymenu.custom_guis.override.choose_custom"), CustomGuiHandler.getGuiIdentifiers(), s -> {
                            class_437 customInstance = null;
                            if (s != null) {
                                CustomGuiHandler.overrideScreenWithCustomGui(current.getClass().getName(), s);
                                customInstance = CustomGuiHandler.constructInstance(s, null, current);
                            }
                            class_310.method_1551().method_1507(customInstance != null ? customInstance : current);
                        }));
                    } else {
                        class_310.method_1551().method_1507(current);
                    }
                }, LocalizationUtils.splitLocalizedLines("fancymenu.custom_guis.override.confirm", new String[0])));
            }
        }).setIsActiveSupplier((menu, entry) -> FancyMenu.getOptions().advancedCustomizationMode.getValue() != false && !(class_310.method_1551().field_1755 instanceof CustomGuiBaseScreen))).setTooltipSupplier((menu, entry) -> {
            if (!FancyMenu.getOptions().advancedCustomizationMode.getValue().booleanValue()) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.custom_guis.override_current.disabled.tooltip", new String[0]));
            }
            if (class_310.method_1551().field_1755 instanceof CustomGuiBaseScreen) {
                return Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.custom_guis.override_current.cant_override_custom", new String[0]));
            }
            return null;
        });
        customGuiMenu.addClickableEntry("manage_overridden_screens", (class_2561)class_2561.method_43471((String)"fancymenu.custom_guis.manage_overridden"), (menu, entry) -> {
            class_437 s = class_310.method_1551().field_1755;
            class_310.method_1551().method_1507((class_437)new ManageOverriddenGuisScreen(() -> class_310.method_1551().method_1507(s)));
        }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.custom_guis.manage_overridden.desc", new String[0])));
        ((ContextMenu.ClickableContextMenuEntry)customizationMenu.addClickableEntry("variables", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.variables.manage"), (menu, entry) -> {
            ManageVariablesScreen s = new ManageVariablesScreen(call -> class_310.method_1551().method_1507(screen));
            class_310.method_1551().method_1507((class_437)s);
        }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.variables.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("script"));
        customizationMenu.addClickableEntry("manage_listeners", (class_2561)class_2561.method_43471((String)"fancymenu.listeners.manage"), (menu, entry) -> {
            ManageListenersScreen s = new ManageListenersScreen(aBoolean -> class_310.method_1551().method_1507(screen));
            class_310.method_1551().method_1507((class_437)s);
        }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.manage.desc", new String[0])));
        ((ContextMenu.ClickableContextMenuEntry)customizationMenu.addClickableEntry("pre_load_resources", (class_2561)class_2561.method_43471((String)"fancymenu.resources.pre_loading"), (menu, entry) -> {
            class_437 current = class_310.method_1551().field_1755;
            ManageResourcePreLoadScreen s = new ManageResourcePreLoadScreen(aBoolean -> class_310.method_1551().method_1507(current));
            class_310.method_1551().method_1507((class_437)s);
        }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.resources.pre_loading.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("check_list"));
        customizationMenu.addSeparatorEntry("separator_after_pre_load_resources");
        ContextMenu debugOverlayMenu = new ContextMenu();
        ((ContextMenu.SubMenuContextMenuEntry)customizationMenu.addSubMenuEntry("debug_overlay", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.debug"), debugOverlayMenu).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.debug.toggle.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("script"));
        debugOverlayMenu.addValueCycleEntry("toggle_debug_overlay", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.debug.toggle", FancyMenu.getOptions().showDebugOverlay.getValue()).addCycleListener(cycleEnabledDisabled -> {
            FancyMenu.getOptions().showDebugOverlay.setValue(cycleEnabledDisabled.getAsBoolean());
            ScreenCustomization.reInitCurrentScreen();
            CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(List.of("debug_overlay")));
        })).setShortcutTextSupplier((menu, entry) -> class_2561.method_43471((String)"fancymenu.overlay.debug.toggle.shortcut"));
        debugOverlayMenu.addSeparatorEntry("separator_after_toggle_debug_overlay");
        debugOverlayMenu.addValueCycleEntry("toggle_debug_overlay_category_screen_basic", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.debug.basic_screen_category", FancyMenu.getOptions().debugOverlayShowBasicScreenCategory.getValue()).addCycleListener(cycleEnabledDisabled -> {
            FancyMenu.getOptions().debugOverlayShowBasicScreenCategory.setValue(cycleEnabledDisabled.getAsBoolean());
            CustomizationOverlay.rebuildDebugOverlay();
        }));
        debugOverlayMenu.addValueCycleEntry("toggle_debug_overlay_category_screen_advanced", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.debug.advanced_screen_category", FancyMenu.getOptions().debugOverlayShowAdvancedScreenCategory.getValue()).addCycleListener(cycleEnabledDisabled -> {
            FancyMenu.getOptions().debugOverlayShowAdvancedScreenCategory.setValue(cycleEnabledDisabled.getAsBoolean());
            CustomizationOverlay.rebuildDebugOverlay();
        }));
        debugOverlayMenu.addValueCycleEntry("toggle_debug_overlay_category_resources", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.debug.resources_category", FancyMenu.getOptions().debugOverlayShowResourcesCategory.getValue()).addCycleListener(cycleEnabledDisabled -> {
            FancyMenu.getOptions().debugOverlayShowResourcesCategory.setValue(cycleEnabledDisabled.getAsBoolean());
            CustomizationOverlay.rebuildDebugOverlay();
        }));
        debugOverlayMenu.addValueCycleEntry("toggle_debug_overlay_category_system", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.debug.system_category", FancyMenu.getOptions().debugOverlayShowSystemCategory.getValue()).addCycleListener(cycleEnabledDisabled -> {
            FancyMenu.getOptions().debugOverlayShowSystemCategory.setValue(cycleEnabledDisabled.getAsBoolean());
            CustomizationOverlay.rebuildDebugOverlay();
        }));
        ((ContextMenu.ClickableContextMenuEntry)customizationMenu.addClickableEntry("reload_fancymenu", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.reload_fancymenu"), (menu, entry) -> MainThreadTaskExecutor.executeInMainThread(() -> {
            grandfatheredMenuBar = CustomizationOverlay.getCurrentMenuBarInstance();
            ScreenCustomization.reloadFancyMenu();
        }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK)).setShortcutTextSupplier((menu, entry) -> class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.reload_fancymenu.shortcut"))).setIcon(ContextMenu.IconFactory.getIcon("reload"));
        ((ContextMenu.ClickableContextMenuEntry)customizationMenu.addClickableEntry("disable_customization_for_all", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.disable_customization_for_all"), (menu, entry) -> class_310.method_1551().method_1507((class_437)ConfirmationScreen.ofStrings(call -> {
            class_310.method_1551().method_1507(screen);
            if (call.booleanValue()) {
                MainThreadTaskExecutor.executeInMainThread(() -> {
                    grandfatheredMenuBar = CustomizationOverlay.getCurrentMenuBarInstance();
                    ScreenCustomization.disableCustomizationForAllScreens();
                    ScreenCustomization.reInitCurrentScreen();
                }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
            }
        }, LocalizationUtils.splitLocalizedStringLines("fancymenu.overlay.menu_bar.customization.disable_customization_for_all.confirm", new String[0])))).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.disable_customization_for_all.tooltip", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("warning"));
        customizationMenu.addSeparatorEntry("separator_before_hide_menu_bar");
        ((ContextMenu.ClickableContextMenuEntry)customizationMenu.addClickableEntry("hide_menu_bar", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.hide_overlay"), (menu, entry) -> {
            menuBar.closeAllContextMenus();
            class_310.method_1551().method_1507((class_437)ConfirmationScreen.critical(call -> {
                class_310.method_1551().method_1507(screen);
                if (call.booleanValue()) {
                    MainThreadTaskExecutor.executeInMainThread(() -> {
                        FancyMenu.getOptions().showCustomizationOverlay.setValue(FancyMenu.getOptions().showCustomizationOverlay.getValue() == false);
                        ScreenCustomization.reInitCurrentScreen();
                    }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
                }
            }, LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.customization.hide_overlay.confirm", new String[0])).setDelay(4000L));
        }).setShortcutTextSupplier((menu, entry) -> class_2561.method_43471((String)"fancymenu.overlay.menu_bar.customization.hide_overlay.shortcut"))).setIcon(ContextMenu.IconFactory.getIcon("close"));
        ContextMenu toolsMenu = new ContextMenu();
        menuBar.addContextMenuEntry("tools", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.tools"), toolsMenu);
        ContextMenu dummyScreenMenu = new ContextMenu();
        ((ContextMenu.SubMenuContextMenuEntry)toolsMenu.addSubMenuEntry("dummy_screens", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.tools.dummy_screen_instances"), dummyScreenMenu).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.tools.dummy_screen_instances.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("gui"));
        int builderCount = 1;
        for (DummyScreenBuilder builder : DummyScreenRegistry.getBuilders()) {
            ContextMenu.ClickableContextMenuEntry<?> entry3 = dummyScreenMenu.addClickableEntry("builder_" + builderCount, builder.getScreenDisplayName(), (menu, entry2) -> class_310.method_1551().method_1507(builder.tryConstruct()));
            if (builder.getScreenDescriptionSupplier() != null) {
                entry3.setTooltipSupplier((menu, entry1) -> Tooltip.of(builder.getScreenDescriptionSupplier().get().toArray(new class_2561[0])));
            }
            ++builderCount;
        }
        CustomizationOverlayUI.buildUITabAndAddTo(menuBar);
        CustomizationOverlayUI.buildHelpTabAndAddTo(menuBar);
        menuBar.addClickableEntry(MenuBar.Side.RIGHT, "leave_current_screen", (class_2561)class_2561.method_43473(), (bar, entry) -> class_310.method_1551().method_1507(null)).setIconTextureSupplier((bar, entry) -> LEAVE_SCREEN_TEXTURE_SUPPLIER.get()).setTooltipSupplier(consumes -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.leave_current_menu.desc", new String[0])));
        return menuBar;
    }

    public static MenuBar.ClickableMenuBarEntry buildFMIconTabAndAddTo(MenuBar menuBar) {
        return menuBar.addClickableEntry(MenuBar.Side.LEFT, "fancymenu_icon", (class_2561)class_2561.method_43473(), (bar, entry) -> {}).setIconTextureSupplier((bar, entry) -> FM_LOGO_TEXTURE_SUPPLIER.get()).setActive(false);
    }

    public static ContextMenu buildHelpTabAndAddTo(MenuBar menuBar) {
        ContextMenu helpMenu = new ContextMenu();
        menuBar.addContextMenuEntry("help", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.help"), helpMenu);
        ((ContextMenu.ClickableContextMenuEntry)helpMenu.addClickableEntry("fancymenu_wiki", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.help.wiki"), (menu, entry) -> WebUtils.openWebLink("https://docs.fancymenu.net")).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.help.wiki.tooltip", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("book"));
        ((ContextMenu.ClickableContextMenuEntry)helpMenu.addClickableEntry("join_the_discord", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.help.discord"), (menu, entry) -> WebUtils.openWebLink("https://discord.gg/rhayah27GC")).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.help.discord.tooltip", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("talk"));
        helpMenu.addClickableEntry("report_issue", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.help.report_issue"), (menu, entry) -> WebUtils.openWebLink("https://github.com/Keksuccino/FancyMenu/issues")).setIcon(ContextMenu.IconFactory.getIcon("notes"));
        helpMenu.addSeparatorEntry("separator_after_report_issue");
        ((ContextMenu.ClickableContextMenuEntry)helpMenu.addClickableEntry("curseforge_fancymenu_category", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.help.curseforge_fancymenu_category"), (menu, entry) -> WebUtils.openWebLink("https://www.curseforge.com/minecraft/search?page=1&class=customization&categoryIds=5186")).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.help.curseforge_fancymenu_category.tooltip", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("curseforge"));
        helpMenu.addSeparatorEntry("separator_after_curseforge");
        helpMenu.addClickableEntry("keksuccino_patreon", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.help.patreon"), (menu, entry) -> WebUtils.openWebLink("https://www.patreon.com/keksuccino")).setIcon(ContextMenu.IconFactory.getIcon("patreon"));
        helpMenu.addClickableEntry("paypal_tip_jar", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.help.paypal"), (menu, entry) -> WebUtils.openWebLink("https://www.paypal.com/paypalme/TimSchroeter")).setIcon(ContextMenu.IconFactory.getIcon("coin"));
        helpMenu.addSeparatorEntry("separator_after_paypal");
        helpMenu.addClickableEntry("credits", (class_2561)class_2561.method_43471((String)"fancymenu.credits"), (menu, entry) -> class_310.method_1551().method_1507((class_437)new CreditsScreen((class_437)(class_310.method_1551().field_1755 != null ? class_310.method_1551().field_1755 : new class_442()))));
        return helpMenu;
    }

    public static ContextMenu buildUITabAndAddTo(MenuBar menuBar) {
        ContextMenu userInterfaceMenu = new ContextMenu();
        menuBar.addContextMenuEntry("user_interface", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.user_interface"), userInterfaceMenu);
        int preSelectedUiScale = (int)FancyMenu.getOptions().uiScale.getValue().floatValue();
        if (preSelectedUiScale != 1 && preSelectedUiScale != 2 && preSelectedUiScale != 3 && preSelectedUiScale != 4) {
            preSelectedUiScale = 4;
        }
        userInterfaceMenu.addValueCycleEntry("ui_scale", ((LocalizedGenericValueCycle)CommonCycles.cycle("fancymenu.overlay.menu_bar.user_interface.ui_scale", ListUtils.of("1", "2", "3", "4"), "" + preSelectedUiScale).addCycleListener(scaleString -> {
            if (!MathUtils.isFloat((String)scaleString)) {
                scaleString = "4";
            }
            FancyMenu.getOptions().uiScale.setValue(Float.valueOf(scaleString));
            userInterfaceMenu.closeMenu();
        })).setValueNameSupplier(value -> {
            if (value.equals("4")) {
                return class_1074.method_4662((String)"fancymenu.overlay.menu_bar.user_interface.ui_scale.auto", (Object[])new Object[0]);
            }
            return value;
        })).setIcon(ContextMenu.IconFactory.getIcon("measure"));
        userInterfaceMenu.addValueCycleEntry("ui_text_shadow", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.user_interface.ui_text_shadow", FancyMenu.getOptions().enableUiTextShadow.getValue()).addCycleListener(cycle -> FancyMenu.getOptions().enableUiTextShadow.setValue(cycle.getAsBoolean()))).setIcon(ContextMenu.IconFactory.getIcon("shadow"));
        ((ContextMenu.ValueCycleContextMenuEntry)userInterfaceMenu.addValueCycleEntry("ui_click_sounds", CommonCycles.cycleEnabledDisabled("fancymenu.overlay.menu_bar.user_interface.ui_click_sounds", FancyMenu.getOptions().playUiClickSounds.getValue()).addCycleListener(cycle -> {
            if (cycle.getAsBoolean()) {
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            }
            FancyMenu.getOptions().playUiClickSounds.setValue(cycle.getAsBoolean());
        })).setClickSoundEnabled(false)).setIcon(ContextMenu.IconFactory.getIcon("sound"));
        int preSelectedContextHoverOpenSpeed = FancyMenu.getOptions().contextMenuHoverOpenSpeed.getValue();
        if (preSelectedContextHoverOpenSpeed != 1 && preSelectedContextHoverOpenSpeed != 2 && preSelectedContextHoverOpenSpeed != 3) {
            preSelectedContextHoverOpenSpeed = 3;
        }
        ((ContextMenu.ValueCycleContextMenuEntry)userInterfaceMenu.addValueCycleEntry("context_menu_hover_open_speed", CommonCycles.cycle("fancymenu.overlay.menu_bar.user_interface.context_menu_hover_open_speed", ListUtils.of("1", "2", "3"), "" + preSelectedContextHoverOpenSpeed).addCycleListener(speedString -> {
            if (!MathUtils.isInteger((String)speedString)) {
                speedString = "3";
            }
            FancyMenu.getOptions().contextMenuHoverOpenSpeed.setValue(Integer.parseInt(speedString));
        })).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.overlay.menu_bar.user_interface.context_menu_hover_open_speed.desc", new String[0])))).setIcon(ContextMenu.IconFactory.getIcon("timer"));
        ContextMenu windowUiThemeMenu = new ContextMenu();
        userInterfaceMenu.addSubMenuEntry("ui_theme", (class_2561)class_2561.method_43471((String)"fancymenu.overlay.menu_bar.user_interface.ui_theme"), windowUiThemeMenu).setIcon(ContextMenu.IconFactory.getIcon("edit"));
        int i2 = 0;
        for (UIColorTheme s : UIColorThemeRegistry.getThemes()) {
            windowUiThemeMenu.addClickableEntry("ui_theme_" + i2, s.getDisplayName(), (menu, entry) -> {
                FancyMenu.getOptions().uiTheme.setValue(s.getIdentifier());
                UIColorThemeRegistry.setActiveTheme(s.getIdentifier());
            });
            ++i2;
        }
        return userInterfaceMenu;
    }

    @NotNull
    protected static ContextMenu buildManageLayoutSubMenu(Layout layout, @NotNull List<String> entryPath) {
        ContextMenu menu = new ContextMenu();
        class_437 screen = class_310.method_1551().field_1755;
        menu.addClickableEntry("toggle_layout_status", (class_2561)class_2561.method_43473(), (menu1, entry) -> MainThreadTaskExecutor.executeInMainThread(() -> {
            grandfatheredMenuBar = CustomizationOverlay.getCurrentMenuBarInstance();
            layout.setEnabled(!layout.isEnabled(), true);
        }, MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK)).setLabelSupplier((menu1, entry) -> layout.getStatus().getCycleComponent());
        menu.addClickableEntry("edit_layout", (class_2561)class_2561.method_43471((String)"fancymenu.layout.manage.edit"), (menu1, entry) -> {
            menu1.closeMenu();
            MainThreadTaskExecutor.executeInMainThread(() -> LayoutHandler.openLayoutEditor(layout, layout.isUniversalLayout() ? null : screen), MainThreadTaskExecutor.ExecuteTiming.POST_CLIENT_TICK);
        }).setIcon(ContextMenu.IconFactory.getIcon("edit"));
        menu.addClickableEntry("delete_layout", (class_2561)class_2561.method_43471((String)"fancymenu.layout.manage.delete"), (menu1, entry) -> {
            menu1.closeMenu();
            class_310.method_1551().method_1507((class_437)ConfirmationScreen.ofStrings(call -> {
                if (call.booleanValue()) {
                    layout.delete(false);
                }
                class_310.method_1551().method_1507(screen);
                CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(entryPath));
            }, LocalizationUtils.splitLocalizedStringLines("fancymenu.layout.manage.delete.confirm", new String[0])));
        }).setIcon(ContextMenu.IconFactory.getIcon("delete"));
        menu.addClickableEntry("rename_layout", (class_2561)class_2561.method_43471((String)"fancymenu.layout.manage.rename"), (menu1, entry) -> {
            if (layout.layoutFile == null) {
                return;
            }
            menu1.closeMenu();
            class_310.method_1551().method_1507((class_437)TextInputScreen.build((class_2561)class_2561.method_43471((String)"fancymenu.layout.manage.rename"), CharacterFilter.buildLowercaseAndUppercaseFileNameFilter(), s -> {
                if (s != null && !s.isBlank()) {
                    File f;
                    String newName = s + ".txt";
                    Object newPath = layout.layoutFile.getParent();
                    if (newPath == null) {
                        newPath = "";
                    }
                    if (!(f = new File((String)(newPath = (String)newPath + "/" + newName))).isFile()) {
                        try {
                            Files.move((File)layout.layoutFile, (File)f);
                        }
                        catch (Exception ex) {
                            LOGGER.error("[FANCYMENU] Failed to rename layout file!", (Throwable)ex);
                        }
                        LayoutHandler.reloadLayouts();
                        class_310.method_1551().method_1507(screen);
                        CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(entryPath));
                    } else {
                        class_310.method_1551().method_1507((class_437)NotificationScreen.error(aBoolean -> {
                            class_310.method_1551().method_1507(screen);
                            CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(entryPath));
                        }, LocalizationUtils.splitLocalizedLines("fancymenu.layout.manage.rename.error.file_already_exists", new String[0])));
                    }
                } else if (s != null) {
                    class_310.method_1551().method_1507((class_437)NotificationScreen.error(aBoolean -> {
                        class_310.method_1551().method_1507(screen);
                        CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(entryPath));
                    }, LocalizationUtils.splitLocalizedLines("fancymenu.layout.manage.rename.error.empty_name", new String[0])));
                } else {
                    class_310.method_1551().method_1507(screen);
                    CustomizationOverlayUI.forScreenMenuBarTab(contextMenuBarEntry -> contextMenuBarEntry.openContextMenu(entryPath));
                }
            }).setText(layout.getLayoutName()));
        });
        menu.addClickableEntry("edit_in_system_text_editor", (class_2561)class_2561.method_43471((String)"fancymenu.layout.manage.open_in_text_editor"), (menu1, entry) -> {
            if (layout.layoutFile != null) {
                FileUtils.openFile(layout.layoutFile);
            }
        });
        return menu;
    }

    private static /* synthetic */ void lambda$buildMenuBar$76(LocalizedEnumValueCycle windowIconToggleCycle, String s) {
        ResourceFile f = ResourceFile.of(s);
        FancyMenu.getOptions().customWindowIconMacOS.setValue(f.getShortPath());
        FancyMenu.getOptions().showCustomWindowIcon.setValue(false);
        windowIconToggleCycle.setCurrentValue(CommonCycles.CycleEnabledDisabled.DISABLED);
        WindowHandler.resetWindowIcon();
    }

    private static /* synthetic */ void lambda$buildMenuBar$67(LocalizedEnumValueCycle windowIconToggleCycle, String s) {
        ResourceFile f = ResourceFile.of(s);
        FancyMenu.getOptions().customWindowIcon32.setValue(f.getShortPath());
        FancyMenu.getOptions().showCustomWindowIcon.setValue(false);
        windowIconToggleCycle.setCurrentValue(CommonCycles.CycleEnabledDisabled.DISABLED);
        WindowHandler.resetWindowIcon();
    }

    private static /* synthetic */ void lambda$buildMenuBar$58(LocalizedEnumValueCycle windowIconToggleCycle, String s) {
        ResourceFile f = ResourceFile.of(s);
        FancyMenu.getOptions().customWindowIcon16.setValue(f.getShortPath());
        FancyMenu.getOptions().showCustomWindowIcon.setValue(false);
        windowIconToggleCycle.setCurrentValue(CommonCycles.CycleEnabledDisabled.DISABLED);
        WindowHandler.resetWindowIcon();
    }
}

