/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.placeholder.placeholders.advanced;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.keksuccino.fancymenu.customization.placeholder.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.customization.placeholder.Placeholder;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2096;
import net.minecraft.class_2203;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2512;
import net.minecraft.class_2514;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientSideNbtDataGetPlaceholder
extends Placeholder {
    private static final Logger LOGGER = LogManager.getLogger();

    public ClientSideNbtDataGetPlaceholder() {
        super("nbt_data_get");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String sourceType = dps.values.get("source_type");
        String nbtPath = dps.values.get("nbt_path");
        String scaleStr = dps.values.get("scale");
        String returnType = dps.values.get("return_type");
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return "";
        }
        if (sourceType == null || sourceType.isEmpty() || nbtPath == null || nbtPath.isEmpty()) {
            return "";
        }
        if (returnType == null || returnType.isEmpty()) {
            returnType = "value";
        }
        try {
            class_2203.class_2209 path = new class_2203().method_9362(new StringReader(nbtPath));
            class_2487 sourceData = this.getSourceData(sourceType, dps);
            if (sourceData == null) {
                return "";
            }
            List tags = path.method_9366((class_2520)sourceData);
            if (tags.isEmpty()) {
                return "";
            }
            class_2520 tag = (class_2520)tags.get(0);
            if ("string".equalsIgnoreCase(returnType)) {
                return tag.method_10714();
            }
            if ("snbt".equalsIgnoreCase(returnType)) {
                return tag.toString();
            }
            if ("json".equalsIgnoreCase(returnType) && tag instanceof class_2487) {
                String json = class_2561.class_2562.method_10867((class_2561)class_2512.method_32270((class_2520)tag));
                if (json.startsWith("\"") && json.endsWith("\"")) {
                    return json.substring(1, json.length() - 1);
                }
                return json;
            }
            double scale = 1.0;
            if (scaleStr != null && !scaleStr.isEmpty()) {
                try {
                    scale = Double.parseDouble(scaleStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return this.getTagValue(tag, scale);
        }
        catch (Exception e) {
            LOGGER.error("[FANCYMENU] Error in nbt_data_get placeholder", (Throwable)e);
            return "";
        }
    }

    @Nullable
    private class_2487 getSourceData(String sourceType, DeserializedPlaceholderString dps) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        switch (sourceType.toLowerCase(Locale.ROOT)) {
            case "entity": {
                return this.getEntityData(dps);
            }
            case "block": {
                return this.getBlockData(dps);
            }
        }
        return null;
    }

    @Nullable
    private class_2487 getEntityData(DeserializedPlaceholderString dps) {
        String selector = dps.values.get("entity_selector");
        if (selector == null || selector.isEmpty()) {
            return null;
        }
        class_746 player = class_310.method_1551().field_1724;
        class_638 level = class_310.method_1551().field_1687;
        if (player == null || level == null) {
            return null;
        }
        class_1297 targetEntity = this.resolveEntitySelector(selector.trim(), player, level);
        if (targetEntity == null) {
            return null;
        }
        class_2487 tag = new class_2487();
        targetEntity.method_5647(tag);
        return tag;
    }

    @Nullable
    private class_2487 getBlockData(DeserializedPlaceholderString dps) {
        String posStr = dps.values.get("block_pos");
        if (posStr == null || posStr.isEmpty()) {
            return null;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        try {
            int z;
            int y;
            String[] parts = posStr.trim().split("\\s+");
            if (parts.length != 3) {
                return null;
            }
            int x = Integer.parseInt(parts[0]);
            class_2338 pos = new class_2338(x, y = Integer.parseInt(parts[1]), z = Integer.parseInt(parts[2]));
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity != null) {
                return blockEntity.method_38244();
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.error("[FANCYMENU] Invalid block position: {}", (Object)posStr);
        }
        return null;
    }

    private String getTagValue(class_2520 tag, double scale) {
        if (tag instanceof class_2514) {
            class_2514 numericTag = (class_2514)tag;
            if (scale != 1.0) {
                return this.formatScaledNumeric(numericTag, scale);
            }
            return numericTag.method_10714();
        }
        if (tag instanceof class_2519) {
            return tag.method_10714();
        }
        return tag.toString();
    }

    private String formatScaledNumeric(class_2514 tag, double scale) {
        if (tag instanceof class_2494) {
            float value = (float)(tag.method_10697() * scale);
            return Float.toString(value) + "f";
        }
        if (tag instanceof class_2489) {
            double value = tag.method_10697() * scale;
            return Double.toString(value) + "d";
        }
        long rounded = Math.round(tag.method_10697() * scale);
        if (tag instanceof class_2481) {
            return Byte.toString((byte)rounded) + "b";
        }
        if (tag instanceof class_2516) {
            return Short.toString((short)rounded) + "s";
        }
        if (tag instanceof class_2497) {
            return Integer.toString((int)rounded);
        }
        if (tag instanceof class_2503) {
            return Long.toString(rounded) + "L";
        }
        return Long.toString(rounded);
    }

    @Nullable
    private class_1297 resolveEntitySelector(String selector, class_746 player, class_638 level) {
        SelectorTarget target;
        if (!selector.startsWith("@")) {
            return this.resolveByDirectReference(selector, level);
        }
        int bracketIndex = selector.indexOf(91);
        int closingIndex = selector.endsWith("]") ? selector.lastIndexOf(93) : -1;
        String base = bracketIndex == -1 ? selector : selector.substring(0, bracketIndex);
        String optionsRaw = "";
        if (bracketIndex != -1) {
            int end = closingIndex > bracketIndex ? closingIndex : selector.length();
            optionsRaw = selector.substring(bracketIndex + 1, end).trim();
        }
        if ((target = SelectorTarget.fromToken(base.trim())) == null) {
            return this.resolveByDirectReference(selector, level);
        }
        List<OptionValue> options = this.parseSelectorOptions(optionsRaw);
        double defaultX = player.method_23317();
        double defaultY = player.method_23318();
        double defaultZ = player.method_23321();
        Double originX = null;
        Double originY = null;
        Double originZ = null;
        Double dx = null;
        Double dy = null;
        Double dz = null;
        class_2096.class_2099 distance = class_2096.class_2099.field_9705;
        SortOrder sort = target.defaultSort;
        int limit = target.defaultLimit;
        Filter<class_2960> typeFilter = null;
        ArrayList<Filter<String>> nameFilters = new ArrayList<Filter<String>>();
        ArrayList<Filter<String>> tagFilters = new ArrayList<Filter<String>>();
        block32: for (OptionValue option : options) {
            String key = option.key();
            String value = option.value();
            switch (key) {
                case "type": {
                    if (value.isEmpty()) break;
                    boolean inverted = value.startsWith("!");
                    String raw = inverted ? value.substring(1) : value;
                    class_2960 typeId = this.parseResourceLocation(raw);
                    if (typeId == null) continue block32;
                    typeFilter = new Filter<class_2960>(typeId, inverted);
                    break;
                }
                case "name": {
                    if (value.isEmpty()) break;
                    boolean inverted = value.startsWith("!");
                    String raw = inverted ? value.substring(1) : value;
                    if (raw.isEmpty()) continue block32;
                    nameFilters.add(new Filter<String>(raw, inverted));
                    break;
                }
                case "tag": {
                    if (value.isEmpty()) break;
                    boolean inverted = value.startsWith("!");
                    String raw = inverted ? value.substring(1) : value;
                    if (raw.isEmpty()) continue block32;
                    tagFilters.add(new Filter<String>(raw, inverted));
                    break;
                }
                case "limit": {
                    if (value.isEmpty()) break;
                    try {
                        int parsed = Integer.parseInt(value);
                        if (parsed <= 0) continue block32;
                        limit = parsed;
                    }
                    catch (NumberFormatException parsed) {}
                    break;
                }
                case "sort": {
                    if (value.isEmpty()) break;
                    SortOrder parsed = SortOrder.fromOption(value);
                    if (parsed == null) continue block32;
                    sort = parsed;
                    break;
                }
                case "distance": {
                    if (value.isEmpty()) break;
                    try {
                        distance = class_2096.class_2099.method_9049((StringReader)new StringReader(value));
                    }
                    catch (CommandSyntaxException ex) {
                        LOGGER.error("[FANCYMENU] Invalid distance option in selector '{}': {}", (Object)selector, (Object)ex.getMessage());
                    }
                    break;
                }
                case "x": {
                    originX = this.parseCoordinate(value, defaultX);
                    break;
                }
                case "y": {
                    originY = this.parseCoordinate(value, defaultY);
                    break;
                }
                case "z": {
                    originZ = this.parseCoordinate(value, defaultZ);
                    break;
                }
                case "dx": {
                    dx = this.parseDouble(value);
                    break;
                }
                case "dy": {
                    dy = this.parseDouble(value);
                    break;
                }
                case "dz": {
                    dz = this.parseDouble(value);
                    break;
                }
            }
        }
        if (target == SelectorTarget.SELF) {
            class_243 origin = new class_243(originX != null ? originX : defaultX, originY != null ? originY : defaultY, originZ != null ? originZ : defaultZ);
            class_238 bounds = this.buildBounds(origin, dx, dy, dz);
            return this.entityMatchesFilters((class_1297)player, typeFilter, nameFilters, tagFilters, distance, origin, bounds) ? player : null;
        }
        List<class_1297> candidates = this.collectCandidates(target, level);
        if (candidates.isEmpty()) {
            return null;
        }
        class_243 origin = new class_243(originX != null ? originX : defaultX, originY != null ? originY : defaultY, originZ != null ? originZ : defaultZ);
        class_238 bounds = this.buildBounds(origin, dx, dy, dz);
        @Nullable Filter<class_2960> finalTypeFilter = typeFilter;
        class_2096.class_2099 finalDistance = distance;
        candidates.removeIf(entity -> !this.entityMatchesFilters((class_1297)entity, finalTypeFilter, (List<Filter<String>>)nameFilters, (List<Filter<String>>)tagFilters, finalDistance, origin, bounds));
        if (candidates.isEmpty()) {
            return null;
        }
        this.applySorting(candidates, sort, origin);
        if (limit < candidates.size()) {
            candidates = new ArrayList<class_1297>(candidates.subList(0, limit));
        }
        return candidates.isEmpty() ? null : candidates.get(0);
    }

    @Nullable
    private class_1297 resolveByDirectReference(String selector, class_638 level) {
        String trimmed = selector.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(trimmed);
            for (class_1297 entity : this.collectAllEntities(level)) {
                if (!uuid.equals(entity.method_5667())) continue;
                return entity;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        for (class_1297 entity : this.collectAllEntities(level)) {
            if (!entity.method_5477().getString().equals(trimmed)) continue;
            return entity;
        }
        return null;
    }

    private List<class_1297> collectCandidates(SelectorTarget target, class_638 level) {
        List<class_1297> all = this.collectAllEntities(level);
        if (target.includePlayers && target.includeNonPlayers) {
            return new ArrayList<class_1297>(all);
        }
        ArrayList<class_1297> filtered = new ArrayList<class_1297>();
        for (class_1297 entity : all) {
            boolean isPlayer = entity instanceof class_1657;
            if ((!isPlayer || !target.includePlayers) && (isPlayer || !target.includeNonPlayers)) continue;
            filtered.add(entity);
        }
        return filtered;
    }

    private List<class_1297> collectAllEntities(class_638 level) {
        HashSet<Integer> seenIds = new HashSet<Integer>();
        ArrayList<class_1297> result = new ArrayList<class_1297>();
        for (class_1297 entity : level.method_18112()) {
            if (entity == null || !seenIds.add(entity.method_5628())) continue;
            result.add(entity);
        }
        for (class_1657 player : level.method_18456()) {
            if (player == null || !seenIds.add(player.method_5628())) continue;
            result.add((class_1297)player);
        }
        return result;
    }

    private void applySorting(List<class_1297> entities, SortOrder sort, class_243 origin) {
        switch (sort) {
            case NEAREST: {
                entities.sort((a, b) -> Double.compare(a.method_5707(origin), b.method_5707(origin)));
                break;
            }
            case FURTHEST: {
                entities.sort((a, b) -> Double.compare(b.method_5707(origin), a.method_5707(origin)));
                break;
            }
            case RANDOM: {
                for (int i = entities.size() - 1; i > 0; --i) {
                    int j = ThreadLocalRandom.current().nextInt(i + 1);
                    Collections.swap(entities, i, j);
                }
                break;
            }
        }
    }

    private boolean entityMatchesFilters(class_1297 entity, @Nullable Filter<class_2960> typeFilter, List<Filter<String>> nameFilters, List<Filter<String>> tagFilters, class_2096.class_2099 distance, class_243 origin, @Nullable class_238 bounds) {
        boolean matches;
        if (typeFilter != null) {
            Optional targetType = class_7923.field_41177.method_17966(typeFilter.value());
            if (targetType.isPresent()) {
                boolean matches2;
                boolean bl = matches2 = entity.method_5864() == targetType.get();
                if (typeFilter.inverted() == matches2) {
                    return false;
                }
            } else if (!typeFilter.inverted()) {
                return false;
            }
        }
        if (!nameFilters.isEmpty()) {
            String name = entity.method_5477().getString();
            for (Filter<String> filter : nameFilters) {
                matches = name.equals(filter.value());
                if (filter.inverted() != matches) continue;
                return false;
            }
        }
        if (!tagFilters.isEmpty()) {
            Set tags = entity.method_5752();
            for (Filter<String> filter : tagFilters) {
                matches = tags.contains(filter.value());
                if (filter.inverted() != matches) continue;
                return false;
            }
        }
        if (bounds != null && !bounds.method_994(entity.method_5829())) {
            return false;
        }
        return distance == class_2096.class_2099.field_9705 || distance.method_9045(entity.method_5707(origin));
    }

    @Nullable
    private class_238 buildBounds(class_243 origin, @Nullable Double dx, @Nullable Double dy, @Nullable Double dz) {
        if (dx == null && dy == null && dz == null) {
            return null;
        }
        double sizeX = dx != null ? dx : 0.0;
        double sizeY = dy != null ? dy : 0.0;
        double sizeZ = dz != null ? dz : 0.0;
        double minX = Math.min(origin.method_10216(), origin.method_10216() + sizeX);
        double minY = Math.min(origin.method_10214(), origin.method_10214() + sizeY);
        double minZ = Math.min(origin.method_10215(), origin.method_10215() + sizeZ);
        double maxX = Math.max(origin.method_10216(), origin.method_10216() + sizeX);
        double maxY = Math.max(origin.method_10214(), origin.method_10214() + sizeY);
        double maxZ = Math.max(origin.method_10215(), origin.method_10215() + sizeZ);
        return new class_238(minX, minY, minZ, maxX + 1.0, maxY + 1.0, maxZ + 1.0);
    }

    @Nullable
    private Double parseCoordinate(String raw, double reference) {
        if (raw == null || raw.isEmpty()) {
            return reference;
        }
        if (raw.charAt(0) == '~') {
            if (raw.length() == 1) {
                return reference;
            }
            Double offset = this.parseDouble(raw.substring(1));
            return offset == null ? null : Double.valueOf(reference + offset);
        }
        try {
            return Double.parseDouble(raw);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("[FANCYMENU] Invalid coordinate value: {}", (Object)raw);
            return null;
        }
    }

    @Nullable
    private Double parseDouble(String raw) {
        if (raw == null || raw.isEmpty()) {
            return null;
        }
        try {
            return Double.parseDouble(raw);
        }
        catch (NumberFormatException ex) {
            LOGGER.error("[FANCYMENU] Invalid numeric selector option: {}", (Object)raw);
            return null;
        }
    }

    private class_2960 parseResourceLocation(String raw) {
        if (raw == null || raw.isEmpty()) {
            return null;
        }
        Object normalized = raw.contains(":") ? raw : "minecraft:" + raw;
        return class_2960.method_12829((String)((String)normalized).toLowerCase(Locale.ROOT));
    }

    private List<OptionValue> parseSelectorOptions(String raw) {
        ArrayList<OptionValue> result = new ArrayList<OptionValue>();
        if (raw == null || raw.isEmpty()) {
            return result;
        }
        StringBuilder token = new StringBuilder();
        int depth = 0;
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (inQuotes) {
                if (c == quoteChar) {
                    inQuotes = false;
                    continue;
                }
                if (c == '\\' && i + 1 < raw.length()) {
                    token.append(raw.charAt(++i));
                    continue;
                }
                token.append(c);
                continue;
            }
            if (c == '\\' && i + 1 < raw.length()) {
                token.append(raw.charAt(++i));
                continue;
            }
            if (c == '\"' || c == '\'') {
                inQuotes = true;
                quoteChar = c;
                continue;
            }
            if (c == '{' || c == '[' || c == '(') {
                ++depth;
            } else if ((c == '}' || c == ']' || c == ')') && depth > 0) {
                --depth;
            }
            if (c == ',' && depth == 0) {
                this.appendOptionToken(token, result);
                token.setLength(0);
                continue;
            }
            token.append(c);
        }
        this.appendOptionToken(token, result);
        return result;
    }

    private void appendOptionToken(StringBuilder token, List<OptionValue> result) {
        String value;
        String key;
        if (token.isEmpty()) {
            return;
        }
        String entry = token.toString().trim();
        if (entry.isEmpty()) {
            return;
        }
        int index = entry.indexOf(61);
        if (index == -1) {
            key = entry.toLowerCase(Locale.ROOT);
            value = "";
        } else {
            key = entry.substring(0, index).trim().toLowerCase(Locale.ROOT);
            value = entry.substring(index + 1).trim();
        }
        result.add(new OptionValue(key, value));
    }

    @Override
    @Nullable
    public List<String> getValueNames() {
        return List.of("source_type", "entity_selector", "block_pos", "nbt_path", "scale", "return_type");
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return class_1074.method_4662((String)"fancymenu.placeholders.nbt_data_get.client", (Object[])new Object[0]);
    }

    @Override
    @Nullable
    public List<String> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedStringLines("fancymenu.placeholders.nbt_data_get.client.desc", new String[0]));
    }

    @Override
    public String getCategory() {
        return class_1074.method_4662((String)"fancymenu.requirements.categories.advanced", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
        values.put("source_type", "entity");
        values.put("entity_selector", "@s");
        values.put("block_pos", "");
        values.put("nbt_path", "foodLevel");
        values.put("scale", "1.0");
        values.put("return_type", "value");
        return new DeserializedPlaceholderString(this.getIdentifier(), values, "");
    }

    private static enum SelectorTarget {
        SELF("@s", 1, SortOrder.ARBITRARY, true, true),
        NEAREST_PLAYER("@p", 1, SortOrder.NEAREST, true, false),
        ALL_PLAYERS("@a", Integer.MAX_VALUE, SortOrder.ARBITRARY, true, false),
        RANDOM_PLAYER("@r", 1, SortOrder.RANDOM, true, false),
        ALL_ENTITIES("@e", Integer.MAX_VALUE, SortOrder.ARBITRARY, true, true);

        private final String token;
        private final int defaultLimit;
        private final SortOrder defaultSort;
        private final boolean includePlayers;
        private final boolean includeNonPlayers;

        private SelectorTarget(String token, int defaultLimit, SortOrder defaultSort, boolean includePlayers, boolean includeNonPlayers) {
            this.token = token;
            this.defaultLimit = defaultLimit;
            this.defaultSort = defaultSort;
            this.includePlayers = includePlayers;
            this.includeNonPlayers = includeNonPlayers;
        }

        static SelectorTarget fromToken(String token) {
            for (SelectorTarget target : SelectorTarget.values()) {
                if (!target.token.equals(token)) continue;
                return target;
            }
            return null;
        }
    }

    private static enum SortOrder {
        NEAREST("nearest"),
        FURTHEST("furthest"),
        RANDOM("random"),
        ARBITRARY("arbitrary");

        private final String key;

        private SortOrder(String key) {
            this.key = key;
        }

        @Nullable
        static SortOrder fromOption(String value) {
            for (SortOrder order : SortOrder.values()) {
                if (!order.key.equalsIgnoreCase(value)) continue;
                return order;
            }
            return null;
        }
    }

    private record OptionValue(String key, String value) {
    }

    private record Filter<T>(T value, boolean inverted) {
    }
}

