/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Objects;
import net.minecraft.class_34;
import org.jetbrains.annotations.NotNull;

public class LevelData {
    private static final Gson GSON = new GsonBuilder().create();
    public String file_name;
    public String display_name;
    public boolean requires_manual_conversion;
    public boolean locked;
    public boolean experimental;
    public String icon_path;
    public String game_type;
    public String difficulty;
    public boolean allow_commands;
    public String settings_level_name;
    public long last_played;
    public int level_data_version;
    public String minecraft_version_name;
    public boolean snapshot;
    public boolean can_edit;
    public boolean can_recreate;
    public boolean can_delete;

    @NotNull
    public static LevelData fromLevelSummary(@NotNull class_34 summary) {
        LevelData data = new LevelData();
        data.file_name = summary.method_248();
        data.display_name = summary.method_252();
        data.requires_manual_conversion = summary.method_255();
        data.locked = summary.method_27021();
        data.experimental = summary.method_45554();
        data.icon_path = summary.method_27020().toAbsolutePath().toString();
        data.game_type = summary.method_247().method_15434();
        data.difficulty = summary.method_35505().method_27340().method_15434();
        data.allow_commands = summary.method_35505().method_8582();
        data.settings_level_name = summary.method_35505().method_27339();
        data.last_played = summary.method_249();
        data.level_data_version = summary.method_29586().method_29022();
        data.minecraft_version_name = summary.method_29586().method_29025();
        data.snapshot = summary.method_29586().method_29027();
        data.can_edit = false;
        data.can_recreate = false;
        data.can_delete = true;
        return data;
    }

    @NotNull
    public static LevelData deserialize(@NotNull String json) {
        return Objects.requireNonNullElse((LevelData)GSON.fromJson(json, LevelData.class), new LevelData());
    }

    @NotNull
    public String serialize() {
        return GSON.toJson((Object)this);
    }
}

