package de.keksuccino.fancymenu.customization.action.actions.level;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.customgui.CustomGuiHandler;
import de.keksuccino.fancymenu.customization.screen.identifier.ScreenIdentifierHandler;
import de.keksuccino.fancymenu.customization.screen.ScreenInstanceFactory;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_424;
import net.minecraft.class_437;
import net.minecraft.class_442;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisconnectAction extends Action {

    private static final class_2561 SAVING_LEVEL = Components.translatable("menu.savingLevel");

    public DisconnectAction() {
        super("disconnect_server_or_world");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null) {
            class_310 mc = class_310.method_1551();
            try {
                if ((mc.field_1687 != null) && (mc.field_1724 != null)) {
                    class_437 s;
                    if (CustomGuiHandler.guiExists(value)) {
                        s = CustomGuiHandler.constructInstance(value, null, null);
                    } else {
                        s = ScreenInstanceFactory.tryConstruct(ScreenIdentifierHandler.tryFixInvalidIdentifierWithNonUniversal(value));
                    }
                    if (s == null) {
                        s = new class_442();
                    }
                    boolean singlePlayer = mc.method_1542();
                    mc.field_1687.method_8525();
                    if (singlePlayer) {
                        mc.method_18096(new class_424(SAVING_LEVEL));
                    } else {
                        mc.method_18099();
                    }
                    mc.method_1507(s);
                }
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public @NotNull class_2561 getActionDisplayName() {
        return class_2561.method_43471("fancymenu.actions.disconnect");
    }

    @Override
    public @NotNull class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.disconnect.desc");
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43471("fancymenu.actions.disconnect.desc.value");
    }

    @Override
    public String getValueExample() {
        return "example.menu.identifier";
    }

}
