package de.keksuccino.fancymenu.customization.action.actions.level;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.world.LastWorldHandler;
import de.keksuccino.fancymenu.mixin.mixins.common.client.IMixinServerList;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.screen.queueable.QueueableNotificationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.queueable.QueueableScreenHandler;
import de.keksuccino.konkrete.math.MathUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.io.File;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_412;
import net.minecraft.class_424;
import net.minecraft.class_639;
import net.minecraft.class_641;
import net.minecraft.class_642;

public class JoinLastWorldServerAction extends Action {

    private static long lastJoinErrorTrigger = -1;

    public JoinLastWorldServerAction() {
        super("join_last_world");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public void execute(@Nullable String value) {
        if (class_310.method_1551().field_1687 != null) {
            long now = System.currentTimeMillis();
            if ((lastJoinErrorTrigger + 20000) < now) {
                lastJoinErrorTrigger = now;
                QueueableScreenHandler.addToQueue(new QueueableNotificationScreen(class_2561.method_43471("fancymenu.actions.errors.cannot_join_world_while_in_world")));
            }
            return;
        }
        if (!LastWorldHandler.getLastWorld().isEmpty() && (class_310.method_1551().field_1755 != null)) {
            if (!LastWorldHandler.isLastWorldServer()) { // CASE: SINGLEPLAYER WORLD
                File f = new File(LastWorldHandler.getLastWorld());
                if (class_310.method_1551().method_1586().method_230(f.getName())) {
                    class_310.method_1551().method_29970(new class_424(class_2561.method_43471("selectWorld.data_read")));
                    class_310.method_1551().method_41735().method_41894(class_310.method_1551().field_1755, f.getName());
                }
            } else {
                String ipRaw = LastWorldHandler.getLastWorld().replace(" ", "");
                String ip = ipRaw;
                int port = 25565;
                if (ip.contains(":")) {
                    String portString = ip.split(":", 2)[1];
                    ip = ip.split(":", 2)[0];
                    if (MathUtils.isInteger(portString)) {
                        port = Integer.parseInt(portString);
                    }
                }
                class_642 d = null;
                class_641 l = new class_641(class_310.method_1551());
                l.method_2981();
                for (class_642 data : ((IMixinServerList)l).getServerListFancyMenu()) {
                    if (data.field_3761.equals(ipRaw)) {
                        d = data;
                        break;
                    }
                }
                if (d == null) {
                    d = new class_642(ipRaw, ipRaw, false);
                    l.method_2988(d, false);
                    l.method_2987();
                }
                class_412.method_36877(class_310.method_1551().field_1755, class_310.method_1551(), new class_639(ip, port), d);
            }
        }
    }

    @Override
    public @NotNull class_2561 getActionDisplayName() {
        return class_2561.method_43471("fancymenu.actions.join_last_world");
    }

    @Override
    public @NotNull class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.join_last_world.desc");
    }

    @Override
    public class_2561 getValueDisplayName() {
        return null;
    }

    @Override
    public String getValueExample() {
        return null;
    }

}
