package de.keksuccino.fancymenu.customization.action.actions.other;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.util.LocalPlayerUtils;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.text.Components;
import de.keksuccino.konkrete.input.StringUtils;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SendMessageAction extends Action {

    public SendMessageAction() {
        super("sendmessage");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        if (value != null) {
            value = StringUtils.convertFormatCodes(value, "§", "&");
            if ((class_310.method_1551().field_1687 != null) && (class_310.method_1551().field_1724 != null)) {
                if (value.startsWith("/")) {
                    value = value.substring(1);
                    LocalPlayerUtils.sendPlayerCommand(class_310.method_1551().field_1724, value);
                } else {
                    LocalPlayerUtils.sendPlayerChatMessage(class_310.method_1551().field_1724, value);
                }
            }
        }
    }

    @Override
    public @NotNull class_2561 getActionDisplayName() {
        return class_2561.method_43471("fancymenu.actions.sendmessage");
    }

    @Override
    public @NotNull class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.sendmessage.desc");
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43471("fancymenu.actions.sendmessage.desc.value");
    }

    @Override
    public String getValueExample() {
        return "This is an example chat message!";
    }

}
