package de.keksuccino.fancymenu.customization.customgui;

import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.ui.screen.CellScreen;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class ManageCustomGuisScreen extends CellScreen {

    protected Runnable onCloseRunnable;
    protected List<CustomGui> guis = new ArrayList<>();
    @Nullable
    protected CustomGui selected;

    public ManageCustomGuisScreen(@NotNull Runnable onClose) {
        super(class_2561.method_43471("fancymenu.custom_guis.manage"));
        for (CustomGui g : CustomGuiHandler.getGuis()) {
            guis.add(g.copy());
        }
        this.onCloseRunnable = onClose;
    }

    @Override
    protected void initCells() {

        for (CustomGui gui : this.guis) {
            this.addCell(new CustomGuiCell(gui)).setSelectable(true);
        }

        this.addSpacerCell(20);

    }

    @Override
    protected void method_25426() {
        this.selected = null;
        super.method_25426();
    }

    @Override
    protected void initRightSideWidgets() {

        this.addRightSideButton(20, class_2561.method_43471("fancymenu.custom_guis.manage.add"), var1 -> {
            class_437 s = class_310.method_1551().field_1755;
            class_310.method_1551().method_1507(new BuildCustomGuiScreen(null, customGui -> {
                if (customGui != null) this.guis.add(customGui);
                class_310.method_1551().method_1507(s);
            }));
        });

        this.addRightSideDefaultSpacer();

        this.addRightSideButton(20, class_2561.method_43471("fancymenu.custom_guis.manage.open"), var1 -> {
            CustomGui selected = this.selected;
            if (selected != null) {
                CustomGuiHandler.CUSTOM_GUI_SCREENS.clear();
                for (CustomGui g : this.guis) {
                    if (!g.identifier.replace(" ", "").isEmpty()) CustomGuiHandler.CUSTOM_GUI_SCREENS.put(g.identifier, g);
                }
                CustomGuiHandler.saveChanges();
                class_310.method_1551().method_1507(CustomGuiHandler.constructInstance(selected, class_310.method_1551().field_1755, null));
            }
        }).setIsActiveSupplier(consumes -> this.selected != null);

        this.addRightSideButton(20, class_2561.method_43471("fancymenu.custom_guis.manage.edit"), var1 -> {
            class_437 s = class_310.method_1551().field_1755;
            CustomGui selected = this.selected;
            if (selected != null) {
                class_310.method_1551().method_1507(new BuildCustomGuiScreen(selected, customGui -> {
                    class_310.method_1551().method_1507(s);
                }));
            }
        }).setIsActiveSupplier(consumes -> this.selected != null);

        this.addRightSideButton(20, class_2561.method_43471("fancymenu.custom_guis.manage.remove"), var1 -> {
            class_437 s = class_310.method_1551().field_1755;
            CustomGui selected = this.selected;
            if (selected != null) {
                class_310.method_1551().method_1507(ConfirmationScreen.warning(remove -> {
                    if (remove) this.guis.remove(selected);
                    class_310.method_1551().method_1507(s);
                }, LocalizationUtils.splitLocalizedLines("fancymenu.custom_guis.manage.remove.confirm")));
            }
        }).setIsActiveSupplier(consumes -> this.selected != null);

    }

    @Override
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        this.selected = this.getSelectedGui();
        super.render(graphics, mouseX, mouseY, partial);
    }

    @Override
    protected void onCancel() {
        this.onCloseRunnable.run();
    }

    @Override
    protected void onDone() {
        CustomGuiHandler.CUSTOM_GUI_SCREENS.clear();
        for (CustomGui g : this.guis) {
            if (!g.identifier.replace(" ", "").isEmpty()) CustomGuiHandler.CUSTOM_GUI_SCREENS.put(g.identifier, g);
        }
        CustomGuiHandler.saveChanges();
        this.onCloseRunnable.run();
    }

    @Nullable
    protected CustomGui getSelectedGui() {
        RenderCell cell = this.getSelectedCell();
        if (cell instanceof CustomGuiCell c) {
            return c.gui;
        }
        return null;
    }

    public class CustomGuiCell extends LabelCell {

        protected CustomGui gui;

        public CustomGuiCell(@NotNull CustomGui gui) {
            super(class_2561.method_43470(gui.identifier));
            this.gui = gui;
        }

    }

}
