package de.keksuccino.fancymenu.customization.element.elements.button.custombutton;

import de.keksuccino.fancymenu.customization.action.ui.ActionScriptEditorScreen;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.editor.AbstractEditorElement;
import de.keksuccino.fancymenu.customization.element.elements.button.vanillawidget.VanillaWidgetEditorElement;
import de.keksuccino.fancymenu.customization.layout.editor.LayoutEditorScreen;
import de.keksuccino.fancymenu.customization.loadingrequirement.ui.ManageRequirementsScreen;
import de.keksuccino.fancymenu.util.input.TextValidators;
import de.keksuccino.fancymenu.util.rendering.ui.contextmenu.v2.ContextMenu;
import de.keksuccino.fancymenu.util.rendering.ui.tooltip.Tooltip;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.ui.widget.CustomizableSlider;
import org.jetbrains.annotations.NotNull;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4264;

public class ButtonEditorElement extends AbstractEditorElement {

    public boolean showTemplateOptions = true;

    public ButtonEditorElement(@NotNull AbstractElement element, @NotNull LayoutEditorScreen editor) {
        super(element, editor);
    }

    @Override
    public void init() {

        super.init();

        boolean isButton = (this.getElement().getWidget() instanceof class_4264);
        boolean isSlider = (this.getElement().getWidget() instanceof CustomizableSlider);

        this.rightClickMenu.addClickableEntry("manage_actions", class_2561.method_43471("fancymenu.actions.screens.manage_screen.manage"), (menu, entry) -> {
                    ActionScriptEditorScreen s = new ActionScriptEditorScreen(this.getElement().getExecutableBlock(), (call) -> {
                        if (call != null) {
                            this.editor.history.saveSnapshot();
                            this.getElement().actionExecutor = call;
                        }
                        class_310.method_1551().method_1507(this.editor);
                    });
                    class_310.method_1551().method_1507(s);
                }).setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.button.manage_actions.desc")))
                .setIcon(ContextMenu.IconFactory.getIcon("script"))
                .setStackable(false);

        this.rightClickMenu.addClickableEntry("widget_active_state_controller", class_2561.method_43471("fancymenu.elements.button.active_state_controller"), (menu, entry) -> {
                    ManageRequirementsScreen s = new ManageRequirementsScreen(this.getElement().activeStateSupplier.copy(false), (call) -> {
                        if (call != null) {
                            this.editor.history.saveSnapshot();
                            this.getElement().activeStateSupplier = call;
                        }
                        class_310.method_1551().method_1507(this.editor);
                    });
                    class_310.method_1551().method_1507(s);
                })
                .setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.button.active_state_controller.desc")))
                .setStackable(false);

        this.rightClickMenu.addSeparatorEntry("button_separator_1");

        this.addTextureOptions(isButton, isSlider);

        this.addSliderTextureOptionsForTemplateMode();

        this.rightClickMenu.addSeparatorEntry("button_separator_2").setStackable(true);

        if (!isSlider) {

            this.addStringInputContextMenuEntryTo(this.rightClickMenu, "edit_label",
                            ButtonEditorElement.class,
                            consumes -> ((ButtonElement)consumes.element).label,
                            (element1, s) -> ((ButtonElement)element1.element).label = s,
                            null, false, true, class_2561.method_43471(isButton ? "fancymenu.elements.button.editlabel" : "fancymenu.elements.button.label.generic"),
                            true, null, null, null)
                    .setStackable(true)
                    .setIcon(ContextMenu.IconFactory.getIcon("text"));

            this.addStringInputContextMenuEntryTo(this.rightClickMenu, "edit_hover_label",
                            ButtonEditorElement.class,
                            consumes -> ((ButtonElement)consumes.element).hoverLabel,
                            (element1, s) -> ((ButtonElement)element1.element).hoverLabel = s,
                            null, false, true, class_2561.method_43471(isButton ? "fancymenu.elements.button.hoverlabel" : "fancymenu.elements.button.hover_label.generic"),
                            true, null, null, null)
                    .setStackable(true)
                    .setIcon(ContextMenu.IconFactory.getIcon("text"));

            this.rightClickMenu.addSeparatorEntry("button_separator_3").setStackable(true);

        }

        this.addAudioResourceChooserContextMenuEntryTo(this.rightClickMenu, "hover_sound",
                        ButtonEditorElement.class,
                        null,
                        consumes -> consumes.getElement().hoverSound,
                        (buttonEditorElement, supplier) -> buttonEditorElement.getElement().hoverSound = supplier,
                        class_2561.method_43471("fancymenu.elements.button.hoversound"), true, null, true, true, true)
                .setIcon(ContextMenu.IconFactory.getIcon("sound"));

        this.addAudioResourceChooserContextMenuEntryTo(this.rightClickMenu, "click_sound",
                        ButtonEditorElement.class,
                        null,
                        consumes -> consumes.getElement().clickSound,
                        (buttonEditorElement, supplier) -> buttonEditorElement.getElement().clickSound = supplier,
                        class_2561.method_43471("fancymenu.elements.button.clicksound"), true, null, true, true, true)
                .setIcon(ContextMenu.IconFactory.getIcon("sound"));

        this.rightClickMenu.addSeparatorEntry("button_separator_4").setStackable(true);

        this.addGenericStringInputContextMenuEntryTo(this.rightClickMenu, "edit_tooltip",
                        consumes -> (consumes instanceof ButtonEditorElement),
                        consumes -> {
                            String t = ((ButtonElement)consumes.element).tooltip;
                            if (t != null) t = t.replace("%n%", "\n");
                            return t;
                        },
                        (element1, s) -> {
                            if (s != null) {
                                s = s.replace("\n", "%n%");
                            }
                            ((ButtonElement)element1.element).tooltip = s;
                        },
                        null, true, true, class_2561.method_43471("fancymenu.elements.button.tooltip"),
                        true, null, TextValidators.NO_EMPTY_STRING_TEXT_VALIDATOR, null)
                .setStackable(true)
                .setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.button.tooltip.desc")))
                .setIcon(ContextMenu.IconFactory.getIcon("talk"));

        if (!(this instanceof VanillaWidgetEditorElement)) {

            this.rightClickMenu.addSeparatorEntry("separator_before_navigatable");

            this.addToggleContextMenuEntryTo(this.rightClickMenu, "toggle_navigatable", ButtonEditorElement.class,
                            consumes -> consumes.getElement().navigatable,
                            (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().navigatable = aBoolean,
                            "fancymenu.elements.widgets.generic.navigatable")
                    .setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.widgets.generic.navigatable.desc")));

        }

        this.addTemplateOptions();

    }

    protected void addTemplateOptions() {

        ContextMenu templateSettingsMenu = new ContextMenu();

        this.rightClickMenu.addSeparatorEntry("separator_before_template_settings")
                .addIsVisibleSupplier((menu, entry) -> this.showTemplateOptions);

        this.rightClickMenu.addSubMenuEntry("template_settings", class_2561.method_43471("fancymenu.elements.button.template_settings"), templateSettingsMenu)
                .setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.button.template_settings.desc")))
                .addIsVisibleSupplier((menu, entry) -> this.showTemplateOptions);

        this.addToggleContextMenuEntryTo(templateSettingsMenu, "is_template", ButtonEditorElement.class,
                        consumes -> consumes.getElement().isTemplate,
                        (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().isTemplate = aBoolean,
                        "fancymenu.elements.button.is_template")
                .setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.button.template_settings.desc")));

        this.addCycleContextMenuEntryTo(templateSettingsMenu, "share_with", List.of(ButtonElement.TemplateSharing.values()), ButtonEditorElement.class,
                consumes -> consumes.getElement().templateShareWith,
                (buttonEditorElement, templateSharing) -> buttonEditorElement.getElement().templateShareWith = templateSharing,
                (menu, entry, switcherValue) -> switcherValue.getCycleComponent());

        templateSettingsMenu.addSeparatorEntry("separator_after_is_template");

        this.addToggleContextMenuEntryTo(templateSettingsMenu, "template_apply_width", ButtonEditorElement.class,
                consumes -> consumes.getElement().templateApplyWidth,
                (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().templateApplyWidth = aBoolean,
                "fancymenu.elements.button.template_apply_width");

        this.addToggleContextMenuEntryTo(templateSettingsMenu, "template_apply_height", ButtonEditorElement.class,
                consumes -> consumes.getElement().templateApplyHeight,
                (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().templateApplyHeight = aBoolean,
                "fancymenu.elements.button.template_apply_height");

        this.addToggleContextMenuEntryTo(templateSettingsMenu, "template_apply_posx", ButtonEditorElement.class,
                consumes -> consumes.getElement().templateApplyPosX,
                (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().templateApplyPosX = aBoolean,
                "fancymenu.elements.button.template_apply_posx");

        this.addToggleContextMenuEntryTo(templateSettingsMenu, "template_apply_posy", ButtonEditorElement.class,
                consumes -> consumes.getElement().templateApplyPosY,
                (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().templateApplyPosY = aBoolean,
                "fancymenu.elements.button.template_apply_posy");

        this.addToggleContextMenuEntryTo(templateSettingsMenu, "template_apply_opacity", ButtonEditorElement.class,
                consumes -> consumes.getElement().templateApplyOpacity,
                (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().templateApplyOpacity = aBoolean,
                "fancymenu.elements.button.template_apply_opacity");

        this.addToggleContextMenuEntryTo(templateSettingsMenu, "template_apply_visibility", ButtonEditorElement.class,
                consumes -> consumes.getElement().templateApplyVisibility,
                (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().templateApplyVisibility = aBoolean,
                "fancymenu.elements.button.template_apply_visibility");

        this.addToggleContextMenuEntryTo(templateSettingsMenu, "template_apply_label", ButtonEditorElement.class,
                consumes -> consumes.getElement().templateApplyLabel,
                (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().templateApplyLabel = aBoolean,
                "fancymenu.elements.button.template_apply_label");

    }

    protected void addTextureOptions(boolean isButton, boolean isSlider) {

        ContextMenu buttonBackgroundMenu = new ContextMenu();
        if (isSlider || isButton) {
            this.rightClickMenu.addSubMenuEntry("button_background", isButton ? class_2561.method_43471("fancymenu.elements.buttons.buttonbackground") : class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.alternate.slider"), buttonBackgroundMenu)
                    .setIcon(ContextMenu.IconFactory.getIcon("image"))
                    .setStackable(true)
                    .addIsVisibleSupplier((menu, entry) -> !this.getElement().isTemplate || (this.getElement().templateShareWith == ButtonElement.TemplateSharing.BUTTONS));
        }

        ContextMenu setBackMenu = new ContextMenu();
        buttonBackgroundMenu.addSubMenuEntry("set_background", class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.set"), setBackMenu)
                .setStackable(true);

        this.addImageResourceChooserContextMenuEntryTo(setBackMenu, "normal_background_texture",
                ButtonEditorElement.class,
                null,
                consumes -> consumes.getElement().backgroundTextureNormal,
                (buttonEditorElement, iTextureResourceSupplier) -> {
                    buttonEditorElement.getElement().backgroundTextureNormal = iTextureResourceSupplier;
                }, isButton ? class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.normal") : class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.normal.alternate.slider"), true, null, true, true, true);

        this.addImageResourceChooserContextMenuEntryTo(setBackMenu, "hover_background_texture",
                ButtonEditorElement.class,
                null,
                consumes -> consumes.getElement().backgroundTextureHover,
                (buttonEditorElement, iTextureResourceSupplier) -> {
                    buttonEditorElement.getElement().backgroundTextureHover = iTextureResourceSupplier;
                }, isButton ? class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.hover") : class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.hover.alternate.slider"), true, null, true, true, true);

        this.addImageResourceChooserContextMenuEntryTo(setBackMenu, "inactive_background_texture",
                ButtonEditorElement.class,
                null,
                consumes -> consumes.getElement().backgroundTextureInactive,
                (buttonEditorElement, iTextureResourceSupplier) -> {
                    buttonEditorElement.getElement().backgroundTextureInactive = iTextureResourceSupplier;
                }, isButton ? class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.inactive") : class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.inactive.alternate.slider"), true, null, true, true, true);

        buttonBackgroundMenu.addSeparatorEntry("separator_after_set_background").setStackable(true);

        this.addToggleContextMenuEntryTo(buttonBackgroundMenu, "restart_animated_on_hover",
                        ButtonEditorElement.class,
                        consumes -> consumes.getElement().restartBackgroundAnimationsOnHover,
                        (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().restartBackgroundAnimationsOnHover = aBoolean,
                        "fancymenu.elements.buttons.textures.restart_animated_on_hover")
                .setStackable(true);

        buttonBackgroundMenu.addSeparatorEntry("separator_after_restart_animation_on_hover");

        this.addToggleContextMenuEntryTo(buttonBackgroundMenu, "nine_slice_background", ButtonEditorElement.class,
                consumes -> consumes.getElement().nineSliceCustomBackground,
                (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().nineSliceCustomBackground = aBoolean,
                "fancymenu.elements.buttons.textures.nine_slice");

        this.addIntegerInputContextMenuEntryTo(buttonBackgroundMenu, "nine_slice_border_x", ButtonEditorElement.class,
                consumes -> consumes.getElement().nineSliceBorderX,
                (buttonEditorElement, integer) -> buttonEditorElement.getElement().nineSliceBorderX = integer,
                class_2561.method_43471("fancymenu.elements.buttons.textures.nine_slice.border_x"), true, 5, null, null);

        this.addIntegerInputContextMenuEntryTo(buttonBackgroundMenu, "nine_slice_border_y", ButtonEditorElement.class,
                consumes -> consumes.getElement().nineSliceBorderY,
                (buttonEditorElement, integer) -> buttonEditorElement.getElement().nineSliceBorderY = integer,
                class_2561.method_43471("fancymenu.elements.buttons.textures.nine_slice.border_y"), true, 5, null, null);

    }

    protected void addSliderTextureOptionsForTemplateMode() {

        ContextMenu buttonBackgroundMenu = new ContextMenu();
        this.rightClickMenu.addSubMenuEntry("slider_background", class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.alternate.slider"), buttonBackgroundMenu)
                .setIcon(ContextMenu.IconFactory.getIcon("image"))
                .setStackable(false)
                .addIsVisibleSupplier((menu, entry) -> this.getElement().isTemplate && (this.getElement().templateShareWith == ButtonElement.TemplateSharing.SLIDERS));

        ContextMenu setBackMenu = new ContextMenu();
        buttonBackgroundMenu.addSubMenuEntry("set_background", class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.set"), setBackMenu);

        this.addImageResourceChooserContextMenuEntryTo(setBackMenu, "normal_background_texture",
                ButtonEditorElement.class,
                null,
                consumes -> consumes.getElement().backgroundTextureNormal,
                (buttonEditorElement, iTextureResourceSupplier) -> {
                    buttonEditorElement.getElement().backgroundTextureNormal = iTextureResourceSupplier;
                }, class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.normal.alternate.slider"), true, null, true, true, true);

        this.addImageResourceChooserContextMenuEntryTo(setBackMenu, "hover_background_texture",
                ButtonEditorElement.class,
                null,
                consumes -> consumes.getElement().backgroundTextureHover,
                (buttonEditorElement, iTextureResourceSupplier) -> {
                    buttonEditorElement.getElement().backgroundTextureHover = iTextureResourceSupplier;
                }, class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.hover.alternate.slider"), true, null, true, true, true);

        this.addImageResourceChooserContextMenuEntryTo(setBackMenu, "inactive_background_texture",
                ButtonEditorElement.class,
                null,
                consumes -> consumes.getElement().backgroundTextureInactive,
                (buttonEditorElement, iTextureResourceSupplier) -> {
                    buttonEditorElement.getElement().backgroundTextureInactive = iTextureResourceSupplier;
                }, class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.inactive.alternate.slider"), true, null, true, true, true);

        setBackMenu.addSeparatorEntry("separator_before_slider_background_entries");

        this.addImageResourceChooserContextMenuEntryTo(setBackMenu, "normal_slider_background_texture",
                ButtonEditorElement.class,
                null,
                consumes -> consumes.getElement().sliderBackgroundTextureNormal,
                (buttonEditorElement, iTextureResourceSupplier) -> {
                    buttonEditorElement.getElement().sliderBackgroundTextureNormal = iTextureResourceSupplier;
                }, class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.slider.normal"), true, null, true, true, true);

        this.addImageResourceChooserContextMenuEntryTo(setBackMenu, "highlighted_slider_background_texture",
                        ButtonEditorElement.class,
                        null,
                        consumes -> consumes.getElement().sliderBackgroundTextureHighlighted,
                        (buttonEditorElement, iTextureResourceSupplier) -> {
                            buttonEditorElement.getElement().sliderBackgroundTextureHighlighted = iTextureResourceSupplier;
                        }, class_2561.method_43471("fancymenu.elements.buttons.buttonbackground.slider.highlighted"), true, null, true, true, true)
                .setTooltipSupplier((menu, entry) -> Tooltip.of(LocalizationUtils.splitLocalizedLines("fancymenu.elements.buttons.buttonbackground.slider.highlighted.desc")));

        buttonBackgroundMenu.addSeparatorEntry("separator_after_set_texture").setStackable(true);

        this.addToggleContextMenuEntryTo(buttonBackgroundMenu, "restart_animated_on_hover",
                        ButtonEditorElement.class,
                        consumes -> consumes.getElement().restartBackgroundAnimationsOnHover,
                        (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().restartBackgroundAnimationsOnHover = aBoolean,
                        "fancymenu.elements.buttons.textures.restart_animated_on_hover");

        buttonBackgroundMenu.addSeparatorEntry("separator_after_restart_animation_on_hover");

        this.addToggleContextMenuEntryTo(buttonBackgroundMenu, "nine_slice_background", ButtonEditorElement.class,
                consumes -> consumes.getElement().nineSliceCustomBackground,
                (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().nineSliceCustomBackground = aBoolean,
                "fancymenu.elements.buttons.textures.nine_slice");

        this.addIntegerInputContextMenuEntryTo(buttonBackgroundMenu, "nine_slice_border_x", ButtonEditorElement.class,
                consumes -> consumes.getElement().nineSliceBorderX,
                (buttonEditorElement, integer) -> buttonEditorElement.getElement().nineSliceBorderX = integer,
                class_2561.method_43471("fancymenu.elements.buttons.textures.nine_slice.border_x"), true, 5, null, null);

        this.addIntegerInputContextMenuEntryTo(buttonBackgroundMenu, "nine_slice_border_y", ButtonEditorElement.class,
                consumes -> consumes.getElement().nineSliceBorderY,
                (buttonEditorElement, integer) -> buttonEditorElement.getElement().nineSliceBorderY = integer,
                class_2561.method_43471("fancymenu.elements.buttons.textures.nine_slice.border_y"), true, 5, null, null);

        buttonBackgroundMenu.addSeparatorEntry("separator_before_nine_slider_slider_handle_settings");

        this.addToggleContextMenuEntryTo(buttonBackgroundMenu, "nine_slice_slider_handle", ButtonEditorElement.class,
                consumes -> consumes.getElement().nineSliceSliderHandle,
                (buttonEditorElement, aBoolean) -> buttonEditorElement.getElement().nineSliceSliderHandle = aBoolean,
                "fancymenu.elements.slider.v2.handle.textures.nine_slice");

        this.addIntegerInputContextMenuEntryTo(buttonBackgroundMenu, "nine_slice_slider_handle_border_x", ButtonEditorElement.class,
                consumes -> consumes.getElement().nineSliceSliderHandleBorderX,
                (buttonEditorElement, integer) -> buttonEditorElement.getElement().nineSliceSliderHandleBorderX = integer,
                class_2561.method_43471("fancymenu.elements.slider.v2.handle.textures.nine_slice.border_x"), true, 5, null, null);

        this.addIntegerInputContextMenuEntryTo(buttonBackgroundMenu, "nine_slice_slider_handle_border_y", ButtonEditorElement.class,
                consumes -> consumes.getElement().nineSliceSliderHandleBorderY,
                (buttonEditorElement, integer) -> buttonEditorElement.getElement().nineSliceSliderHandleBorderY = integer,
                class_2561.method_43471("fancymenu.elements.slider.v2.handle.textures.nine_slice.border_y"), true, 5, null, null);

    }

    protected ButtonElement getElement() {
        return (ButtonElement) this.element;
    }

}
