package de.keksuccino.fancymenu.customization.element.elements.item;

import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.StringBuilderScreen;
import de.keksuccino.fancymenu.util.rendering.ui.widget.editbox.EditBoxSuggestions;
import org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2378;
import net.minecraft.class_2561;

public class ItemKeyScreen extends StringBuilderScreen {

    @NotNull
    protected String itemKey;

    protected TextInputCell itemKeyCell;
    protected EditBoxSuggestions itemKeySuggestions;

    public ItemKeyScreen(@NotNull String value, @NotNull Consumer<String> callback) {
        super(class_2561.method_43471("fancymenu.elements.item.key"), callback);
        this.itemKey = value;
    }

    @Override
    protected void initCells() {

        this.addSpacerCell(20);

        String key = this.getItemKeyString();
        this.addLabelCell(class_2561.method_43471("fancymenu.elements.item.key.screen.key"));
        this.itemKeyCell = this.addTextInputCell(null, true, true).setText(key);

        this.addCellGroupEndSpacerCell();

        this.itemKeySuggestions = EditBoxSuggestions.createWithCustomSuggestions(this, this.itemKeyCell.editBox, EditBoxSuggestions.SuggestionsRenderPosition.ABOVE_EDIT_BOX, this.getItemKeys());
        UIBase.applyDefaultWidgetSkinTo(this.itemKeySuggestions);
        this.itemKeyCell.editBox.method_1863(s -> this.itemKeySuggestions.method_23934());

        this.addSpacerCell(20);

    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {
        super.render(graphics, mouseX, mouseY, partial);
        this.itemKeySuggestions.method_23923(graphics.pose(), mouseX, mouseY);
    }

    @Override
    public boolean method_25404(int $$0, int $$1, int $$2) {
        if (this.itemKeySuggestions.method_23924($$0, $$1, $$2)) return true;
        return super.method_25404($$0, $$1, $$2);
    }

    @Override
    public boolean method_25401(double $$0, double $$1, double scrollDeltaY) {
        if (this.itemKeySuggestions.method_23921(scrollDeltaY)) return true;
        return super.method_25401($$0, $$1, scrollDeltaY);
    }

    @Override
    public boolean method_25402(double $$0, double $$1, int $$2) {
        if (this.itemKeySuggestions.method_23922($$0, $$1, $$2)) return true;
        return super.method_25402($$0, $$1, $$2);
    }

    @Override
    public @NotNull String buildString() {
        return this.getItemKeyString();
    }

    @NotNull
    protected String getItemKeyString() {
        if (this.itemKeyCell != null) {
            return this.itemKeyCell.getText();
        }
        return this.itemKey;
    }

    @NotNull
    protected List<String> getItemKeys() {
        List<String> keys = new ArrayList<>();
        class_2378.field_11142.method_10235().forEach(location -> keys.add("" + location));
        return keys;
    }

}
