package de.keksuccino.fancymenu.customization.layout;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.util.enums.LocalizedCycleEnum;
import de.keksuccino.fancymenu.util.cycle.ValueCycle;
import de.keksuccino.fancymenu.util.file.FileUtils;
import de.keksuccino.fancymenu.util.rendering.gui.GuiGraphics;
import de.keksuccino.fancymenu.util.rendering.gui.ModernScreen;
import de.keksuccino.fancymenu.util.rendering.ui.UIBase;
import de.keksuccino.fancymenu.util.rendering.ui.screen.ConfirmationScreen;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.ScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextListScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.scroll.v1.scrollarea.entry.TextScrollAreaEntry;
import de.keksuccino.fancymenu.util.rendering.ui.widget.button.ExtendedButton;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class ManageLayoutsScreen extends ModernScreen {

    protected Consumer<List<Layout>> callback;
    protected List<Layout> layouts;
    @Nullable
    protected class_437 layoutTargetScreen;

    protected ValueCycle<Sorting> sortBy = ValueCycle.fromArray(Sorting.LAST_EDITED, Sorting.NAME, Sorting.STATUS);
    protected ScrollArea layoutListScrollArea = new ScrollArea(0, 0, 0, 0);
    protected ExtendedButton sortingButton;
    protected ExtendedButton doneButton;
    protected ExtendedButton editButton;
    protected ExtendedButton deleteButton;
    protected ExtendedButton openInTextEditorButton;
    protected ExtendedButton toggleStatusButton;

    public ManageLayoutsScreen(@NotNull List<Layout> layouts, @Nullable class_437 layoutTargetScreen, @NotNull Consumer<List<Layout>> callback) {

        super(class_2561.method_43471("fancymenu.layout.manage"));

        this.layouts = layouts;
        this.layoutTargetScreen = layoutTargetScreen;
        this.callback = callback;
        this.updateLayoutScrollArea();

    }

    @Override
    protected void method_25426() {

        super.method_25426();

        this.sortingButton = new ExtendedButton(0, 0, 150, this.field_22793.field_2000 + 4, class_2561.method_43470(""), (button) -> {
            this.sortBy.next();
            this.updateLayoutScrollArea();
        }).setLabelSupplier(consumes -> this.sortBy.current().getCycleComponent());
        this.method_25429(this.sortingButton);
        UIBase.applyDefaultWidgetSkinTo(this.sortingButton);

        this.doneButton = new ExtendedButton(0, 0, 150, 20, class_2561.method_43471("fancymenu.common_components.done"), (button) -> {
            this.callback.accept(this.layouts);
        });
        this.method_25429(this.doneButton);
        UIBase.applyDefaultWidgetSkinTo(this.doneButton);

        this.editButton = new ExtendedButton(0, 0, 150, 20, class_2561.method_43471("fancymenu.layout.manage.edit"), (button) -> {
            LayoutScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                LayoutHandler.openLayoutEditor(e.layout, e.layout.isUniversalLayout() ? null : this.layoutTargetScreen);
            }
        }).setIsActiveSupplier(consumes -> (this.getSelectedEntry() != null));
        this.method_25429(this.editButton);
        UIBase.applyDefaultWidgetSkinTo(this.editButton);

        this.deleteButton = new ExtendedButton(0, 0, 150, 20, class_2561.method_43471("fancymenu.layout.manage.delete"), (button) -> {
            LayoutScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                class_310.method_1551().method_1507(ConfirmationScreen.ofStrings(call -> {
                    if (call) {
                        e.layout.delete(false);
                        this.layouts.remove(e.layout);
                        this.updateLayoutScrollArea();
                    }
                    class_310.method_1551().method_1507(this);
                }, LocalizationUtils.splitLocalizedStringLines("fancymenu.layout.manage.delete.confirm")));
            }
        }).setIsActiveSupplier(consumes -> (this.getSelectedEntry() != null));
        this.method_25429(this.deleteButton);
        UIBase.applyDefaultWidgetSkinTo(this.deleteButton);

        this.openInTextEditorButton = new ExtendedButton(0, 0, 150, 20, class_2561.method_43471("fancymenu.layout.manage.open_in_text_editor"), (button) -> {
            LayoutScrollEntry e = this.getSelectedEntry();
            if ((e != null) && (e.layout.layoutFile != null)) {
                FileUtils.openFile(e.layout.layoutFile);
            }
        }).setIsActiveSupplier(consumes -> (this.getSelectedEntry() != null));
        this.method_25429(this.openInTextEditorButton);
        UIBase.applyDefaultWidgetSkinTo(this.openInTextEditorButton);

        this.toggleStatusButton = new ExtendedButton(0, 0, 150, 20, class_2561.method_43470(""), (button) -> {
            LayoutScrollEntry e = this.getSelectedEntry();
            if (e != null) {
                e.layout.setEnabled(!e.layout.isEnabled(), false);
                e.updateName();
            }
        }).setIsActiveSupplier(consumes -> (this.getSelectedEntry() != null))
                .setLabelSupplier(consumes -> {
                    LayoutScrollEntry e = this.getSelectedEntry();
                    if (e != null) return e.layout.getStatus().getCycleComponent();
                    return Layout.LayoutStatus.DISABLED.getCycleComponent();
                });
        this.method_25429(this.toggleStatusButton);
        UIBase.applyDefaultWidgetSkinTo(this.toggleStatusButton);

    }

    @Override
    public void method_25419() {
        this.callback.accept(this.layouts);
    }

    @Override
    public void render(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partial) {

        RenderSystem.enableBlend();

        graphics.fill(0, 0, this.field_22789, this.field_22790, UIBase.getUIColorTheme().screen_background_color.getColorInt());

        class_2561 titleComp = this.field_22785.method_27661().method_27696(class_2583.field_24360.method_10982(true));
        graphics.drawString(this.field_22793, titleComp, 20, 20, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        graphics.drawString(this.field_22793, class_2561.method_43471("fancymenu.layout.manage.layouts"), 20, 50, UIBase.getUIColorTheme().generic_text_base_color.getColorInt(), false);

        this.layoutListScrollArea.setWidth((this.field_22789 / 2) - 40, true);
        this.layoutListScrollArea.setHeight(this.field_22790 - 85, true);
        this.layoutListScrollArea.setX(20, true);
        this.layoutListScrollArea.setY(50 + 15, true);
        this.layoutListScrollArea.render(graphics, mouseX, mouseY, partial);

        this.sortingButton.method_25358(this.field_22793.method_27525(this.sortingButton.method_25369()) + 10);
        this.sortingButton.field_22760 = (this.layoutListScrollArea.getXWithBorder() + this.layoutListScrollArea.getWidthWithBorder() - this.sortingButton.method_25368());
        this.sortingButton.field_22761 = (this.layoutListScrollArea.getYWithBorder() - 5 - this.sortingButton.method_25364());
        this.sortingButton.method_25394(graphics.pose(), mouseX, mouseY, partial);

        this.doneButton.field_22760 = (this.field_22789 - 20 - this.doneButton.method_25368());
        this.doneButton.field_22761 = (this.field_22790 - 20 - 20);
        this.doneButton.method_25394(graphics.pose(), mouseX, mouseY, partial);

        this.openInTextEditorButton.field_22760 = (this.field_22789 - 20 - this.openInTextEditorButton.method_25368());
        this.openInTextEditorButton.field_22761 = (this.doneButton.field_22761 - 15 - 20);
        this.openInTextEditorButton.method_25394(graphics.pose(), mouseX, mouseY, partial);

        this.deleteButton.field_22760 = (this.field_22789 - 20 - this.deleteButton.method_25368());
        this.deleteButton.field_22761 = (this.openInTextEditorButton.field_22761 - 5 - 20);
        this.deleteButton.method_25394(graphics.pose(), mouseX, mouseY, partial);

        this.editButton.field_22760 = (this.field_22789 - 20 - this.editButton.method_25368());
        this.editButton.field_22761 = (this.deleteButton.field_22761 - 5 - 20);
        this.editButton.method_25394(graphics.pose(), mouseX, mouseY, partial);

        this.toggleStatusButton.field_22760 = (this.field_22789 - 20 - this.toggleStatusButton.method_25368());
        this.toggleStatusButton.field_22761 = (this.editButton.field_22761 - 5 - 20);
        this.toggleStatusButton.method_25394(graphics.pose(), mouseX, mouseY, partial);

        super.render(graphics, mouseX, mouseY, partial);

    }

    @Nullable
    protected LayoutScrollEntry getSelectedEntry() {
        for (ScrollAreaEntry e : this.layoutListScrollArea.getEntries()) {
            if (e instanceof LayoutScrollEntry s) {
                if (s.isSelected()) return s;
            }
        }
        return null;
    }

    protected void updateLayoutScrollArea() {
        this.layoutListScrollArea.clearEntries();
        if (this.sortBy.current() == Sorting.STATUS) {
            LayoutHandler.sortLayoutListByStatus(this.layouts, false);
        } else if (this.sortBy.current() == Sorting.NAME) {
            LayoutHandler.sortLayoutListByName(this.layouts);
        } else if (this.sortBy.current() == Sorting.LAST_EDITED) {
            LayoutHandler.sortLayoutListByLastEdited(this.layouts, false);
        }
        for (Layout l : this.layouts) {
            LayoutScrollEntry e = new LayoutScrollEntry(this.layoutListScrollArea, l, (entry) -> {
            });
            this.layoutListScrollArea.addEntry(e);
        }
        if (this.layoutListScrollArea.getEntries().isEmpty()) {
            this.layoutListScrollArea.addEntry(new TextScrollAreaEntry(this.layoutListScrollArea, class_2561.method_43471("fancymenu.layout.manage.no_layouts_found").method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().error_text_color.getColorInt())), (entry) -> {}));
        }
    }

    public static class LayoutScrollEntry extends TextListScrollAreaEntry {

        public Layout layout;

        public LayoutScrollEntry(ScrollArea parent, @NotNull Layout layout, @NotNull Consumer<TextListScrollAreaEntry> onClick) {
            super(parent, class_2561.method_43470(""), UIBase.getUIColorTheme().listing_dot_color_1.getColor(), onClick);
            this.layout = layout;
            this.updateName();
        }

        protected void updateName() {
            class_2583 style = this.layout.getStatus().getValueComponentStyle();
            class_5250 c = class_2561.method_43470(layout.getLayoutName()).method_10862(class_2583.field_24360.method_36139(UIBase.getUIColorTheme().description_area_text_color.getColorInt()));
            c.method_10852(class_2561.method_43470(" (").method_10862(style));
            c.method_10852(this.layout.getStatus().getValueComponent());
            c.method_10852(class_2561.method_43470(")").method_10862(style));
            this.setText(c);
        }

    }

    protected enum Sorting implements LocalizedCycleEnum<Sorting> {

        NAME("name"),
        LAST_EDITED("last_edited"),
        STATUS("status");

        final String name;

        Sorting(String name) {
            this.name = name;
        }

        @Override
        public @NotNull String getLocalizationKeyBase() {
            return "fancymenu.layout.manage.layouts.sort_by";
        }

        @Override
        public @NotNull String getName() {
            return this.name;
        }

        @Override
        public @NotNull Sorting[] getValues() {
            return Sorting.values();
        }

        @Override
        public @Nullable Sorting getByNameInternal(@NotNull String name) {
            return getByName(name);
        }

        @Nullable
        public static Sorting getByName(@NotNull String name) {
            for (Sorting e : Sorting.values()) {
                if (e.getName().equals(name)) return e;
            }
            return null;
        }

    }

}
